/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.combatanalytics;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.OptionPanelAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.combat.EngagementResultAPI;
import data.scripts.combatanalytics.IntelCombatReport;
import data.scripts.combatanalytics.SerializationManager;
import data.scripts.combatanalytics.data.CombatResult;
import data.scripts.combatanalytics.util.Localization;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class InteractionDialogPlugin
implements com.fs.starfarer.api.campaign.InteractionDialogPlugin {
    private static final Logger log = Global.getLogger(InteractionDialogPlugin.class);
    private static final String NEW_LINE = "\n";
    private static final String Leave = "Leave";
    private static final String Init = "Init";
    private InteractionDialogAPI dialog;
    private TextPanelAPI textPanel;
    private boolean paused;

    public void init(InteractionDialogAPI dialog) {
        this.paused = Global.getSector().isPaused();
        this.dialog = dialog;
        this.textPanel = dialog.getTextPanel();
        OptionPanelAPI options = dialog.getOptionPanel();
        dialog.hideVisualPanel();
        options.clearOptions();
        this.textPanel.clear();
        List<CombatResult> combatResults = SerializationManager.getAllSavedCombatResultsNoSimulation();
        if (combatResults.size() >= 5) {
            options.addOption(Localization.LastFiveBattles, combatResults.subList(0, 5), null);
        }
        if (combatResults.size() >= 10) {
            options.addOption(Localization.LastTenBattles, combatResults.subList(0, 10), null);
        }
        if (combatResults.size() > 0) {
            options.addOption(Localization.AllBattles, combatResults, null);
        }
        options.addOption(Leave, (Object)Leave, null);
        dialog.setOptionOnEscape(Leave, (Object)Leave);
        this.optionSelected(Init, combatResults);
    }

    public void backFromEngagement(EngagementResultAPI result) {
    }

    public void optionSelected(String text, Object optionData) {
        if (text.equals(Init)) {
            List combatResults = (List)optionData;
            if (combatResults.size() > 0) {
                this.addText(Localization.ChooseData);
            } else {
                this.addText(Localization.NoData);
            }
            return;
        }
        if (optionData instanceof List) {
            List combatResults = (List)optionData;
            IntelCombatReport icr = new IntelCombatReport(combatResults.toArray(new CombatResult[0]));
            Global.getSector().getIntelManager().addIntel((IntelInfoPlugin)icr);
            log.debug((Object)("Created combat report from " + combatResults.size() + " Combat Results"));
        }
        Global.getSector().setPaused(this.paused);
        this.dialog.dismiss();
    }

    private void addText(String text) {
        for (String s : text.split(NEW_LINE)) {
            this.textPanel.addParagraph(s);
        }
    }

    public void optionMousedOver(String optionText, Object optionData) {
    }

    public void advance(float amount) {
    }

    public Object getContext() {
        return null;
    }

    public Map<String, MemoryAPI> getMemoryMap() {
        return null;
    }
}

