/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.combatanalytics;

import com.fs.starfarer.api.Global;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.StaxDriver;
import data.scripts.combatanalytics.data.CombatGoal;
import data.scripts.combatanalytics.data.CombatResult;
import data.scripts.combatanalytics.data.Ship;
import data.scripts.combatanalytics.data.WeaponCountingDamage;
import data.scripts.combatanalytics.data.WeaponSet;
import data.scripts.combatanalytics.data.WeaponShipDamage;
import data.scripts.combatanalytics.util.Base64;
import data.scripts.combatanalytics.util.CompressionUtil;
import data.scripts.combatanalytics.util.Helpers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class SerializationManager {
    private static final String COMBATRESULTS_KEY = "CombatAnalytics_CombatResults_V4";
    private static final String COMBATRESULTS_KEY_OLD = "CombatAnalytics_CombatResults_V3";
    private static final String SHIP_KEY_OLD = "CombatAnalytics_Ships_V3";
    private static final String WEAPONDAMAGE_KEY_OLD = "CombatAnalytics_WeaponDamage_V3";
    private static final Logger log = Global.getLogger(SerializationManager.class);
    static Map<String, Object> overridePersistentData = null;
    public static boolean dataIsCorrupt = false;
    private static List<CombatResult> _resultCache = null;

    public static void saveCombatResult(CombatResult cr) {
        try {
            List<CombatResult> combatResults = SerializationManager.getAllSavedCombatResults();
            combatResults.add(cr);
            Collections.sort(combatResults);
            String rawCombatResults = SerializationManager.getSerializer().toXML(combatResults);
            SerializationManager.saveValue(COMBATRESULTS_KEY, rawCombatResults);
        }
        catch (Throwable e) {
            log.error((Object)"Unable to save combat result", e);
            Helpers.printErrorMessage("Unable to save combat result");
        }
    }

    public static void onGameLoad() {
        SerializationManager.clearCache();
        dataIsCorrupt = false;
        Map<String, Object> pd = SerializationManager.getPersistentData();
        pd.remove(SHIP_KEY_OLD);
        pd.remove(WEAPONDAMAGE_KEY_OLD);
        pd.remove(COMBATRESULTS_KEY_OLD);
    }

    public static void clearSavedData() {
        SerializationManager.saveValue(COMBATRESULTS_KEY, "");
        dataIsCorrupt = false;
        SerializationManager.clearCache();
    }

    private static void saveValue(String key, String value) {
        value = SerializationManager.compress(value);
        SerializationManager.getPersistentData().put(key, value);
    }

    static String compress(String s) {
        int originalSize = s.length();
        byte[] compressedString = CompressionUtil.compress(s);
        return Base64.convert(compressedString);
    }

    static String decompress(String s) {
        if (s == null) {
            return null;
        }
        byte[] bytes = Base64.convert(s);
        return CompressionUtil.decompress(bytes);
    }

    public static long sizeOfSavedDataInBytes() {
        long ret = 0L;
        String rawValues = (String)SerializationManager.getPersistentData().get(COMBATRESULTS_KEY);
        if (rawValues != null) {
            ret += (long)rawValues.length();
        }
        return ret * 2L;
    }

    public static List<CombatResult> getSavedCombatResults(Set<String> combatResultIds) {
        return SerializationManager.getSavedCombatResults(new CombatResultFilter(combatResultIds));
    }

    public static List<CombatResult> getAllSavedCombatResultsNoSimulation() {
        List<CombatResult> allCombats = SerializationManager.getAllSavedCombatResults();
        ArrayList<CombatResult> ret = new ArrayList<CombatResult>(allCombats.size());
        for (CombatResult cr : allCombats) {
            if (cr.enemyFleetGoal == CombatGoal.SIMULATION) continue;
            ret.add(cr);
        }
        return ret;
    }

    public static void clearCache() {
        _resultCache = null;
    }

    private static XStream getSerializer() {
        XStream x = new XStream((ReflectionProvider)new PureJavaReflectionProvider(), (HierarchicalStreamDriver)new StaxDriver(), SerializationManager.class.getClassLoader());
        x.alias("CombatResult", CombatResult.class);
        x.alias("Ship", Ship.class);
        x.aliasAttribute(Ship.class, "deploymentPoints", "dp");
        x.aliasAttribute(Ship.class, "captainSprite", "cs");
        x.aliasAttribute(Ship.class, "weaponSets", "ws");
        x.aliasAttribute(Ship.class, "remainingHp", "rhp");
        x.aliasAttribute(Ship.class, "maxHp", "mhp");
        x.alias("WeaponSet", WeaponSet.class);
        x.aliasAttribute(WeaponSet.class, "weapon", "w");
        x.aliasAttribute(WeaponSet.class, "count", "c");
        x.aliasAttribute(WeaponSet.class, "ordnancePointsPer", "o");
        x.alias("WSD", WeaponShipDamage.class);
        x.aliasAttribute(WeaponShipDamage.class, "source", "s");
        x.aliasAttribute(WeaponShipDamage.class, "target", "t");
        x.aliasAttribute(WeaponShipDamage.class, "weapon", "w");
        x.aliasAttribute(WeaponShipDamage.class, "hits", "h");
        x.aliasAttribute(WeaponShipDamage.class, "shieldDamage", "sd");
        x.aliasAttribute(WeaponShipDamage.class, "armorDamage", "ad");
        x.aliasAttribute(WeaponShipDamage.class, "hullDamage", "hd");
        x.aliasAttribute(WeaponShipDamage.class, "empDamage", "ed");
        x.aliasAttribute(WeaponShipDamage.class, "pctOfDamageDoneToTarget", "p");
        x.aliasAttribute(WeaponShipDamage.class, "killingBlow", "k");
        x.alias("WCD", WeaponCountingDamage.class);
        x.aliasAttribute(WeaponCountingDamage.class, "source", "s");
        x.aliasAttribute(WeaponCountingDamage.class, "weapon", "w");
        x.aliasAttribute(WeaponCountingDamage.class, "missileKills", "mk");
        x.aliasAttribute(WeaponCountingDamage.class, "fighterKills", "fk");
        return x;
    }

    public static List<CombatResult> getAllSavedCombatResults() {
        if (_resultCache == null) {
            long loadTimeInMs = System.currentTimeMillis();
            try {
                List combatResults;
                XStream xStream = SerializationManager.getSerializer();
                String rawValues = (String)SerializationManager.getPersistentData().get(COMBATRESULTS_KEY);
                String rawCombatResults = SerializationManager.decompress(rawValues);
                if (rawCombatResults == null || rawCombatResults.length() == 0) {
                    combatResults = new ArrayList();
                    rawCombatResults = "";
                    rawValues = "";
                } else {
                    combatResults = (List)xStream.fromXML(rawCombatResults);
                }
                Collections.sort(combatResults);
                _resultCache = combatResults;
                loadTimeInMs = System.currentTimeMillis() - loadTimeInMs;
                long compressedSize = rawValues.length();
                long decompressedSize = rawCombatResults.length();
                double compression = (double)compressedSize / (double)decompressedSize;
                int compressionPercent = (int)(compression * 100.0);
                log.info((Object)("Loaded " + _resultCache.size() + " prior battle results using " + Helpers.TWO_DIGIT_NO_GROUP_FORMAT.format((double)SerializationManager.sizeOfSavedDataInBytes() / 1048576.0) + "MB in save file (" + compressionPercent + "% of original size from compression) in " + loadTimeInMs + "ms"));
            }
            catch (Throwable e) {
                dataIsCorrupt = true;
                log.error((Object)"Unable to load SavedCombatResults", e);
                Helpers.printErrorMessage("Error loading saved combat results");
                return new ArrayList<CombatResult>();
            }
        }
        return _resultCache;
    }

    private static List<CombatResult> getSavedCombatResults(CombatResultFilter filter) {
        List<CombatResult> all = SerializationManager.getAllSavedCombatResults();
        ArrayList<CombatResult> ret = new ArrayList<CombatResult>(all.size());
        for (CombatResult cr : all) {
            if (!filter.isCombatResultValid(cr.combatId)) continue;
            ret.add(cr);
        }
        return ret;
    }

    private static Map<String, Object> getPersistentData() {
        if (overridePersistentData != null) {
            return overridePersistentData;
        }
        return Global.getSector().getPersistentData();
    }

    private static class CombatResultFilter {
        private final Set<String> _combatResultIds;

        CombatResultFilter(Set<String> combatResultIds) {
            this._combatResultIds = combatResultIds;
        }

        CombatResultFilter() {
            this._combatResultIds = null;
        }

        public boolean isCombatResultValid(String combatResult) {
            return this._combatResultIds == null || this._combatResultIds.contains(combatResult);
        }
    }

    private static class StringInterner {
        private final HashMap<String, String> _internMap = new HashMap(1000);

        private StringInterner() {
        }

        public String intern(String s) {
            String ret = this._internMap.get(s);
            if (ret == null) {
                this._internMap.put(s, s);
                ret = s;
            }
            return ret;
        }

        public void internElements(String[] arr) {
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = this.intern(arr[i]);
            }
        }

        public String toString() {
            return "StringInterner{InternMapSize=" + this._internMap.size() + "}";
        }
    }
}

