/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.combatanalytics;

import com.fs.starfarer.api.ui.TooltipMakerAPI;
import data.scripts.combatanalytics.data.Ship;
import data.scripts.combatanalytics.data.WeaponSet;
import data.scripts.combatanalytics.function.AggregateDamage;
import data.scripts.combatanalytics.util.Localization;
import java.awt.Color;

public class WeaponTooltipCreator
implements TooltipMakerAPI.TooltipCreator {
    private final Ship ship;
    private final AggregateDamage _aggregateDamage;

    public WeaponTooltipCreator(Ship ship, AggregateDamage ad) {
        this.ship = ship;
        this._aggregateDamage = ad;
    }

    public boolean isTooltipExpandable(Object tooltipParam) {
        return false;
    }

    public float getTooltipWidth(Object tooltipParam) {
        return 450.0f;
    }

    public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
        Color valueColor = Color.WHITE;
        WeaponSet ws = this.getWeaponSet(this._aggregateDamage.groupName);
        if (ws != null) {
            tooltip.addPara(Localization.WeaponCount, 0.0f, valueColor, new String[]{"" + ws.count});
            int totalOpForWeapon = ws.count * ws.ordnancePointsPer;
            tooltip.addPara(Localization.WeaponOpTotal, 0.0f, valueColor, new String[]{"" + totalOpForWeapon});
            int totalWeaponOpForShip = this.getTotalWeaponOpForShip();
            if (totalOpForWeapon > 0 && totalWeaponOpForShip > 0) {
                int pctOfOp = (int)((double)(totalOpForWeapon * 100) / (double)totalWeaponOpForShip);
                tooltip.addPara(Localization.WeaponOpAsPct, 0.0f, valueColor, new String[]{"" + pctOfOp});
            }
        }
        tooltip.addPara(Localization.KillingBlows, 0.0f, valueColor, new String[]{"" + this._aggregateDamage.getKillingBlows()});
    }

    public int getTotalWeaponOpForShip() {
        int totalWeaponOpForShip = 0;
        for (WeaponSet w : this.ship.weaponSets) {
            totalWeaponOpForShip += w.count * w.ordnancePointsPer;
        }
        return totalWeaponOpForShip;
    }

    public float getWeaponGroupOpAsPct() {
        WeaponSet ws = this.getWeaponSet(this._aggregateDamage.groupName);
        if (ws == null) {
            return 0.0f;
        }
        int totalOpForWeapon = ws.count * ws.ordnancePointsPer;
        int totalOpForShip = this.getTotalWeaponOpForShip();
        if (totalOpForWeapon < 1 || totalOpForShip < 1) {
            return 0.0f;
        }
        return (float)((double)(totalOpForWeapon * 100) / (double)totalOpForShip);
    }

    private WeaponSet getWeaponSet(String weaponName) {
        for (WeaponSet ws : this.ship.weaponSets) {
            if (!ws.weapon.equals(weaponName)) continue;
            return ws;
        }
        return null;
    }
}

