/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.combatanalytics.damagedetection;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.listeners.ApplyDamageResultAPI;
import com.fs.starfarer.api.combat.listeners.DamageListener;
import data.scripts.combatanalytics.damagedetection.DamageDetectorUtil;
import data.scripts.combatanalytics.damagedetection.FrameDamageProjectile;
import data.scripts.combatanalytics.damagedetection.ListenerDamage;
import data.scripts.combatanalytics.damagedetection.ReportableDamage;
import data.scripts.combatanalytics.damagedetection.SourceTargetDamageType;
import data.scripts.combatanalytics.util.Helpers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

class DamageDetectorListener
implements DamageListener {
    private static final Logger log = Global.getLogger(DamageDetectorListener.class);
    public ShipAPI ship;
    private final HashMap<String, DamagesByType> _sourceShipIdToProjectileDamages = new HashMap();
    private final HashMap<String, DamagesByType> _sourceShipIdToDpsDamages = new HashMap();
    private final List<ReportableDamage> _ballisticDamages = new ArrayList<ReportableDamage>();

    public DamageDetectorListener(ShipAPI ship) {
        this.ship = ship;
    }

    public void reportDamageApplied(Object source, CombatEntityAPI target, ApplyDamageResultAPI result) {
        block12: {
            if (source == null || result == null || result.getType() == DamageType.OTHER) {
                return;
            }
            if (!(target instanceof ShipAPI)) {
                return;
            }
            ShipAPI targetShip = (ShipAPI)target;
            try {
                if (source instanceof ShipAPI) {
                    ShipAPI sourceShip = (ShipAPI)source;
                    if ((sourceShip = DamageDetectorUtil.getResponsibleShip(sourceShip)) != targetShip) {
                        this.addDamage(sourceShip, targetShip, result);
                    }
                    break block12;
                }
                if (source instanceof DamagingProjectileAPI) {
                    DamagingProjectileAPI projectile = (DamagingProjectileAPI)source;
                    ShipAPI sourceShip = projectile.getSource();
                    if (sourceShip != targetShip) {
                        ListenerDamage ld = new ListenerDamage(sourceShip, targetShip, result);
                        if (projectile.getWeapon() != null && projectile.getWeapon().getDisplayName() != null) {
                            this._ballisticDamages.add(new ReportableDamage(new FrameDamageProjectile(projectile), ld, false));
                        } else if (projectile instanceof MissileAPI) {
                            MissileAPI m = (MissileAPI)projectile;
                            String name = m.isMine() ? "Mine" : Helpers.getUnknownWeaponName(projectile.getDamageType(), "Projectile");
                            this._ballisticDamages.add(new ReportableDamage(name, ld, false));
                        } else {
                            String name = Helpers.getUnknownWeaponName(projectile.getDamageType(), "Projectile");
                            this._ballisticDamages.add(new ReportableDamage(name, ld, false));
                        }
                    }
                    break block12;
                }
                return;
            }
            catch (Throwable t) {
                log.error((Object)"Error listening for damages", t);
            }
        }
    }

    private void addDamage(ShipAPI sourceShip, ShipAPI targetShip, ApplyDamageResultAPI result) {
        ListenerDamage damage = new ListenerDamage(sourceShip, targetShip, result);
        HashMap<String, DamagesByType> map = result.isDps() ? this._sourceShipIdToDpsDamages : this._sourceShipIdToProjectileDamages;
        DamagesByType damages = map.get(sourceShip.getId());
        if (damages == null) {
            damages = new DamagesByType(sourceShip, targetShip);
            map.put(sourceShip.getId(), damages);
        }
        damages.add(damage);
    }

    public void dispose() {
        if (this.ship != null) {
            this.ship.removeListenerOfClass(DamageDetectorListener.class);
            this.ship = null;
        }
    }

    public DamagesByType getDamageResultsBySource(ShipAPI sourceShip, boolean isBeam) {
        if (isBeam) {
            return this._sourceShipIdToDpsDamages.get(sourceShip.getId());
        }
        return this._sourceShipIdToProjectileDamages.get(sourceShip.getId());
    }

    public Map<SourceTargetDamageType, List<ListenerDamage>> getAllDamages(boolean isBeam) {
        HashMap<SourceTargetDamageType, List<ListenerDamage>> ret = new HashMap<SourceTargetDamageType, List<ListenerDamage>>();
        HashMap<String, DamagesByType> map = isBeam ? this._sourceShipIdToDpsDamages : this._sourceShipIdToProjectileDamages;
        for (DamagesByType damagesByType : map.values()) {
            SourceTargetDamageType stdt;
            if (damagesByType.kinetic.size() > 0) {
                stdt = new SourceTargetDamageType(damagesByType.source, damagesByType.target, DamageType.KINETIC);
                ret.put(stdt, damagesByType.kinetic);
            }
            if (damagesByType.energy.size() > 0) {
                stdt = new SourceTargetDamageType(damagesByType.source, damagesByType.target, DamageType.ENERGY);
                ret.put(stdt, damagesByType.energy);
            }
            if (damagesByType.fragmentation.size() > 0) {
                stdt = new SourceTargetDamageType(damagesByType.source, damagesByType.target, DamageType.FRAGMENTATION);
                ret.put(stdt, damagesByType.fragmentation);
            }
            if (damagesByType.highExplosive.size() <= 0) continue;
            stdt = new SourceTargetDamageType(damagesByType.source, damagesByType.target, DamageType.HIGH_EXPLOSIVE);
            ret.put(stdt, damagesByType.highExplosive);
        }
        return ret;
    }

    public List<ReportableDamage> getBallisticDamages() {
        return this._ballisticDamages;
    }

    public void clearDamageResults() {
        this._sourceShipIdToDpsDamages.clear();
        this._sourceShipIdToProjectileDamages.clear();
        this._ballisticDamages.clear();
    }

    public String toString() {
        return this.ship.toString() + " Projectile Damage Count: " + this._sourceShipIdToProjectileDamages.size() + "  Beam Damage Count: " + this._sourceShipIdToDpsDamages.size();
    }

    public static class DamagesByType {
        public final ShipAPI source;
        public final ShipAPI target;
        public List<ListenerDamage> highExplosive = new ArrayList<ListenerDamage>();
        public List<ListenerDamage> kinetic = new ArrayList<ListenerDamage>();
        public List<ListenerDamage> energy = new ArrayList<ListenerDamage>();
        public List<ListenerDamage> fragmentation = new ArrayList<ListenerDamage>();

        public DamagesByType(ShipAPI source, ShipAPI target) {
            this.source = source;
            this.target = target;
        }

        public void add(ListenerDamage ld) {
            switch (ld.damageType) {
                case KINETIC: {
                    this.kinetic.add(ld);
                    break;
                }
                case HIGH_EXPLOSIVE: {
                    this.highExplosive.add(ld);
                    break;
                }
                case FRAGMENTATION: {
                    this.fragmentation.add(ld);
                    break;
                }
                case ENERGY: {
                    this.energy.add(ld);
                    break;
                }
            }
        }
    }
}

