/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.combatanalytics.damagedetection;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import data.scripts.combatanalytics.damagedetection.DamageDetectorResult;
import data.scripts.combatanalytics.damagedetection.FrameProcessorBeam;
import data.scripts.combatanalytics.damagedetection.FrameProcessorDestroyedMissiles;
import data.scripts.combatanalytics.damagedetection.FrameProcessorProjectile;
import data.scripts.combatanalytics.damagedetection.FrameProcessorReportedDamage;
import data.scripts.combatanalytics.damagedetection.FrameProcessorState;
import data.scripts.combatanalytics.damagedetection.FrameProcessorUnclaimed;
import data.scripts.combatanalytics.damagedetection.ListenerManager;
import data.scripts.combatanalytics.damagedetection.ReportableDamage;
import data.scripts.combatanalytics.data.Damage;
import data.scripts.combatanalytics.util.Helpers;
import data.scripts.combatanalytics.util.Settings;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class EveryFrameDamageDetector {
    private static final Logger log = Global.getLogger(EveryFrameDamageDetector.class);
    private static final boolean DebugEnabled = log.isDebugEnabled();
    private static EveryFrameDamageDetector DamageDetector = null;
    private CombatEngineAPI _engine;
    private final boolean _isSimulation;
    public final String _combatId = Helpers.getSmallUuid();
    private FrameProcessorState _state;
    private FrameProcessorBeam _beamProcessor;
    private FrameProcessorProjectile _projectileProcessor;
    private FrameProcessorUnclaimed _unclaimedProcessor;
    private FrameProcessorReportedDamage _reportedDamageProcessor;
    private FrameProcessorDestroyedMissiles _destroyedMissilesProcessor;
    private ListenerManager _listenerManager;
    private long _elapsedSystemTime = 0L;
    private long _longFrameCount = 0L;
    private long _frameCount = 0L;

    public static void init(CombatEngineAPI engine) {
        DamageDetector = new EveryFrameDamageDetector(engine);
        log.debug((Object)"Initializing EveryFrameDamageDetector");
    }

    public static void detectDamage(float amount) {
        if (DamageDetector == null) {
            return;
        }
        DamageDetector.handleFrame(amount);
    }

    public static boolean isSimulationComplete() {
        return DamageDetector != null && EveryFrameDamageDetector.DamageDetector._engine != null && EveryFrameDamageDetector.DamageDetector._isSimulation && EveryFrameDamageDetector.DamageDetector._frameCount > 0L;
    }

    public static DamageDetectorResult completeCombatAndReset(boolean logDamages) {
        DamageDetectorResult ret = new DamageDetectorResult();
        if (DamageDetector == null || EveryFrameDamageDetector.DamageDetector._engine == null) {
            return ret;
        }
        ret.damages = DamageDetector.getCombatDamages();
        ret.combatDurationSeconds = DamageDetector.getCombatDurationInSeconds();
        ret.combatId = EveryFrameDamageDetector.DamageDetector._combatId;
        log.info((Object)DamageDetector.getStatsToString());
        log.info((Object)EveryFrameDamageDetector.DamageDetector._projectileProcessor.getStatsToString());
        log.info((Object)EveryFrameDamageDetector.DamageDetector._beamProcessor.getStatsToString());
        log.info((Object)EveryFrameDamageDetector.DamageDetector._unclaimedProcessor.getStatsToString());
        log.info((Object)EveryFrameDamageDetector.DamageDetector._destroyedMissilesProcessor.getStatsToString());
        log.info((Object)EveryFrameDamageDetector.DamageDetector._reportedDamageProcessor.getStatsToString());
        log.info((Object)EveryFrameDamageDetector.DamageDetector._state.getStatsToString());
        DamageDetector.dispose();
        DamageDetector = null;
        log.debug((Object)"Destroying EveryFrameDamageDetector");
        return ret;
    }

    private EveryFrameDamageDetector(CombatEngineAPI engine) {
        boolean bl = this._isSimulation = engine.isSimulation() && !engine.isMission();
        if (engine.isMission()) {
            this._engine = null;
        } else {
            this._engine = engine;
            this._state = new FrameProcessorState(this._combatId);
            this._listenerManager = new ListenerManager();
            this._beamProcessor = new FrameProcessorBeam(engine, this._state, this._listenerManager);
            this._projectileProcessor = new FrameProcessorProjectile(engine, this._state, this._listenerManager);
            this._unclaimedProcessor = new FrameProcessorUnclaimed(engine, this._state, this._listenerManager);
            this._reportedDamageProcessor = new FrameProcessorReportedDamage(engine, this._state, this._listenerManager);
            this._destroyedMissilesProcessor = new FrameProcessorDestroyedMissiles(engine, this._state, this._listenerManager);
        }
    }

    private float getCombatDurationInSeconds() {
        return this._engine == null ? 0.0f : this._engine.getTotalElapsedTime(false);
    }

    public void handleFrame(float amount) {
        if (this._engine == null) {
            return;
        }
        if (this._engine.isPaused()) {
            return;
        }
        long frameTime = System.currentTimeMillis();
        try {
            this._listenerManager.ensureShipsHaveListeners(this._engine.getShips());
            this._state.updateCommonState(amount, this._engine);
            this._projectileProcessor.processFrame(amount);
            this._beamProcessor.processFrame(amount);
            this._destroyedMissilesProcessor.processFrame(amount);
            this._unclaimedProcessor.processFrame(amount);
            this._reportedDamageProcessor.processFrame(amount);
            this._listenerManager.clearState();
            this._listenerManager.handleDestroyedShips(this._state.killedShipsThisFrameById.values());
        }
        catch (Throwable e) {
            log.error((Object)"Error processing damage detection", e);
        }
        frameTime = System.currentTimeMillis() - frameTime;
        if (frameTime > 5L) {
            ++this._longFrameCount;
        }
        this._elapsedSystemTime += frameTime;
        ++this._frameCount;
    }

    Damage[] getCombatDamages() {
        ArrayList<ReportableDamage> reportableDamages = new ArrayList<ReportableDamage>();
        reportableDamages.addAll(this._reportedDamageProcessor.getCombatDamages().getAggregatedCombatDamages());
        if (!Settings.UseReportedDamagesOnly()) {
            reportableDamages.addAll(this._beamProcessor.getCombatDamages().getAggregatedCombatDamages());
            reportableDamages.addAll(this._projectileProcessor.getCombatDamages().getAggregatedCombatDamages());
            reportableDamages.addAll(this._unclaimedProcessor.getCombatDamages().getAggregatedCombatDamages());
        }
        ArrayList<Damage> ret = new ArrayList<Damage>(reportableDamages.size());
        for (ReportableDamage damage : reportableDamages) {
            if (damage.sourceShip.getHullSize() == ShipAPI.HullSize.FIGHTER) continue;
            ret.add(new Damage(this._combatId, damage.weaponName, damage.listenerDamage.shield, damage.listenerDamage.armor, damage.listenerDamage.hull, damage.listenerDamage.emp, damage.wasKillingBlow, this._state.getTrackedShip(damage.sourceShip), this._state.getTrackedShip(damage.targetShip)));
        }
        for (FrameProcessorDestroyedMissiles.InterceptedMissile x : this._destroyedMissilesProcessor.getInterceptedMissiles()) {
            ret.add(new Damage(this._combatId, x.interceptionWeaponName, 0.0f, 0.0f, 1.0f, 0.0f, true, this._state.getTrackedShip(x.interceptionSource), this._state.getFakeShipForMissile(x.missileName, x.missileSource.getOriginalOwner())));
        }
        return ret.toArray(new Damage[0]);
    }

    public String getStatsToString() {
        return "Total time in EveryFrameDamageDetector: " + this._elapsedSystemTime + " ms Long frame count: " + this._longFrameCount + " FrameCount: " + this._frameCount + " Mean Time Per Frame: " + Helpers.TWO_DIGIT_NO_GROUP_FORMAT.format((double)this._elapsedSystemTime / (double)this._frameCount) + "ms";
    }

    public String toString() {
        return this.getStatsToString();
    }

    void dispose() {
        if (this._listenerManager != null) {
            this._listenerManager.dispose();
        }
        this._listenerManager = null;
        this._engine = null;
        this._beamProcessor = null;
        this._projectileProcessor = null;
        this._destroyedMissilesProcessor = null;
        this._unclaimedProcessor = null;
        this._reportedDamageProcessor = null;
        this._state = null;
    }
}

