/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.combatanalytics.damagedetection;

import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import data.scripts.combatanalytics.damagedetection.RawDamage;
import data.scripts.combatanalytics.damagedetection.SourceTargetDamageType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.lwjgl.util.vector.Vector2f;

abstract class FrameDamage
implements Comparable<FrameDamage> {
    FrameDamage() {
    }

    static HashMap<SourceTargetDamageType, List<FrameDamage>> buildTargetSourceDamageTypes(Collection<FrameDamage> frameDamages) {
        HashMap<SourceTargetDamageType, List<FrameDamage>> ret = new HashMap<SourceTargetDamageType, List<FrameDamage>>();
        for (FrameDamage frameDamage : frameDamages) {
            SourceTargetDamageType key = new SourceTargetDamageType(frameDamage.getSource(), frameDamage.getTarget(), frameDamage.getDamageType());
            List<FrameDamage> projectilesForTargetSource = ret.get(key);
            if (projectilesForTargetSource == null) {
                projectilesForTargetSource = new ArrayList<FrameDamage>();
                ret.put(key, projectilesForTargetSource);
            }
            projectilesForTargetSource.add(frameDamage);
        }
        return ret;
    }

    public abstract String getWeaponName();

    public abstract RawDamage getRawDamage();

    public abstract ShipAPI getTarget();

    public abstract ShipAPI getSource();

    public abstract DamageType getDamageType();

    public abstract Vector2f getLocation();

    public abstract DamagingProjectileAPI getProjectile();

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    @Override
    public final int compareTo(FrameDamage o) {
        RawDamage bd = this.getRawDamage();
        return bd.compareTo(o.getRawDamage());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "  " + this.getSource().toString() + " * " + this.getWeaponName() + " => " + this.getTarget().toString() + "  " + this.getRawDamage();
    }

    public final boolean isCloserToLow(FrameDamage low, FrameDamage high) {
        float highDelta;
        float lowDelta = Math.abs(low.getRawDamage().damage - this.getRawDamage().damage);
        return lowDelta < (highDelta = Math.abs(high.getRawDamage().damage - this.getRawDamage().damage));
    }
}

