/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.combatanalytics.damagedetection;

import com.fs.starfarer.api.combat.BeamAPI;
import com.fs.starfarer.api.combat.DamageAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import data.scripts.combatanalytics.damagedetection.DamageDetectorUtil;
import data.scripts.combatanalytics.damagedetection.FrameDamage;
import data.scripts.combatanalytics.damagedetection.RawDamage;
import org.lwjgl.util.vector.Vector2f;

class FrameDamageBeam
extends FrameDamage {
    private final BeamAPI _beam;
    private final float _amount;
    private RawDamage _computed;

    public FrameDamageBeam(BeamAPI beam) {
        this._beam = beam;
        this._amount = 0.1f;
    }

    @Override
    public String getWeaponName() {
        return this._beam.getWeapon().getDisplayName();
    }

    @Override
    public RawDamage getRawDamage() {
        if (this._computed != null) {
            return this._computed;
        }
        DamageAPI dmg = this._beam.getDamage();
        if (dmg == null || dmg.getBaseDamage() == 0.0f && dmg.getFluxComponent() == 0.0f && this._beam.getWeapon().getDamage() != null) {
            dmg = this._beam.getWeapon().getDamage();
        }
        this._computed = new RawDamage(dmg.getBaseDamage() * this._amount, dmg.getFluxComponent() * this._amount, this.getDamageType());
        return this._computed;
    }

    @Override
    public ShipAPI getTarget() {
        return (ShipAPI)this._beam.getDamageTarget();
    }

    @Override
    public ShipAPI getSource() {
        ShipAPI ret = this._beam.getSource();
        ret = DamageDetectorUtil.getResponsibleShip(ret);
        return ret;
    }

    @Override
    public DamageType getDamageType() {
        return this._beam.getWeapon().getDamageType();
    }

    @Override
    public Vector2f getLocation() {
        return this._beam.getTo();
    }

    @Override
    public DamagingProjectileAPI getProjectile() {
        return null;
    }

    @Override
    public int hashCode() {
        return this._beam.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FrameDamageBeam that = (FrameDamageBeam)o;
        return this._beam.equals(that._beam);
    }
}

