/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.combatanalytics.damagedetection;

import com.fs.starfarer.api.combat.DamageAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.combat.entities.DamagingExplosion;
import data.scripts.combatanalytics.damagedetection.FrameDamage;
import data.scripts.combatanalytics.damagedetection.RawDamage;
import org.lwjgl.util.vector.Vector2f;

class FrameDamageExplosion
extends FrameDamage {
    private final DamagingExplosion _explosion;
    private final ShipAPI _target;
    private final String _weaponName;
    private RawDamage _computed;

    public FrameDamageExplosion(DamagingExplosion explosion, ShipAPI target, String weaponName) {
        this._explosion = explosion;
        this._target = target;
        this._weaponName = weaponName;
    }

    @Override
    public String getWeaponName() {
        return this._weaponName;
    }

    @Override
    public RawDamage getRawDamage() {
        if (this._computed != null) {
            return this._computed;
        }
        DamageAPI dmg = this._explosion.getDamage();
        float oldMulti = dmg.getMultiplier();
        dmg.setMultiplier(1.0f);
        this._computed = new RawDamage(dmg.getDamage(), dmg.getFluxComponent(), dmg.getType());
        dmg.setMultiplier(oldMulti);
        return this._computed;
    }

    @Override
    public ShipAPI getTarget() {
        return this._target;
    }

    @Override
    public ShipAPI getSource() {
        return this._explosion.getSource();
    }

    @Override
    public DamageType getDamageType() {
        return this._explosion.getDamage().getType();
    }

    @Override
    public Vector2f getLocation() {
        return this._explosion.getLocation();
    }

    @Override
    public int hashCode() {
        return this._explosion.hashCode() + this._target.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FrameDamageExplosion that = (FrameDamageExplosion)o;
        return this._explosion.equals(that._explosion) && this._target.equals(that._target);
    }

    @Override
    public DamagingProjectileAPI getProjectile() {
        return this._explosion;
    }
}

