/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.combatanalytics.damagedetection;

import com.fs.starfarer.api.combat.DamageAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import data.scripts.combatanalytics.damagedetection.FrameDamage;
import data.scripts.combatanalytics.damagedetection.RawDamage;
import org.lwjgl.util.vector.Vector2f;

class FrameDamageProjectile
extends FrameDamage {
    private final DamagingProjectileAPI _proj;
    private RawDamage _computed;

    public FrameDamageProjectile(DamagingProjectileAPI proj) {
        this._proj = proj;
    }

    @Override
    public String getWeaponName() {
        return this._proj.getWeapon().getDisplayName();
    }

    @Override
    public RawDamage getRawDamage() {
        if (this._computed != null) {
            return this._computed;
        }
        DamageAPI dmg = this._proj.getDamage();
        float oldMulti = dmg.getMultiplier();
        dmg.setMultiplier(1.0f);
        if (dmg.getDamage() == 0.0f && dmg.getFluxComponent() == 0.0f && this._proj.getWeapon().getDamage() != null) {
            dmg = this._proj.getWeapon().getDamage();
        }
        this._computed = new RawDamage(dmg.getDamage(), dmg.getFluxComponent(), dmg.getType());
        this._proj.getDamage().setMultiplier(oldMulti);
        return this._computed;
    }

    @Override
    public ShipAPI getTarget() {
        return (ShipAPI)this._proj.getDamageTarget();
    }

    @Override
    public ShipAPI getSource() {
        return this._proj.getWeapon().getShip();
    }

    @Override
    public DamageType getDamageType() {
        return this._proj.getWeapon().getDamageType();
    }

    @Override
    public Vector2f getLocation() {
        return this._proj.getLocation();
    }

    @Override
    public int hashCode() {
        return this._proj.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FrameDamageProjectile that = (FrameDamageProjectile)o;
        return this._proj.equals(that._proj);
    }

    @Override
    public DamagingProjectileAPI getProjectile() {
        return this._proj;
    }
}

