/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.combatanalytics.damagedetection;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import data.scripts.combatanalytics.damagedetection.FrameProcessorState;
import data.scripts.combatanalytics.damagedetection.ListenerDamage;
import data.scripts.combatanalytics.damagedetection.ListenerManager;
import data.scripts.combatanalytics.data.Ship;
import data.scripts.combatanalytics.data.ShipStatus;
import org.apache.log4j.Logger;

public abstract class FrameProcessor {
    private static final Logger log = Global.getLogger(FrameProcessor.class);
    protected final CombatEngineAPI _engine;
    protected final FrameProcessorState _state;
    protected final ListenerManager _listenerManager;
    private long _processingTime = 0L;

    protected FrameProcessor(CombatEngineAPI engine, FrameProcessorState state, ListenerManager listenerManager) {
        this._engine = engine;
        this._state = state;
        this._listenerManager = listenerManager;
    }

    public final void processFrame(float amount) {
        long start = System.currentTimeMillis();
        this.internalProcessFrame(amount);
        this._processingTime += System.currentTimeMillis() - start;
    }

    public abstract void internalProcessFrame(float var1);

    public final long getProcessingTime() {
        return this._processingTime;
    }

    public boolean wasKillingBlow(ListenerDamage ld, String weaponName) {
        ShipAPI targetShip = ld.target;
        ShipAPI sourceShip = ld.source;
        boolean killingBlow = false;
        if (!targetShip.isAlive() && this._state.aliveShipsLastFrameById.containsKey(targetShip.getId())) {
            if (!targetShip.isStationModule()) {
                killingBlow = true;
                log.debug((Object)(sourceShip.getName() + "->" + weaponName + " KILLS " + targetShip.getName() + "  " + ld.getRealDamage() + "dmg"));
                this.setKilled(targetShip);
            } else if (!targetShip.getParentStation().isAlive() && this._state.aliveShipsLastFrameById.containsKey(targetShip.getParentStation().getId())) {
                killingBlow = true;
                log.debug((Object)(sourceShip.getName() + "->" + weaponName + " KILLS " + targetShip.getParentStation().getName() + "  " + ld.getRealDamage() + "dmg"));
                this.setKilled(targetShip);
            }
        }
        return killingBlow;
    }

    private void setKilled(ShipAPI ship) {
        Ship s = this._state.getTrackedShip(ship);
        s.status = ShipStatus.DESTROYED;
    }

    public abstract String getStatsToString();
}

