/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.combatanalytics.damagedetection;

import com.fs.starfarer.api.combat.BeamAPI;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import data.scripts.combatanalytics.damagedetection.FrameDamage;
import data.scripts.combatanalytics.damagedetection.FrameDamageBeam;
import data.scripts.combatanalytics.damagedetection.FrameProcessor;
import data.scripts.combatanalytics.damagedetection.FrameProcessorState;
import data.scripts.combatanalytics.damagedetection.ListenerDamage;
import data.scripts.combatanalytics.damagedetection.ListenerDamageInference;
import data.scripts.combatanalytics.damagedetection.ListenerManager;
import data.scripts.combatanalytics.damagedetection.ReportableDamage;
import data.scripts.combatanalytics.damagedetection.ReportableDamageSet;
import data.scripts.combatanalytics.damagedetection.ResolvedDamage;
import data.scripts.combatanalytics.damagedetection.SourceTargetDamageType;
import data.scripts.combatanalytics.util.Helpers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class FrameProcessorBeam
extends FrameProcessor {
    private final ReportableDamageSet _beamDamages = new ReportableDamageSet(false);
    private final ListenerDamageInference _listenerDamageInference = new ListenerDamageInference();
    private final HashMap<String, Integer> _shipIdDamageTypeToBeamCount = new HashMap();
    private long _resolvedCount = 0L;
    private long _inferredCount = 0L;
    private long _priorLookupCount = 0L;

    protected FrameProcessorBeam(CombatEngineAPI engine, FrameProcessorState state, ListenerManager listenerManager) {
        super(engine, state, listenerManager);
    }

    @Override
    public void internalProcessFrame(float amount) {
        ArrayList<FrameDamage> beamsToProcess = new ArrayList<FrameDamage>(20);
        for (BeamAPI beam : this._engine.getBeams()) {
            if (!this.didDamageToShip(this._engine, beam)) continue;
            beamsToProcess.add(new FrameDamageBeam(beam));
        }
        if (beamsToProcess.size() == 0) {
            return;
        }
        List<ReportableDamage> damages = this.processBeamDamages(beamsToProcess, amount);
        for (ReportableDamage thisFrameDamage : damages) {
            this._beamDamages.addReportableDamage(thisFrameDamage);
        }
    }

    private boolean didDamageToShip(CombatEngineAPI engine, BeamAPI dp) {
        if (dp.getWeapon() == null || dp.getWeapon().getShip() == null || dp.getDamage() == null || dp.getWeapon().getDisplayName() == null) {
            return false;
        }
        CombatEntityAPI target = dp.getDamageTarget();
        if (target == null) {
            return false;
        }
        if (!(target instanceof ShipAPI)) {
            return false;
        }
        ShipAPI targetShip = (ShipAPI)target;
        return targetShip.isAlive() || this._state.aliveShipsLastFrameById.containsKey(targetShip.getId());
    }

    private List<ReportableDamage> processBeamDamages(List<FrameDamage> frameDamagesToProcess, float amount) {
        ArrayList<ReportableDamage> ret = new ArrayList<ReportableDamage>(frameDamagesToProcess.size());
        HashMap<SourceTargetDamageType, List<FrameDamage>> frameDamagesBySourceTargetDamageType = FrameDamage.buildTargetSourceDamageTypes(frameDamagesToProcess);
        Map<SourceTargetDamageType, List<ListenerDamage>> listenerDamagesBySourceTargetDamageType = this._listenerManager.getListenerDamages(true);
        for (Map.Entry<SourceTargetDamageType, List<FrameDamage>> sourceTargetDamageTypeAndDamages : frameDamagesBySourceTargetDamageType.entrySet()) {
            SourceTargetDamageType std = sourceTargetDamageTypeAndDamages.getKey();
            List<FrameDamage> frameDamages = sourceTargetDamageTypeAndDamages.getValue();
            List<ListenerDamage> listenerDamages = listenerDamagesBySourceTargetDamageType.get(std);
            if (listenerDamages == null) {
                listenerDamages = Collections.emptyList();
            }
            ListenerDamageInference.InferredDamageRatio idr = this._listenerDamageInference.getInferredRatio(std, listenerDamages);
            if (this.getDistinctBeamWeaponTypeCount(std.sourceShip, std.damageType) == 1 && listenerDamages.size() > 0) {
                List<ResolvedDamage> resolvedDamages = this.resolveDamageFromListener(std.sourceShip, std.targetShip, listenerDamages, frameDamages);
                this._listenerDamageInference.updateLastResolvedDamages(resolvedDamages);
                for (ResolvedDamage rd : resolvedDamages) {
                    ListenerDamage rescaled = rd.listenerDamage.rescaleBeamDamage(amount);
                    ret.add(new ReportableDamage(rd.frameDamage, rescaled, this.wasKillingBlow(rescaled, rd.frameDamage.getWeaponName())));
                    ++this._resolvedCount;
                }
            }
            for (FrameDamage fd : frameDamages) {
                ListenerDamage ld = this._listenerDamageInference.getPriorFrameListenerDamage(fd.getSource(), fd.getTarget(), fd.getWeaponName());
                if (ld == null) {
                    ld = new ListenerDamage(std.sourceShip, std.targetShip, fd.getRawDamage(), idr, true);
                    ++this._inferredCount;
                } else {
                    ++this._priorLookupCount;
                }
                ld = ld.rescaleBeamDamage(amount);
                ret.add(new ReportableDamage(fd, ld, this.wasKillingBlow(ld, fd.getWeaponName())));
            }
        }
        return ret;
    }

    public List<ResolvedDamage> resolveDamageFromListener(ShipAPI source, ShipAPI target, List<ListenerDamage> listenerDamages, List<FrameDamage> frameDamages) {
        ArrayList<ResolvedDamage> ret = new ArrayList<ResolvedDamage>();
        if (listenerDamages == null || listenerDamages.size() == 0 || frameDamages == null || frameDamages.size() == 0) {
            return ret;
        }
        ListenerDamage ld = listenerDamages.get(0);
        for (FrameDamage damage : frameDamages) {
            ret.add(new ResolvedDamage(target, source, damage, ld));
        }
        listenerDamages.clear();
        frameDamages.clear();
        return ret;
    }

    private int getDistinctBeamWeaponTypeCount(ShipAPI ship, DamageType damageType) {
        String key = ship.getId() + damageType;
        Integer count = this._shipIdDamageTypeToBeamCount.get(key);
        if (count != null) {
            return count;
        }
        HashSet<Float> uniqueDamages = new HashSet<Float>();
        for (WeaponAPI weapon : ship.getAllWeapons()) {
            if (!weapon.isBeam() || weapon.getDamageType() != damageType) continue;
            uniqueDamages.add(Float.valueOf(weapon.getDamage().getDamage() / 10.0f));
        }
        this._shipIdDamageTypeToBeamCount.put(key, uniqueDamages.size());
        return uniqueDamages.size();
    }

    @Override
    public String getStatsToString() {
        double total = this._resolvedCount + this._inferredCount + this._priorLookupCount;
        if (total == 0.0) {
            return "";
        }
        return "Beam Processor (" + this.getProcessingTime() + "ms): Assigned Damages: " + this._resolvedCount + " (" + Helpers.formatAsPercent((double)this._resolvedCount / total) + ")  Inferred Damages: " + this._inferredCount + " (" + Helpers.formatAsPercent((double)this._inferredCount / total) + ")  Prior Damages " + this._priorLookupCount + " (" + Helpers.formatAsPercent((double)this._priorLookupCount / total) + ")";
    }

    public String toString() {
        return this.getStatsToString();
    }

    public ReportableDamageSet getCombatDamages() {
        return this._beamDamages;
    }

    private static class SourceTargetWeapon {
        private final String sourceShipApiId;
        private final String targetShipApiId;
        private final String weaponName;

        public SourceTargetWeapon(String sourceShipApiId, String targetShipApiId, String weaponName) {
            this.sourceShipApiId = sourceShipApiId;
            this.targetShipApiId = targetShipApiId;
            this.weaponName = weaponName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SourceTargetWeapon that = (SourceTargetWeapon)o;
            return this.sourceShipApiId.equals(that.sourceShipApiId) && this.targetShipApiId.equals(that.targetShipApiId) && this.weaponName.equals(that.weaponName);
        }

        public int hashCode() {
            return Objects.hash(this.sourceShipApiId, this.targetShipApiId, this.weaponName);
        }
    }
}

