/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.combatanalytics.damagedetection;

import com.fs.starfarer.api.combat.BeamAPI;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageAPI;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.combat.entities.DamagingExplosion;
import data.scripts.combatanalytics.damagedetection.FrameProcessor;
import data.scripts.combatanalytics.damagedetection.FrameProcessorState;
import data.scripts.combatanalytics.damagedetection.ListenerManager;
import data.scripts.combatanalytics.damagedetection.ReportableDamage;
import data.scripts.combatanalytics.util.Helpers;
import data.scripts.combatanalytics.util.VectorUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class FrameProcessorDestroyedMissiles
extends FrameProcessor {
    private HashSet<DamagingProjectileAPI> _missilesActiveLastFrame = new HashSet();
    private HashSet<DamagingProjectileAPI> _ballisticsActiveLastFrame = new HashSet();
    private final List<InterceptedMissile> _interceptedMissiles = new ArrayList<InterceptedMissile>();
    private int _trackedMissiles = 0;

    protected FrameProcessorDestroyedMissiles(CombatEngineAPI engine, FrameProcessorState state, ListenerManager listenerManager) {
        super(engine, state, listenerManager);
    }

    @Override
    public void internalProcessFrame(float amount) {
        HashSet<DamagingProjectileAPI> missilesActiveThisFrame = this.getActiveMissiles();
        this._missilesActiveLastFrame.removeAll(missilesActiveThisFrame);
        this._trackedMissiles += this._missilesActiveLastFrame.size();
        for (DamagingProjectileAPI deadMissile : this._missilesActiveLastFrame) {
            MissileKiller interceptor;
            if (deadMissile.didDamage() || (interceptor = this.determineInterceptor((MissileAPI)deadMissile)) == null) continue;
            String deadMissileName = deadMissile.getWeapon() == null ? "Missile" : deadMissile.getWeapon().getDisplayName();
            String weaponName = interceptor.isExplosion() ? this._state.getExplosionCause(interceptor.getExplosion()) : interceptor.getWeaponName();
            InterceptedMissile im = new InterceptedMissile(deadMissile.getSource(), deadMissileName, interceptor.getSource(), weaponName);
            this._interceptedMissiles.add(im);
        }
        this._ballisticsActiveLastFrame = this.getActiveBallistics();
        this._missilesActiveLastFrame = missilesActiveThisFrame;
    }

    private HashSet<DamagingProjectileAPI> getActiveMissiles() {
        HashSet<DamagingProjectileAPI> ret = new HashSet<DamagingProjectileAPI>(100);
        for (DamagingProjectileAPI proj : this._engine.getProjectiles()) {
            if (!(proj instanceof MissileAPI)) continue;
            ret.add(proj);
        }
        return ret;
    }

    private HashSet<DamagingProjectileAPI> getActiveBallistics() {
        HashSet<DamagingProjectileAPI> ret = new HashSet<DamagingProjectileAPI>(100);
        for (DamagingProjectileAPI proj : this._engine.getProjectiles()) {
            if (proj instanceof MissileAPI || proj instanceof DamagingExplosion) continue;
            ret.add(proj);
        }
        return ret;
    }

    private MissileKiller determineInterceptor(MissileAPI deadMissile) {
        DamagingProjectileAPI winner = null;
        double winnerDistance = 9.99999999999999E14;
        for (DamagingProjectileAPI interceptor : Helpers.concat(this._missilesActiveLastFrame, this._ballisticsActiveLastFrame, this._engine.getProjectiles())) {
            double thisDistance;
            if (interceptor == deadMissile || interceptor.getSource() == deadMissile.getSource() || interceptor.getOwner() == deadMissile.getOwner()) continue;
            if (interceptor instanceof DamagingExplosion) {
                DamagingExplosion explosion = (DamagingExplosion)interceptor;
                for (CombatEntityAPI da : explosion.getDamagedAlready()) {
                    if (!da.equals(deadMissile)) continue;
                    return new MissileKiller(explosion, null, interceptor.getDamage(), interceptor.getSource());
                }
            }
            if (!((thisDistance = VectorUtil.distance(deadMissile.getLocation(), interceptor.getLocation())) < winnerDistance)) continue;
            winnerDistance = thisDistance;
            winner = interceptor;
        }
        for (BeamAPI beam : this._engine.getBeams()) {
            if (beam.getDamageTarget() != deadMissile) continue;
            return new MissileKiller(beam, beam.getWeapon(), beam.getDamage(), beam.getSource());
        }
        if (winner == null || winnerDistance > 20.0) {
            return null;
        }
        return new MissileKiller(winner, winner.getWeapon(), winner.getDamage(), winner.getSource());
    }

    public List<InterceptedMissile> getInterceptedMissiles() {
        return this._interceptedMissiles;
    }

    @Override
    public String getStatsToString() {
        return "Destroyed Missiles Processor: (" + this.getProcessingTime() + "ms)  Intercepted Missiles: " + this._interceptedMissiles.size() + "  Tracked Missiles: " + this._trackedMissiles;
    }

    private static class MissileKiller {
        final Object api;
        String weaponName;
        final DamageAPI damage;
        final ShipAPI source;

        public MissileKiller(Object api, WeaponAPI weapon, DamageAPI damage, ShipAPI source) {
            this.api = api;
            this.damage = damage;
            if (weapon == null) {
                this.weaponName = Helpers.getUnknownWeaponName(damage.getType());
            } else {
                this.weaponName = weapon.getDisplayName();
                if (source.isFighter() && !source.isDrone()) {
                    this.weaponName = ReportableDamage.GetFighterWeaponName(source, this.weaponName);
                    if (source.getWing() != null && source.getWing().getSourceShip() != null) {
                        source = source.getWing().getSourceShip();
                    }
                } else if (source.isDrone() && source.getDroneSource() != null) {
                    this.weaponName = ReportableDamage.GetDroneWeaponName(source, this.weaponName);
                    source = source.getDroneSource();
                }
            }
            this.source = source;
        }

        boolean isExplosion() {
            return this.api instanceof DamagingExplosion;
        }

        DamagingExplosion getExplosion() {
            return (DamagingExplosion)this.api;
        }

        DamageAPI getDamage() {
            return this.damage;
        }

        public String getWeaponName() {
            return this.weaponName;
        }

        ShipAPI getSource() {
            return this.source;
        }
    }

    public static class InterceptedMissile {
        public final ShipAPI missileSource;
        public final String missileName;
        public final ShipAPI interceptionSource;
        public final String interceptionWeaponName;

        public InterceptedMissile(ShipAPI missileSource, String missileName, ShipAPI interceptionSource, String interceptionWeaponName) {
            this.missileSource = missileSource;
            this.missileName = missileName;
            this.interceptionSource = interceptionSource;
            this.interceptionWeaponName = interceptionWeaponName;
        }
    }
}

