/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.combatanalytics.damagedetection;

import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.loading.ProjectileSpawnType;
import com.fs.starfarer.combat.entities.DamagingExplosion;
import data.scripts.combatanalytics.damagedetection.FrameDamage;
import data.scripts.combatanalytics.damagedetection.FrameDamageExplosion;
import data.scripts.combatanalytics.damagedetection.FrameDamageProjectile;
import data.scripts.combatanalytics.damagedetection.FrameProcessor;
import data.scripts.combatanalytics.damagedetection.FrameProcessorState;
import data.scripts.combatanalytics.damagedetection.ListenerDamage;
import data.scripts.combatanalytics.damagedetection.ListenerDamageInference;
import data.scripts.combatanalytics.damagedetection.ListenerManager;
import data.scripts.combatanalytics.damagedetection.ReportableDamage;
import data.scripts.combatanalytics.damagedetection.ReportableDamageSet;
import data.scripts.combatanalytics.damagedetection.ResolvedDamage;
import data.scripts.combatanalytics.damagedetection.SourceTargetDamageType;
import data.scripts.combatanalytics.util.Helpers;
import data.scripts.combatanalytics.util.LRUMap;
import data.scripts.combatanalytics.util.VectorUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class FrameProcessorProjectile
extends FrameProcessor {
    private final LRUMap<ProjectileTargetPair, ProjectileTargetPair> _loggedProjectiles = new LRUMap(1000, 10000);
    private HashSet<DamagingProjectileAPI> _lastFrameProjectiles = new HashSet(100);
    private final ReportableDamageSet _pointInTimeDamages = new ReportableDamageSet(true);
    private HashSet<MissileAPI> _seenMissiles = new HashSet(100);
    private final ListenerDamageInference _listenerDamageInference = new ListenerDamageInference();
    private long _assignedProjectileDamages = 0L;
    private long _unassignedProjectileDamages = 0L;
    private long _unassignedProjectiles = 0L;
    private double _totalAssignedDamage = 0.0;
    private double _totalUnassignedFrameDamage = 0.0;
    private double _totalUnassignedListenerDamage = 0.0;

    protected FrameProcessorProjectile(CombatEngineAPI engine, FrameProcessorState state, ListenerManager listenerManager) {
        super(engine, state, listenerManager);
    }

    @Override
    public void internalProcessFrame(float amount) {
        List<ReportableDamage> fullDamages = this._listenerManager.getBallisticDamages();
        for (ReportableDamage fd : fullDamages) {
            ProjectileTargetPair ptp = new ProjectileTargetPair(fd.damagingEntityId, (CombatEntityAPI)fd.sourceShip, (CombatEntityAPI)fd.targetShip);
            fd.wasKillingBlow = this.wasKillingBlow(fd.listenerDamage, fd.weaponName);
            this._loggedProjectiles.put(ptp, ptp);
        }
        this._pointInTimeDamages.addAllReportableDamages(fullDamages);
        List<FrameDamage> projectilesToProcess = this.getProjectilesToProcess();
        if (projectilesToProcess.size() == 0) {
            return;
        }
        projectilesToProcess = this.removeUnnecessaryProjectiles(projectilesToProcess);
        List<ReportableDamage> damages = this.processProjectileDamages(projectilesToProcess);
        this._pointInTimeDamages.addAllReportableDamages(damages);
        for (FrameDamage fd : projectilesToProcess) {
            ProjectileTargetPair ptp = new ProjectileTargetPair(fd.getProjectile(), (CombatEntityAPI)fd.getSource(), (CombatEntityAPI)fd.getTarget());
            this._loggedProjectiles.put(ptp, ptp);
        }
    }

    private boolean didDamageToShip(CombatEngineAPI engine, DamagingExplosion dp, CombatEntityAPI target) {
        if (target == null) {
            return false;
        }
        if (!(target instanceof ShipAPI)) {
            return false;
        }
        ProjectileTargetPair key = new ProjectileTargetPair((DamagingProjectileAPI)dp, (CombatEntityAPI)dp.getSource(), target);
        if (this._loggedProjectiles.containsKey(key)) {
            return false;
        }
        ShipAPI targetShip = (ShipAPI)target;
        return targetShip.isAlive() || this._state.aliveShipsLastFrameById.containsKey(targetShip.getId());
    }

    private boolean didDamageToShip(CombatEngineAPI engine, DamagingProjectileAPI dp) {
        if (dp.getWeapon() == null || dp.getWeapon().getShip() == null || dp.getDamage() == null || dp.getWeapon().getDisplayName() == null) {
            return false;
        }
        CombatEntityAPI target = dp.getDamageTarget();
        if (target == null) {
            return false;
        }
        if (!(target instanceof ShipAPI)) {
            return false;
        }
        ProjectileTargetPair key = new ProjectileTargetPair(dp, (CombatEntityAPI)dp.getSource(), target);
        if (this._loggedProjectiles.containsKey(key)) {
            return false;
        }
        ShipAPI targetShip = (ShipAPI)target;
        return targetShip.isAlive() || this._state.aliveShipsLastFrameById.containsKey(targetShip.getId());
    }

    private List<FrameDamage> getProjectilesToProcess() {
        HashSet<MissileAPI> activeMissiles = new HashSet<MissileAPI>(100);
        ArrayList<FrameDamage> projectilesToProcess = new ArrayList<FrameDamage>();
        HashSet<DamagingProjectileAPI> thisFrameProjectiles = new HashSet<DamagingProjectileAPI>(100);
        for (DamagingProjectileAPI proj : this._engine.getProjectiles()) {
            if (proj instanceof MissileAPI) {
                activeMissiles.add((MissileAPI)proj);
                continue;
            }
            if (proj instanceof DamagingExplosion) {
                DamagingExplosion explosion = (DamagingExplosion)proj;
                if (this.isShipExplosion(explosion)) continue;
                for (CombatEntityAPI damagedByExplosion : explosion.getDamagedAlready()) {
                    if (damagedByExplosion == explosion.getSource() || !this.didDamageToShip(this._engine, explosion, damagedByExplosion)) continue;
                    projectilesToProcess.add(new FrameDamageExplosion(explosion, (ShipAPI)damagedByExplosion, this._state.getExplosionCause(explosion)));
                }
                continue;
            }
            if (this.didDamageToShip(this._engine, proj) && proj.didDamage()) {
                projectilesToProcess.add(new FrameDamageProjectile(proj));
                this._lastFrameProjectiles.remove(proj);
                continue;
            }
            thisFrameProjectiles.add(proj);
        }
        this._lastFrameProjectiles.removeAll(thisFrameProjectiles);
        for (DamagingProjectileAPI proj : this._lastFrameProjectiles) {
            if (!this.didDamageToShip(this._engine, proj)) continue;
            projectilesToProcess.add(new FrameDamageProjectile(proj));
        }
        this._lastFrameProjectiles = thisFrameProjectiles;
        this._seenMissiles.removeAll(activeMissiles);
        for (MissileAPI missile : this._seenMissiles) {
            if (!this.didDamageToShip(this._engine, (DamagingProjectileAPI)missile) || !missile.didDamage()) continue;
            projectilesToProcess.add(new FrameDamageProjectile((DamagingProjectileAPI)missile));
        }
        this._seenMissiles = activeMissiles;
        return projectilesToProcess;
    }

    boolean isShipExplosion(DamagingExplosion proj) {
        return proj.getDamageType().equals((Object)DamageType.HIGH_EXPLOSIVE) && proj.getProjectileSpecId() == null && !proj.getSource().isAlive() && proj.getSpawnType().equals((Object)ProjectileSpawnType.OTHER) && VectorUtil.distance(proj.getSpawnLocation(), proj.getSource().getLocation()) < 8.0;
    }

    private List<FrameDamage> removeUnnecessaryProjectiles(List<FrameDamage> projectiles) {
        ArrayList<FrameDamage> ret = new ArrayList<FrameDamage>(projectiles.size());
        ArrayList<FrameDamage> explosiveDamages = new ArrayList<FrameDamage>();
        for (FrameDamage fd : projectiles) {
            if (!(fd instanceof FrameDamageExplosion)) continue;
            explosiveDamages.add(fd);
        }
        for (FrameDamage fd : projectiles) {
            if (fd instanceof FrameDamageExplosion) {
                ret.add(fd);
                continue;
            }
            if (this.sharesSameLocationAndName(fd, explosiveDamages)) continue;
            ret.add(fd);
        }
        return ret;
    }

    private boolean sharesSameLocationAndName(FrameDamage fd, List<FrameDamage> others) {
        for (FrameDamage other : others) {
            double thisDistance = VectorUtil.distance(fd.getLocation(), other.getLocation());
            if (!(thisDistance < 25.0) || !fd.getWeaponName().equals(other.getWeaponName())) continue;
            return true;
        }
        return false;
    }

    private List<ReportableDamage> processProjectileDamages(List<FrameDamage> frameDamagesToProcess) {
        ArrayList<ReportableDamage> ret = new ArrayList<ReportableDamage>(frameDamagesToProcess.size());
        HashMap<SourceTargetDamageType, List<FrameDamage>> frameDamagesBySourceTargetDamageType = FrameDamage.buildTargetSourceDamageTypes(frameDamagesToProcess);
        Map<SourceTargetDamageType, List<ListenerDamage>> listenerDamagesBySourceTargetDamageType = this._listenerManager.getListenerDamages(false);
        for (Map.Entry<SourceTargetDamageType, List<FrameDamage>> sourceTargetDamageTypeAndDamages : frameDamagesBySourceTargetDamageType.entrySet()) {
            SourceTargetDamageType std = sourceTargetDamageTypeAndDamages.getKey();
            List<FrameDamage> frameDamages = sourceTargetDamageTypeAndDamages.getValue();
            List<ListenerDamage> listenerDamages = listenerDamagesBySourceTargetDamageType.get(std);
            if (listenerDamages == null) {
                listenerDamages = Collections.emptyList();
            }
            ListenerDamageInference.InferredDamageRatio idr = this._listenerDamageInference.getInferredRatio(std, listenerDamages);
            List<ResolvedDamage> resolvedDamages = FrameProcessorProjectile.resolveDamageFromListener(std.sourceShip, std.targetShip, listenerDamages, frameDamages);
            if (std.damageType == DamageType.HIGH_EXPLOSIVE && this._state.isShipExploding(std.targetShip)) {
                listenerDamages.clear();
            }
            if (resolvedDamages.size() > 0 && frameDamages.size() > 0 && listenerDamages.size() > 0) {
                resolvedDamages.addAll(FrameProcessorProjectile.resolveDamageFromListener(std.sourceShip, std.targetShip, listenerDamages, frameDamages));
            }
            for (ResolvedDamage rd : resolvedDamages) {
                ret.add(new ReportableDamage(rd.frameDamage, rd.listenerDamage, this.wasKillingBlow(rd.listenerDamage, rd.frameDamage.getWeaponName())));
            }
            for (FrameDamage fd : frameDamages) {
                ListenerDamage ld = new ListenerDamage(std.sourceShip, std.targetShip, fd.getRawDamage(), idr, false);
                ret.add(new ReportableDamage(fd, ld, this.wasKillingBlow(ld, fd.getWeaponName())));
            }
            this._assignedProjectileDamages += (long)resolvedDamages.size();
            for (ResolvedDamage rd : resolvedDamages) {
                this._totalAssignedDamage += (double)rd.listenerDamage.getListedDamage();
            }
            this._unassignedProjectileDamages += (long)listenerDamages.size();
            for (ListenerDamage ld : listenerDamages) {
                this._totalUnassignedListenerDamage += (double)ld.getListedDamage();
            }
            this._unassignedProjectiles += (long)frameDamages.size();
            for (FrameDamage fd : frameDamages) {
                this._totalUnassignedFrameDamage += (double)fd.getRawDamage().damage;
            }
        }
        return ret;
    }

    public static List<ResolvedDamage> resolveDamageFromListener(ShipAPI source, ShipAPI target, List<ListenerDamage> listenerDamages, List<FrameDamage> frameDamages) {
        ArrayList<ResolvedDamage> ret = new ArrayList<ResolvedDamage>();
        if (listenerDamages == null || listenerDamages.size() == 0 || frameDamages == null || frameDamages.size() == 0) {
            return ret;
        }
        if (frameDamages.size() == 1 && listenerDamages.size() == 1) {
            ret.add(new ResolvedDamage(target, source, frameDamages.get(0), listenerDamages.get(0)));
            listenerDamages.clear();
            frameDamages.clear();
            return ret;
        }
        if (frameDamages.size() == listenerDamages.size()) {
            Collections.sort(frameDamages);
            Collections.sort(listenerDamages);
            for (int i = 0; i < frameDamages.size(); ++i) {
                ret.add(new ResolvedDamage(target, source, frameDamages.get(i), listenerDamages.get(i)));
            }
            listenerDamages.clear();
            frameDamages.clear();
            return ret;
        }
        HashSet<String> weapons = new HashSet<String>();
        for (FrameDamage frameDamage : frameDamages) {
            weapons.add(frameDamage.getWeaponName());
        }
        if (weapons.size() == 1 && ListenerDamage.areAllDamagesEqualEnough(listenerDamages) && listenerDamages.size() < 5) {
            int size = Math.max(frameDamages.size(), listenerDamages.size());
            for (int i = 0; i < size; ++i) {
                ret.add(new ResolvedDamage(target, source, frameDamages.get(Math.min(i, frameDamages.size() - 1)), listenerDamages.get(Math.min(i, listenerDamages.size() - 1))));
            }
            listenerDamages.clear();
            frameDamages.clear();
            return ret;
        }
        if (weapons.size() == 2 && frameDamages.size() >= listenerDamages.size()) {
            Collections.sort(frameDamages);
            Collections.sort(listenerDamages);
            ListenerDamage lowLd = listenerDamages.get(0);
            ListenerDamage highLd = listenerDamages.get(listenerDamages.size() - 1);
            FrameDamage lowFd = frameDamages.get(0);
            FrameDamage highFd = frameDamages.get(frameDamages.size() - 1);
            if (listenerDamages.size() > 1 || Helpers.computePctDeltaForDamage(lowFd.getRawDamage().damage, highFd.getRawDamage().damage) < 0.4f) {
                ret.add(new ResolvedDamage(target, source, lowFd, lowLd));
                ret.add(new ResolvedDamage(target, source, highFd, highLd));
                for (int i = 0; i < frameDamages.size() - 1; ++i) {
                    FrameDamage fd;
                    ret.add(new ResolvedDamage(target, source, fd, (fd = frameDamages.get(i)).isCloserToLow(lowFd, highFd) ? lowLd : highLd));
                }
                listenerDamages.clear();
                frameDamages.clear();
                return ret;
            }
        }
        if (frameDamages.size() > 0 && listenerDamages.size() > 0) {
            for (FrameDamage fd : new ArrayList<FrameDamage>(frameDamages)) {
                int matchIndex = ListenerDamage.bestMatchIndex(fd.getRawDamage().damage, fd.getRawDamage().emp, listenerDamages);
                if (matchIndex <= -1) continue;
                ret.add(new ResolvedDamage(target, source, fd, listenerDamages.get(matchIndex)));
                listenerDamages.remove(matchIndex);
                frameDamages.remove(fd);
            }
        }
        return ret;
    }

    @Override
    public String getStatsToString() {
        return "Projectile Processing (" + this.getProcessingTime() + "ms): Accuracy: " + Helpers.formatAsPercent(FrameProcessorProjectile.accuracy(this._assignedProjectileDamages, this._unassignedProjectileDamages, this._unassignedProjectiles)) + "  Resolved Damages: " + this._assignedProjectileDamages + " (" + Helpers.INT_FORMAT_NO_GROUP_FORMAT.format(this._totalAssignedDamage) + ")  Unassigned ListenerDamages: " + this._unassignedProjectileDamages + " (" + Helpers.INT_FORMAT_NO_GROUP_FORMAT.format(this._totalUnassignedListenerDamage) + ")  Unassigned FrameDamages: " + this._unassignedProjectiles + " (" + Helpers.INT_FORMAT_NO_GROUP_FORMAT.format(this._totalUnassignedFrameDamage) + ")";
    }

    private static float accuracy(double assignedDamages, double unassignedDamages, double unassignedFrameDamages) {
        double total = assignedDamages + unassignedDamages + unassignedFrameDamages;
        if (total == 0.0) {
            return 1.0f;
        }
        return (float)(assignedDamages / total);
    }

    public ReportableDamageSet getCombatDamages() {
        return this._pointInTimeDamages;
    }

    public String toString() {
        return this.getStatsToString();
    }

    private static class ProjectileTargetPair {
        final int damagingEntityId;
        final CombatEntityAPI source;
        final CombatEntityAPI target;

        public ProjectileTargetPair(int damagingEntityId, CombatEntityAPI source, CombatEntityAPI target) {
            this.damagingEntityId = damagingEntityId;
            this.source = source;
            this.target = target;
        }

        public ProjectileTargetPair(DamagingProjectileAPI projectileAPI, CombatEntityAPI source, CombatEntityAPI target) {
            this.damagingEntityId = System.identityHashCode(projectileAPI);
            this.source = source;
            this.target = target;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProjectileTargetPair that = (ProjectileTargetPair)o;
            return this.damagingEntityId == that.damagingEntityId && this.source.equals(that.source) && this.target.equals(that.target);
        }

        public int hashCode() {
            return Objects.hash(this.damagingEntityId, this.source, this.target);
        }
    }
}

