/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.combatanalytics.damagedetection;

import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import data.scripts.DamageReportManagerV1;
import data.scripts.DamageReportV1;
import data.scripts.combatanalytics.damagedetection.FrameProcessor;
import data.scripts.combatanalytics.damagedetection.FrameProcessorState;
import data.scripts.combatanalytics.damagedetection.ListenerDamage;
import data.scripts.combatanalytics.damagedetection.ListenerManager;
import data.scripts.combatanalytics.damagedetection.ReportableDamage;
import data.scripts.combatanalytics.damagedetection.ReportableDamageSet;
import data.scripts.combatanalytics.util.Helpers;

public class FrameProcessorReportedDamage
extends FrameProcessor {
    private final ReportableDamageSet _combatDamages = new ReportableDamageSet(false);

    protected FrameProcessorReportedDamage(CombatEngineAPI engine, FrameProcessorState state, ListenerManager listenerManager) {
        super(engine, state, listenerManager);
    }

    @Override
    public void internalProcessFrame(float amount) {
        for (DamageReportV1 damageReport : DamageReportManagerV1.getDamageReports()) {
            if (!(damageReport.getSource() instanceof ShipAPI) || !(damageReport.getTarget() instanceof ShipAPI)) continue;
            ListenerDamage ld = new ListenerDamage(damageReport.getDamageType(), damageReport.getArmorDamage(), damageReport.getHullDamage(), damageReport.getShieldDamage(), damageReport.getEmpDamage(), false, (ShipAPI)damageReport.getSource(), (ShipAPI)damageReport.getTarget());
            this._combatDamages.addReportableDamage(new ReportableDamage(damageReport.getWeaponName(), ld, this.wasKillingBlow(ld, damageReport.getWeaponName())));
        }
        DamageReportManagerV1.clearDamageReports();
    }

    @Override
    public String getStatsToString() {
        float shield = 0.0f;
        float armor = 0.0f;
        float emp = 0.0f;
        float hull = 0.0f;
        for (ReportableDamage rd : this._combatDamages.getAggregatedCombatDamages()) {
            shield += rd.listenerDamage.shield;
            armor += rd.listenerDamage.armor;
            emp += rd.listenerDamage.emp;
            hull += rd.listenerDamage.hull;
        }
        return "Damages Reported: " + Helpers.INT_FORMAT_NO_GROUP_FORMAT.format(this._combatDamages.size()) + "  Total Shield: " + Helpers.INT_FORMAT_NO_GROUP_FORMAT.format(shield) + "  Total Armor: " + Helpers.INT_FORMAT_NO_GROUP_FORMAT.format(armor) + "  Total Hull: " + Helpers.INT_FORMAT_NO_GROUP_FORMAT.format(hull) + "  Total EMP: " + Helpers.INT_FORMAT_NO_GROUP_FORMAT.format(emp);
    }

    public ReportableDamageSet getCombatDamages() {
        return this._combatDamages;
    }
}

