/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.combatanalytics.damagedetection;

import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.FighterWingAPI;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.campaign.CharacterStats;
import com.fs.starfarer.combat.entities.DamagingExplosion;
import data.scripts.combatanalytics.damagedetection.ReportableDamage;
import data.scripts.combatanalytics.data.Ship;
import data.scripts.combatanalytics.data.ShipStatus;
import data.scripts.combatanalytics.data.WeaponSet;
import data.scripts.combatanalytics.util.Helpers;
import data.scripts.combatanalytics.util.VectorUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FrameProcessorState {
    private static final float PROJECTILE_KEEP_ALIVE = 1.0f;
    final HashMap<String, Ship> shipIdToTrackedShip = new HashMap(100);
    HashMap<String, ShipAPI> aliveShipsLastFrameById = new HashMap(100);
    HashMap<String, ShipAPI> aliveShipsThisFrameById = new HashMap(100);
    HashMap<String, ShipAPI> killedShipsThisFrameById = new HashMap(100);
    HashMap<DamagingExplosion, String> explosionToCause = new HashMap(100);
    private HashMap<DamagingProjectileAPI, Double> historicalProjectilesToAge = new HashMap();
    double currentAge = 0.0;
    private long _processingTime = 0L;
    private int _identifiedExplosions = 0;
    private final String _combatId;

    public FrameProcessorState(String combatId) {
        this._combatId = combatId;
    }

    public void updateCommonState(float amount, CombatEngineAPI engine) {
        long start = System.currentTimeMillis();
        this.currentAge += (double)amount;
        for (DamagingProjectileAPI projectile : engine.getProjectiles()) {
            DamagingExplosion de;
            if (!(projectile instanceof DamagingExplosion) || this.explosionToCause.containsKey(de = (DamagingExplosion)projectile)) continue;
            this.explosionToCause.put(de, this.determineExplosionCause(de, engine));
        }
        for (DamagingExplosion de : new ArrayList<DamagingExplosion>(this.explosionToCause.keySet())) {
            if (!de.isExpired()) continue;
            this.explosionToCause.remove(de);
        }
        HashMap<DamagingProjectileAPI, Double> newHistoricalProjectiles = new HashMap<DamagingProjectileAPI, Double>(this.historicalProjectilesToAge.size() * 2);
        for (Map.Entry<DamagingProjectileAPI, Double> projAndFrame : this.historicalProjectilesToAge.entrySet()) {
            if (projAndFrame.getKey().isExpired() || !(projAndFrame.getValue() > this.currentAge)) continue;
            newHistoricalProjectiles.put(projAndFrame.getKey(), projAndFrame.getValue());
        }
        for (DamagingProjectileAPI projectile : engine.getProjectiles()) {
            newHistoricalProjectiles.put(projectile, this.currentAge + 1.0);
        }
        this.historicalProjectilesToAge = newHistoricalProjectiles;
        this.aliveShipsLastFrameById = this.aliveShipsThisFrameById;
        this.killedShipsThisFrameById = new HashMap<String, ShipAPI>(this.aliveShipsLastFrameById);
        this.aliveShipsThisFrameById = new HashMap(this.aliveShipsLastFrameById.size() * 2);
        for (ShipAPI ship : engine.getShips()) {
            if (!ship.isAlive()) continue;
            this.aliveShipsThisFrameById.put(ship.getId(), ship);
            this.killedShipsThisFrameById.remove(ship.getId());
        }
        this._processingTime += System.currentTimeMillis() - start;
    }

    public boolean isShipExploding(ShipAPI ship) {
        return !ship.isAlive() && this.aliveShipsLastFrameById.containsKey(ship.getId());
    }

    Ship getTrackedShip(ShipAPI ship) {
        String id;
        Ship ret;
        if (ship.isStationModule()) {
            ship = ship.getParentStation();
        }
        if ((ret = this.shipIdToTrackedShip.get(id = ship.getId())) == null) {
            ret = new Ship(ship);
            ret.setCaptain(ship.getCaptain());
            this.shipIdToTrackedShip.put(id, ret);
            ret.weaponSets = this.getWeaponsFromShip(ship);
        }
        return ret;
    }

    List<WeaponSet> getWeaponsFromShip(ShipAPI ship) {
        ArrayList<WeaponSet> ret = new ArrayList<WeaponSet>();
        for (ShipAPI module : ship.getChildModulesCopy()) {
            for (WeaponSet ws : this.getWeaponsFromShip(module)) {
                WeaponSet existing = this.findInList(ret, ws.weapon);
                if (existing == null) {
                    ret.add(ws);
                    continue;
                }
                existing.count += ws.count;
            }
        }
        for (WeaponAPI weapon : ship.getAllWeapons()) {
            WeaponSet ws;
            if (weapon.isDecorative()) continue;
            String name = weapon.getDisplayName();
            ws = this.findInList(ret, name);
            if (ws != null) {
                ++ws.count;
                continue;
            }
            boolean isBuiltIn = ship.getHullSpec().isBuiltIn(weapon.getSlot().getId());
            ret.add(new WeaponSet(name, 1, (int)weapon.getOriginalSpec().getOrdnancePointCost((MutableCharacterStatsAPI)new CharacterStats()), isBuiltIn));
        }
        int index = 0;
        for (FighterWingAPI wing : ship.getAllWings()) {
            String name = ReportableDamage.GetFighterWeaponName(wing.getLeader(), "");
            WeaponSet ws = this.findInList(ret, name);
            if (ws != null) {
                ++ws.count;
            } else {
                boolean isBuiltIn = ship.getHullSpec().isBuiltInWing(index);
                ret.add(new WeaponSet(name, 1, (int)((FighterWingAPI)ship.getAllWings().get(0)).getSpec().getOpCost(ship.getMutableStats()), isBuiltIn));
            }
            ++index;
        }
        return ret;
    }

    private WeaponSet findInList(List<WeaponSet> weaponSets, String name) {
        for (WeaponSet ws : weaponSets) {
            if (!ws.weapon.equals(name)) continue;
            return ws;
        }
        return null;
    }

    Ship getFakeShipForMissile(String missileName, int owner) {
        String id = Helpers.getSmallUuid() + "m";
        Ship ret = new Ship(id, missileName, ShipAPI.HullSize.DEFAULT, missileName, 1.0f, 1.0f, owner, 0, "No Captain", "missile", ShipStatus.DESTROYED, "", 0.0f);
        this.shipIdToTrackedShip.put(id, ret);
        return ret;
    }

    public String getExplosionCause(DamagingExplosion de) {
        if (this.explosionToCause.containsKey(de)) {
            return this.explosionToCause.get(de);
        }
        return "Unknown Explosion";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String determineExplosionCause(DamagingExplosion explosion, CombatEngineAPI engine) {
        ++this._identifiedExplosions;
        DamagingProjectileAPI winner = null;
        double winnerDistance = 9.99999999999999E14;
        for (DamagingProjectileAPI potentialCause : Helpers.concat(this.historicalProjectilesToAge.keySet(), engine.getProjectiles())) {
            double thisDistance;
            if (potentialCause instanceof DamagingExplosion || potentialCause.getSource() != explosion.getSource() || !((thisDistance = VectorUtil.distance(explosion.getLocation(), potentialCause.getLocation())) < winnerDistance)) continue;
            winnerDistance = thisDistance;
            winner = potentialCause;
            if (winnerDistance != 0.0) continue;
            break;
        }
        if (winner != null && winnerDistance < 25.0) {
            if (winner.getWeapon() != null) return winner.getWeapon().getDisplayName();
            if (!(winner instanceof MissileAPI) || !((MissileAPI)winner).isMine()) return Helpers.getUnknownWeaponName(explosion.getDamageType());
            return "Mine";
        }
        for (ShipAPI ship : this.aliveShipsLastFrameById.values()) {
            if (!(VectorUtil.distance(explosion.getLocation(), ship.getLocation()) < 25.0)) continue;
            return "Ship Explosion";
        }
        return Helpers.getUnknownWeaponName(explosion.getDamageType());
    }

    public String getStatsToString() {
        return "FrameProcessorState (" + this._processingTime + "ms):   Identified Explosions: " + this._identifiedExplosions;
    }
}

