/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.combatanalytics.damagedetection;

import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipHullSpecAPI;
import data.scripts.DamageClarificationV1;
import data.scripts.DamageReportManagerV1;
import data.scripts.combatanalytics.damagedetection.FrameDamage;
import data.scripts.combatanalytics.damagedetection.FrameDamageClarification;
import data.scripts.combatanalytics.damagedetection.FrameProcessor;
import data.scripts.combatanalytics.damagedetection.FrameProcessorProjectile;
import data.scripts.combatanalytics.damagedetection.FrameProcessorState;
import data.scripts.combatanalytics.damagedetection.ListenerDamage;
import data.scripts.combatanalytics.damagedetection.ListenerManager;
import data.scripts.combatanalytics.damagedetection.ReportableDamage;
import data.scripts.combatanalytics.damagedetection.ReportableDamageSet;
import data.scripts.combatanalytics.damagedetection.ResolvedDamage;
import data.scripts.combatanalytics.damagedetection.SourceTargetDamageType;
import data.scripts.combatanalytics.util.Helpers;
import data.scripts.combatanalytics.util.VectorUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.lwjgl.util.vector.Vector2f;

public class FrameProcessorUnclaimed
extends FrameProcessor {
    private static final float PRIOR_FRAME_LIFETIME_AMOUNT = 0.5f;
    private static final double MAX_EXPLOSION_DISTANCE_FOR_CONSIDERATION = 75.0;
    private final ReportableDamageSet _unclaimedDamages = new ReportableDamageSet(false);
    private double _lifetime = 0.0;
    private int _processedCount = 0;
    private int _wasCustom = 0;
    private int _wasUnknown = 0;
    private int _collisions = 0;
    private double _accurateDamage;
    private double _unknownDamage;

    protected FrameProcessorUnclaimed(CombatEngineAPI engine, FrameProcessorState state, ListenerManager listenerManager) {
        super(engine, state, listenerManager);
    }

    @Override
    public void internalProcessFrame(float amount) {
        this._lifetime += (double)amount;
        ArrayList<ListenerDamage> maybeCollisions = new ArrayList<ListenerDamage>();
        Map<SourceTargetDamageType, List<FrameDamage>> clarifications = this.getClarifications();
        Map<SourceTargetDamageType, List<ListenerDamage>> unclaimedDamages = this._listenerManager.getListenerDamages(false);
        this.clarifyAndRemoveUnclaimedDamages(clarifications, unclaimedDamages);
        for (Map.Entry<SourceTargetDamageType, List<ListenerDamage>> entry : unclaimedDamages.entrySet()) {
            for (ListenerDamage damage : entry.getValue()) {
                String weaponName = this.getWeaponName(damage, maybeCollisions);
                if (weaponName != null) {
                    this._unclaimedDamages.addReportableDamage(new ReportableDamage(weaponName, damage, this.wasKillingBlow(damage, weaponName)));
                    continue;
                }
                if (!this._state.isShipExploding(damage.source)) continue;
            }
        }
        HashSet<ListenerDamage> matched = new HashSet<ListenerDamage>();
        for (ListenerDamage ld1 : maybeCollisions) {
            if (matched.contains(ld1)) continue;
            for (ListenerDamage ld2 : maybeCollisions) {
                if (ld2.target != ld1.source || ld2.source != ld1.target) continue;
                matched.add(ld1);
                matched.add(ld2);
                this._unclaimedDamages.addReportableDamage(new ReportableDamage(Helpers.getCollisionWeaponName(ld1.damageType), ld1, this.wasKillingBlow(ld1, Helpers.getCollisionWeaponName(ld1.damageType))));
                this._unclaimedDamages.addReportableDamage(new ReportableDamage(Helpers.getCollisionWeaponName(ld2.damageType), ld2, this.wasKillingBlow(ld2, Helpers.getCollisionWeaponName(ld2.damageType))));
                this._collisions += 2;
                break;
            }
            if (matched.contains(ld1)) continue;
            ++this._wasUnknown;
            this._unknownDamage += (double)ld1.getListedDamage();
            this._unclaimedDamages.addReportableDamage(new ReportableDamage(Helpers.getUnknownWeaponName(ld1.damageType), ld1, this.wasKillingBlow(ld1, Helpers.getUnknownWeaponName(ld1.damageType))));
        }
    }

    private Map<SourceTargetDamageType, List<FrameDamage>> getClarifications() {
        List<DamageClarificationV1> clarifications = DamageReportManagerV1.getDamageClarifications();
        HashMap<SourceTargetDamageType, List<FrameDamage>> ret = new HashMap<SourceTargetDamageType, List<FrameDamage>>();
        for (DamageClarificationV1 clarification : clarifications) {
            if (!(clarification.getSource() instanceof ShipAPI) || !(clarification.getTarget() instanceof ShipAPI)) continue;
            FrameDamageClarification fdc = new FrameDamageClarification((ShipAPI)clarification.getSource(), (ShipAPI)clarification.getTarget(), clarification.getShipDamage(), clarification.getEmpDamage(), clarification.getDamageType(), clarification.getWeaponName());
            SourceTargetDamageType stdt = new SourceTargetDamageType((ShipAPI)clarification.getSource(), (ShipAPI)clarification.getTarget(), clarification.getDamageType());
            ArrayList<FrameDamageClarification> clarificationsForStdt = (ArrayList<FrameDamageClarification>)ret.get(stdt);
            if (clarificationsForStdt == null) {
                clarificationsForStdt = new ArrayList<FrameDamageClarification>();
                ret.put(stdt, clarificationsForStdt);
            }
            clarificationsForStdt.add(fdc);
        }
        return ret;
    }

    private void clarifyAndRemoveUnclaimedDamages(Map<SourceTargetDamageType, List<FrameDamage>> clarifications, Map<SourceTargetDamageType, List<ListenerDamage>> unclaimedDamages) {
        for (Map.Entry<SourceTargetDamageType, List<FrameDamage>> clarificationsForSdt : clarifications.entrySet()) {
            List<ListenerDamage> unclaimedForSdt = unclaimedDamages.get(clarificationsForSdt.getKey());
            if (unclaimedForSdt == null) continue;
            for (ResolvedDamage rd : FrameProcessorProjectile.resolveDamageFromListener(clarificationsForSdt.getKey().sourceShip, clarificationsForSdt.getKey().targetShip, unclaimedForSdt, clarificationsForSdt.getValue())) {
                this._unclaimedDamages.addReportableDamage(new ReportableDamage(rd.frameDamage.getWeaponName(), rd.listenerDamage, this.wasKillingBlow(rd.listenerDamage, rd.frameDamage.getWeaponName())));
            }
        }
    }

    private boolean isValidForProcessing(ShipAPI source, ShipAPI target) {
        return !(!source.isAlive() && !this._state.aliveShipsLastFrameById.containsKey(source.getId()) || !target.isAlive() && !this._state.aliveShipsLastFrameById.containsKey(target.getId()));
    }

    private boolean isValidForProcessingStrict(ShipAPI source, ShipAPI target) {
        return source.isAlive() && target.isAlive();
    }

    public String getWeaponName(ListenerDamage ld, List<ListenerDamage> maybeCollisions) {
        if (!this.isValidForProcessing(ld.source, ld.target)) {
            return null;
        }
        ++this._processedCount;
        String weaponName = this.processSpecialCase(ld);
        if (weaponName != null) {
            return weaponName;
        }
        if (!this.isValidForProcessingStrict(ld.source, ld.target)) {
            return null;
        }
        if (this.areShipsMaybeColliding(ld.source, ld.target)) {
            maybeCollisions.add(ld);
            return null;
        }
        ++this._wasUnknown;
        this._unknownDamage += (double)ld.getListedDamage();
        return Helpers.getUnknownWeaponName(ld.damageType);
    }

    private String processSpecialCase(ListenerDamage ld) {
        String hullId;
        ShipHullSpecAPI hullSpec = ld.source.getHullSpec();
        String string = hullId = hullSpec.getBaseHullId() == null ? hullSpec.getHullId() : hullSpec.getBaseHullId();
        if (hullId.equalsIgnoreCase("ziggurat") && ld.damageType == DamageType.ENERGY) {
            this._accurateDamage += (double)ld.getListedDamage();
            ++this._wasCustom;
            return "Mote";
        }
        return null;
    }

    public boolean areShipsMaybeColliding(ShipAPI source, ShipAPI target) {
        Vector2f b;
        Vector2f a = source.getLocation();
        return VectorUtil.distance(a, b = target.getLocation()) < 400.0;
    }

    @Override
    public String getStatsToString() {
        String ret = "Unclaimed Processor (" + this.getProcessingTime() + "ms):  Total: " + this._processedCount;
        if (this._processedCount > 0) {
            ret = ret + "  Custom: " + this._wasCustom + " (" + Helpers.formatAsPercent((double)this._wasCustom / (double)this._processedCount) + ")  Collision: " + this._collisions + "  Unknown " + this._wasUnknown + " (" + Helpers.formatAsPercent((double)this._wasUnknown / (double)this._processedCount) + ")";
        }
        return ret;
    }

    public ReportableDamageSet getCombatDamages() {
        return this._unclaimedDamages;
    }

    private static class Explosion {
        public final float created;
        public final DamagingProjectileAPI projectileAPI;

        public Explosion(DamagingProjectileAPI projectileAPI, float created) {
            this.projectileAPI = projectileAPI;
            this.created = created;
        }

        public String toString() {
            return "{x=" + this.projectileAPI.getLocation().x + ", y=" + this.projectileAPI.getLocation().y + " DT=" + this.projectileAPI.getDamageType() + "}";
        }
    }
}

