/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.combatanalytics.damagedetection;

import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.listeners.ApplyDamageResultAPI;
import data.scripts.combatanalytics.damagedetection.ListenerDamageInference;
import data.scripts.combatanalytics.damagedetection.RawDamage;
import data.scripts.combatanalytics.util.Helpers;
import java.util.List;
import java.util.Objects;

class ListenerDamage
implements Comparable<ListenerDamage> {
    public final DamageType damageType;
    public float armor;
    public float hull;
    public float shield;
    public float emp;
    public final boolean isDps;
    public final ShipAPI source;
    public final ShipAPI target;
    private float _listedDamage = -1.0f;

    public static boolean areAllDamagesEqualEnough(List<ListenerDamage> damages) {
        if (damages.size() < 2) {
            return true;
        }
        ListenerDamage ld = damages.get(0);
        for (int i = 1; i < damages.size(); ++i) {
            if (ld.areEqualsEnough(damages.get(i))) continue;
            return false;
        }
        return true;
    }

    public static int bestMatchIndex(float dmg, float empDmg, List<ListenerDamage> damages) {
        if (damages.size() == 0) {
            return -1;
        }
        int matchIndex = -1;
        float matchDistance = 1.0E9f;
        ListenerDamage matchDamage = null;
        for (int i = 0; i < damages.size(); ++i) {
            float thisDamage;
            float newMatchDistance;
            ListenerDamage damage = damages.get(i);
            if (damage.shield == 0.0f && damage.emp > 0.0f != empDmg > 0.0f || !((newMatchDistance = Math.abs((thisDamage = damage.getListedDamage()) - dmg)) < matchDistance)) continue;
            matchDistance = newMatchDistance;
            matchDamage = damage;
            matchIndex = i;
        }
        if (matchDamage == null) {
            return -1;
        }
        float maxDelta = (double)matchDamage.getArmorHullRatio() > 0.1 ? 0.55f : 0.4f;
        if (Helpers.computePctDeltaForDamage(dmg, matchDamage.getListedDamage()) < maxDelta) {
            return matchIndex;
        }
        return -1;
    }

    public ListenerDamage(ShipAPI sourceShip, ShipAPI targetShip, ApplyDamageResultAPI result) {
        this.damageType = result.getType();
        this.armor = result.getTotalDamageToArmor();
        this.hull = result.getDamageToHull();
        this.shield = Math.abs(result.getDamageToShields()) + result.getOverMaxDamageToShields();
        this.emp = result.getEmpDamage();
        this.isDps = result.isDps();
        this.source = sourceShip;
        this.target = targetShip;
    }

    public ListenerDamage(ShipAPI sourceShip, ShipAPI targetShip, RawDamage rawDamage, ListenerDamageInference.InferredDamageRatio idr, boolean isDps) {
        this.damageType = rawDamage.type;
        float statsDamageScalar = Helpers.getSourceDamageScalar(sourceShip, targetShip, this.damageType, isDps);
        MutableShipStatsAPI targetStats = targetShip.getMutableStats();
        switch (this.damageType) {
            case KINETIC: {
                statsDamageScalar *= targetStats.getKineticDamageTakenMult().getModifiedValue();
                break;
            }
            case HIGH_EXPLOSIVE: {
                statsDamageScalar *= targetStats.getHighExplosiveDamageTakenMult().getModifiedValue();
                break;
            }
            case FRAGMENTATION: {
                statsDamageScalar *= targetStats.getFragmentationDamageTakenMult().getModifiedValue();
                break;
            }
            case ENERGY: {
                statsDamageScalar *= targetStats.getEnergyDamageTakenMult().getModifiedValue();
                break;
            }
        }
        float raw = rawDamage.damage * statsDamageScalar;
        this.armor = (float)(idr.armor * (double)raw * (double)rawDamage.type.getArmorMult() * (double)targetStats.getArmorDamageTakenMult().getModifiedValue()) / 3.0f;
        this.hull = (float)(idr.hull * (double)raw * (double)rawDamage.type.getHullMult() * (double)targetStats.getHullDamageTakenMult().getModifiedValue());
        this.shield = (float)(idr.shield * (double)raw * (double)rawDamage.type.getShieldMult() * (double)targetStats.getShieldDamageTakenMult().getModifiedValue());
        if (this.shield > 0.0f && targetShip.getShield() != null) {
            this.shield *= targetShip.getShield().getFluxPerPointOfDamage();
        } else {
            this.emp = rawDamage.emp * statsDamageScalar;
        }
        this.isDps = isDps;
        this.source = sourceShip;
        this.target = targetShip;
    }

    public ListenerDamage(DamageType damageType, float armor, float hull, float shield, float emp, boolean isDps, ShipAPI source, ShipAPI target) {
        this.damageType = damageType;
        this.armor = armor;
        this.hull = hull;
        this.shield = shield;
        this.emp = emp;
        this.isDps = isDps;
        this.source = source;
        this.target = target;
    }

    public float getArmorHullRatio() {
        if (this.hull == 0.0f && this.armor > 0.0f) {
            return 1.0f;
        }
        if (this.armor == 0.0f) {
            return 0.0f;
        }
        return this.armor / this.hull;
    }

    public float getRealDamage() {
        return this.shield + this.hull + this.armor;
    }

    public ListenerDamage rescaleBeamDamage(float amount) {
        float scalar = amount / 0.1f;
        return new ListenerDamage(this.damageType, this.armor * scalar, this.hull * scalar, this.shield * scalar, this.emp * scalar, this.isDps, this.source, this.target);
    }

    public void addDamage(ListenerDamage damage) {
        this.shield += damage.shield;
        this.armor += damage.armor;
        this.hull += damage.hull;
        this.emp += damage.emp;
    }

    public String toString() {
        return this.damageType + " " + this.getListedDamage() + "  " + this.source.getHullSpec().getHullName() + " -> " + this.target.getHullSpec().getHullName() + "  armor=" + this.armor + ", hull=" + this.hull + ", shield=" + this.shield + ", emp=" + this.emp + ", isDps=" + this.isDps;
    }

    public boolean areEqualsEnough(ListenerDamage that) {
        float equalityDelta = (double)this.getArmorHullRatio() > 0.1 && (double)that.getArmorHullRatio() > 0.1 ? 0.55f : 0.4f;
        return Helpers.computePctDeltaForDamage(that.armor * 2.0f + that.hull / 2.0f + that.shield / 2.0f + that.emp, this.armor * 2.0f + this.hull / 2.0f + this.shield / 2.0f + this.emp) < equalityDelta;
    }

    public int hashCode() {
        return Objects.hash(this.damageType, Float.valueOf(this.armor), Float.valueOf(this.hull), Float.valueOf(this.shield), Float.valueOf(this.emp), this.isDps, this.source, this.target);
    }

    @Override
    public int compareTo(ListenerDamage o) {
        return Float.compare(this.getRealDamage(), o.getRealDamage());
    }

    public float getListedDamage() {
        if (this._listedDamage != -1.0f) {
            return this._listedDamage;
        }
        MutableShipStatsAPI targetStats = this.target.getMutableStats();
        float shield = this.shield * (1.0f / this.damageType.getShieldMult()) * (1.0f / targetStats.getShieldDamageTakenMult().getModifiedValue());
        float armor = 2.0f * this.armor * (1.0f / this.damageType.getArmorMult()) * (1.0f / targetStats.getArmorDamageTakenMult().getModifiedValue());
        float hull = this.hull * (1.0f / this.damageType.getHullMult()) * (1.0f / targetStats.getHullDamageTakenMult().getModifiedValue());
        if (shield == 0.0f && hull == 0.0f) {
            armor = (float)((double)armor * 1.5);
        }
        if (shield != 0.0f && this.target.getShield() != null) {
            shield *= 1.0f / this.target.getShield().getFluxPerPointOfDamage();
        }
        float totalAdjustedListenerDamage = shield + armor + hull;
        totalAdjustedListenerDamage *= 1.0f / Helpers.getSourceDamageScalar(this.source, this.target, this.damageType, this.isDps);
        switch (this.damageType) {
            case KINETIC: {
                totalAdjustedListenerDamage *= 1.0f / targetStats.getKineticDamageTakenMult().getModifiedValue();
                break;
            }
            case HIGH_EXPLOSIVE: {
                totalAdjustedListenerDamage *= 1.0f / targetStats.getHighExplosiveDamageTakenMult().getModifiedValue();
                break;
            }
            case FRAGMENTATION: {
                totalAdjustedListenerDamage *= 1.0f / targetStats.getFragmentationDamageTakenMult().getModifiedValue();
                break;
            }
            case ENERGY: {
                totalAdjustedListenerDamage *= 1.0f / targetStats.getEnergyDamageTakenMult().getModifiedValue();
                break;
            }
        }
        this._listedDamage = totalAdjustedListenerDamage;
        return this._listedDamage;
    }
}

