/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.combatanalytics.damagedetection;

import com.fs.starfarer.api.combat.ShipAPI;
import data.scripts.combatanalytics.damagedetection.ListenerDamage;
import data.scripts.combatanalytics.damagedetection.ResolvedDamage;
import data.scripts.combatanalytics.damagedetection.SourceTargetDamageType;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;

public class ListenerDamageInference {
    private final HashMap<SourceTargetDamageType, InferredDamageRatio> _sdtToDamage = new HashMap();
    private final HashMap<SourceTargetWeapon, ListenerDamage> _stwToLastDamage = new HashMap();
    private static final InferredDamageRatio _missingRatio = new InferredDamageRatio();

    public InferredDamageRatio getInferredRatio(SourceTargetDamageType std, List<ListenerDamage> listenerDamages) {
        if (listenerDamages == null || listenerDamages.size() == 0) {
            InferredDamageRatio ret = this._sdtToDamage.get(std);
            if (ret == null) {
                ret = _missingRatio;
            }
            return ret;
        }
        InferredDamageRatio idr = new InferredDamageRatio();
        for (ListenerDamage ld : listenerDamages) {
            idr.shield += (double)ld.shield;
            idr.armor += (double)ld.armor;
            idr.hull += (double)ld.hull;
        }
        idr.normalize();
        this._sdtToDamage.put(std, idr);
        return idr;
    }

    public void updateLastResolvedDamages(List<ResolvedDamage> resolvedDamages) {
        for (ResolvedDamage rd : resolvedDamages) {
            this._stwToLastDamage.put(new SourceTargetWeapon(rd.sourceShip, rd.targetShip, rd.frameDamage.getWeaponName()), rd.listenerDamage);
        }
    }

    public ListenerDamage getPriorFrameListenerDamage(ShipAPI source, ShipAPI target, String weaponName) {
        return this._stwToLastDamage.get(new SourceTargetWeapon(source, target, weaponName));
    }

    public String toString() {
        return "LDI DamageCount=" + this._sdtToDamage.size() + ", LastDamageCount=" + this._stwToLastDamage.size();
    }

    static {
        ListenerDamageInference._missingRatio.armor = 0.2;
    }

    static class InferredDamageRatio {
        public double shield;
        public double armor;
        public double hull;

        InferredDamageRatio() {
        }

        public void normalize() {
            double sum = this.shield + this.armor + this.hull;
            this.shield /= sum;
            this.armor /= sum;
            this.hull /= sum;
        }

        public String toString() {
            return "IDR shield=" + this.shield + ", armor=" + this.armor + ", hull=" + this.hull;
        }
    }

    static class SourceTargetWeapon {
        public final ShipAPI targetShip;
        public final ShipAPI sourceShip;
        public final String weapon;

        public SourceTargetWeapon(ShipAPI sourceShipApi, ShipAPI targetShip, String weapon) {
            this.targetShip = targetShip;
            this.sourceShip = sourceShipApi;
            this.weapon = weapon;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SourceTargetWeapon that = (SourceTargetWeapon)o;
            return this.targetShip.equals(that.targetShip) && this.sourceShip.equals(that.sourceShip) && this.weapon.equals(that.weapon);
        }

        public int hashCode() {
            return Objects.hash(this.targetShip, this.sourceShip, this.weapon);
        }

        public String toString() {
            return "STW " + this.sourceShip + " * " + this.weapon + " => " + this.targetShip;
        }
    }
}

