/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.combatanalytics.damagedetection;

import com.fs.starfarer.api.combat.ShipAPI;
import data.scripts.combatanalytics.damagedetection.DamageDetectorListener;
import data.scripts.combatanalytics.damagedetection.ListenerDamage;
import data.scripts.combatanalytics.damagedetection.ReportableDamage;
import data.scripts.combatanalytics.damagedetection.SourceTargetDamageType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ListenerManager {
    private final HashMap<String, DamageDetectorListener> _shipIdToListener = new HashMap(100);

    void ensureShipsHaveListeners(List<ShipAPI> ships) {
        for (ShipAPI ship : ships) {
            if (!ship.isAlive() || this._shipIdToListener.containsKey(ship.getId())) continue;
            ship.removeListenerOfClass(DamageDetectorListener.class);
            DamageDetectorListener listener = new DamageDetectorListener(ship);
            ship.addListener((Object)listener);
            this._shipIdToListener.put(ship.getId(), listener);
        }
    }

    void clearState() {
        for (DamageDetectorListener listener : new ArrayList<DamageDetectorListener>(this._shipIdToListener.values())) {
            listener.clearDamageResults();
        }
    }

    void handleDestroyedShips(Collection<ShipAPI> ships) {
        for (ShipAPI ship : ships) {
            DamageDetectorListener listener = this._shipIdToListener.remove(ship.getId());
            if (listener == null) continue;
            listener.dispose();
        }
    }

    Map<SourceTargetDamageType, List<ListenerDamage>> getListenerDamages(boolean isBeam) {
        HashMap<SourceTargetDamageType, List<ListenerDamage>> ret = new HashMap<SourceTargetDamageType, List<ListenerDamage>>();
        for (DamageDetectorListener listener : this._shipIdToListener.values()) {
            for (Map.Entry<SourceTargetDamageType, List<ListenerDamage>> entry : listener.getAllDamages(isBeam).entrySet()) {
                ret.put(entry.getKey(), entry.getValue());
            }
        }
        return ret;
    }

    List<ReportableDamage> getBallisticDamages() {
        ArrayList<ReportableDamage> ret = new ArrayList<ReportableDamage>();
        for (DamageDetectorListener listener : this._shipIdToListener.values()) {
            ret.addAll(listener.getBallisticDamages());
        }
        return ret;
    }

    public void dispose() {
        for (DamageDetectorListener listener : this._shipIdToListener.values()) {
            listener.dispose();
        }
        this._shipIdToListener.clear();
    }
}

