/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.combatanalytics.damagedetection;

import com.fs.starfarer.api.combat.ShipAPI;
import data.scripts.combatanalytics.damagedetection.FrameDamage;
import data.scripts.combatanalytics.damagedetection.ListenerDamage;
import data.scripts.combatanalytics.util.Settings;
import java.util.Objects;

class ReportableDamage {
    public final ListenerDamage listenerDamage;
    public ShipAPI targetShip;
    public ShipAPI sourceShip;
    public String weaponName;
    public int damagingEntityId;
    public boolean wasKillingBlow;

    ReportableDamage(FrameDamage fd, ListenerDamage ld, boolean wasKillingBlow) {
        this.listenerDamage = ld;
        this.wasKillingBlow = wasKillingBlow;
        this.damagingEntityId = fd.getProjectile() != null ? System.identityHashCode(fd.getProjectile()) : -1;
        this.targetShip = ld.target;
        this.sourceShip = ld.source;
        this.weaponName = fd.getWeaponName();
        if (this.sourceShip.isFighter() && !this.sourceShip.isDrone()) {
            this.weaponName = ReportableDamage.GetFighterWeaponName(this.sourceShip, this.weaponName);
            if (this.sourceShip.getWing() != null && this.sourceShip.getWing().getSourceShip() != null) {
                this.sourceShip = this.sourceShip.getWing().getSourceShip();
            }
        } else if (this.sourceShip.isDrone() && this.sourceShip.getDroneSource() != null) {
            this.weaponName = ReportableDamage.GetDroneWeaponName(this.sourceShip, this.weaponName);
            this.sourceShip = this.sourceShip.getDroneSource();
        }
    }

    ReportableDamage(String weaponName, ListenerDamage ld, boolean wasKillingBlow) {
        this.weaponName = weaponName;
        this.listenerDamage = ld;
        this.wasKillingBlow = wasKillingBlow;
        this.damagingEntityId = -1;
        this.targetShip = ld.target;
        this.sourceShip = ld.source;
    }

    public static String GetFighterWeaponName(ShipAPI sourceShip, String weaponName) {
        String ret = sourceShip.getHullSpec().getHullName() + " Fighter";
        if (Settings.getFighterWeaponBreakout()) {
            ret = ret + " - " + weaponName;
        }
        return ret;
    }

    public static String GetDroneWeaponName(ShipAPI sourceShip, String weaponName) {
        String ret = sourceShip.getHullSpec().getHullName() + " Drone";
        if (Settings.getFighterWeaponBreakout()) {
            ret = ret + " - " + weaponName;
        }
        return ret;
    }

    public String toString() {
        return this.sourceShip.toString() + " * " + this.weaponName + " => " + this.targetShip.toString() + "  " + this.listenerDamage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReportableDamage that = (ReportableDamage)o;
        return this.damagingEntityId == that.damagingEntityId && this.targetShip.equals(that.targetShip) && this.sourceShip.equals(that.sourceShip) && this.weaponName.equals(that.weaponName);
    }

    public int hashCode() {
        return Objects.hash(this.targetShip, this.sourceShip, this.weaponName, this.damagingEntityId);
    }
}

