/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.combatanalytics.damagedetection;

import data.scripts.combatanalytics.damagedetection.ListenerDamageInference;
import data.scripts.combatanalytics.damagedetection.ReportableDamage;
import data.scripts.combatanalytics.util.LRUMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ReportableDamageSet {
    private final HashMap<ListenerDamageInference.SourceTargetWeapon, ReportableDamage> _combatDamages = new HashMap(10000);
    private LRUMap<Integer, Integer> _processedHashcodes = null;
    private final boolean _enforceUniqueness;

    public ReportableDamageSet(boolean enforceUniqueness) {
        this._enforceUniqueness = enforceUniqueness;
        if (enforceUniqueness) {
            this._processedHashcodes = new LRUMap(10000, 25000);
        }
    }

    public List<ReportableDamage> getAggregatedCombatDamages() {
        return new ArrayList<ReportableDamage>(this._combatDamages.values());
    }

    public void addAllReportableDamages(List<ReportableDamage> rds) {
        for (ReportableDamage rd : rds) {
            this.addReportableDamage(rd);
        }
    }

    public void addReportableDamage(ReportableDamage rd) {
        ListenerDamageInference.SourceTargetWeapon stw;
        ReportableDamage savedDamage;
        if (this._enforceUniqueness) {
            if (this._processedHashcodes.containsKey(rd.damagingEntityId)) {
                return;
            }
            this._processedHashcodes.put(rd.damagingEntityId, rd.damagingEntityId);
        }
        if ((savedDamage = this._combatDamages.get(stw = new ListenerDamageInference.SourceTargetWeapon(rd.sourceShip, rd.targetShip, rd.weaponName))) == null) {
            this._combatDamages.put(stw, rd);
        } else {
            savedDamage.listenerDamage.addDamage(rd.listenerDamage);
            savedDamage.wasKillingBlow |= rd.wasKillingBlow;
        }
    }

    public int size() {
        return this._combatDamages.size();
    }

    public String toString() {
        return "ReportableDamageSet{_combatDamages=" + this._combatDamages.size() + "}";
    }
}

