/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.combatanalytics.data;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.ShipAPI;
import data.scripts.combatanalytics.data.CombatGoal;
import data.scripts.combatanalytics.data.Damage;
import data.scripts.combatanalytics.data.Ship;
import data.scripts.combatanalytics.data.WeaponCountingDamage;
import data.scripts.combatanalytics.data.WeaponShipDamage;
import data.scripts.combatanalytics.function.AggregateProcessor;
import data.scripts.combatanalytics.function.DamageSet;
import data.scripts.combatanalytics.function.GroupedByShipDamage;
import data.scripts.combatanalytics.util.Helpers;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class CombatResult
implements Comparable<CombatResult> {
    private static final Logger log = Global.getLogger(CombatResult.class);
    public String combatId;
    public String faction;
    public String fleetName;
    public long engagementEndTime;
    public float combatDurationSeconds;
    public WeaponShipDamage[] weaponShipDamages;
    public WeaponCountingDamage[] weaponCountingDamages;
    public CombatGoal enemyFleetGoal;
    public Ship[] allShips;

    private CombatResult() {
    }

    public CombatResult(String combatId, String faction, String fleetName, long engagementEndTime, Damage[] damages, float combatDurationSeconds, CombatGoal enemyFleetGoal, List<Ship> allShips) {
        this.combatId = combatId;
        this.faction = faction;
        this.fleetName = fleetName;
        this.engagementEndTime = engagementEndTime;
        this.combatDurationSeconds = combatDurationSeconds;
        this.enemyFleetGoal = enemyFleetGoal;
        this.allShips = allShips.toArray(new Ship[0]);
        WeaponShipDamage[] weaponTargetDamages = CombatResult.buildWeaponTargetDamages(damages, combatId);
        this.setWeaponDamages(weaponTargetDamages);
        log.debug((Object)("Computing combat results from " + damages.length + " Damages  =>  " + this.weaponShipDamages.length + " WeaponShipDamages  " + this.weaponCountingDamages.length + " WeaponCountingDamages  " + this.allShips.length + " Total Ships"));
    }

    public int getEnemyFleetSize() {
        int ret = 0;
        for (Ship s : this.allShips) {
            if (s.owner != 1 || s.hullSize == ShipAPI.HullSize.FIGHTER || s.hullSize == ShipAPI.HullSize.DEFAULT) continue;
            ++ret;
        }
        return ret;
    }

    public int getEnemyDeploymentPoints() {
        int ret = 0;
        for (Ship s : this.allShips) {
            if (s.owner != 1 || s.hullSize == ShipAPI.HullSize.FIGHTER || s.hullSize == ShipAPI.HullSize.DEFAULT) continue;
            ret += s.deploymentPoints;
        }
        return ret;
    }

    public String toString() {
        float totalDamage = 0.0f;
        for (WeaponShipDamage wtd : this.weaponShipDamages) {
            totalDamage = (float)((double)totalDamage + (wtd.armorDamage + wtd.hullDamage + wtd.shieldDamage));
        }
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(this.engagementEndTime);
        return String.format("%1$s %2$s (%3$s total ships involved) on %4$s  %5$s total damage exchanged", this.faction, this.fleetName, this.allShips.length, Helpers.ISO_DATE_TIME.format(cal.getTime()), Helpers.INT_FORMAT.format(totalDamage));
    }

    private static WeaponShipDamage[] buildWeaponTargetDamages(Damage[] damages, String combatId) {
        HashMap<CallSite, WeaponShipDamage> keyToWtd = new HashMap<CallSite, WeaponShipDamage>();
        for (Damage dmg : damages) {
            if (dmg.firingShip.owner == dmg.targetShip.owner && !dmg.isHealing() || dmg.targetShip.hullSize == ShipAPI.HullSize.DEFAULT && dmg.targetShip.name.startsWith("Flare Launcher")) continue;
            String key = dmg.firingShip.id + dmg.targetShip.id + dmg.weaponName;
            WeaponShipDamage wtd = (WeaponShipDamage)keyToWtd.get(key);
            if (wtd == null) {
                wtd = new WeaponShipDamage(dmg.firingShip, dmg.targetShip, dmg.weaponName);
                keyToWtd.put((CallSite)((Object)key), wtd);
                log.debug((Object)("Creating new WeaponShipDamage entry for: " + dmg.targetShip + "-" + dmg.weaponName));
            }
            wtd.merge(dmg);
        }
        Object[] ret = keyToWtd.values().toArray(new WeaponShipDamage[0]);
        Arrays.sort(ret);
        CombatResult.computePctDamageToTargets((WeaponShipDamage[])ret);
        return ret;
    }

    private void setWeaponDamages(WeaponShipDamage[] wsds) {
        ArrayList<WeaponCountingDamage> countingDamages = new ArrayList<WeaponCountingDamage>();
        ArrayList<WeaponShipDamage> shipDamages = new ArrayList<WeaponShipDamage>();
        HashMap<Ship, GroupedByShipDamage> shipToStats = new HashMap<Ship, GroupedByShipDamage>();
        AggregateProcessor.aggregateWeaponTargetDamages(wsds, new WeaponCountingDamage[0], shipToStats);
        for (Map.Entry shipToDamage : shipToStats.entrySet()) {
            if (((Ship)shipToDamage.getKey()).hullSize.ordinal() < ShipAPI.HullSize.FRIGATE.ordinal()) continue;
            for (Map.Entry<String, DamageSet> weaponToDamage : ((GroupedByShipDamage)shipToDamage.getValue()).weaponNameToDamage.entrySet()) {
                int fighterKills = weaponToDamage.getValue().aggregateFighters().getMajorityKills().size();
                int missileKills = weaponToDamage.getValue().aggregateMissiles().getMajorityKills().size();
                if (fighterKills <= 0 && missileKills <= 0) continue;
                countingDamages.add(new WeaponCountingDamage((Ship)shipToDamage.getKey(), weaponToDamage.getKey(), missileKills, fighterKills));
            }
        }
        for (WeaponShipDamage wsd : wsds) {
            if (wsd.target.hullSize == ShipAPI.HullSize.FIGHTER || wsd.target.hullSize == ShipAPI.HullSize.DEFAULT) continue;
            wsd.prepForSave();
            shipDamages.add(wsd);
        }
        this.weaponShipDamages = shipDamages.toArray(new WeaponShipDamage[0]);
        this.weaponCountingDamages = countingDamages.toArray(new WeaponCountingDamage[0]);
    }

    public static void computePctDamageToTargets(WeaponShipDamage[] wsds) {
        HashMap<Ship, Double> shipToTotalDamage = new HashMap<Ship, Double>();
        for (WeaponShipDamage wtd : wsds) {
            if (!wtd.target.status.wasKilled() || wtd.hullDamage + wtd.armorDamage < 0.0) continue;
            Double d = (Double)shipToTotalDamage.get(wtd.target);
            if (d == null) {
                d = 0.0;
            }
            d = d + (wtd.hullDamage + wtd.armorDamage);
            shipToTotalDamage.put(wtd.target, d);
        }
        for (WeaponShipDamage wsd : wsds) {
            Double totalDmgToShip = (Double)shipToTotalDamage.get(wsd.target);
            if (totalDmgToShip == null || !(totalDmgToShip >= 1.0)) continue;
            wsd.pctOfDamageDoneToTarget = (wsd.hullDamage + wsd.armorDamage) / totalDmgToShip;
        }
    }

    @Override
    public int compareTo(CombatResult combatResult) {
        return Long.compare(combatResult.engagementEndTime, this.engagementEndTime);
    }

    private Object readResolve() {
        this.faction = this.faction.intern();
        this.fleetName = this.fleetName.intern();
        return this;
    }
}

