/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.combatanalytics.data;

import data.scripts.combatanalytics.data.Ship;
import data.scripts.combatanalytics.util.Helpers;

public class Damage {
    public final String weaponName;
    public final float shieldDamage;
    public final float empDamage;
    public final float armorDamage;
    public final float hullDamage;
    public final Ship firingShip;
    public final Ship targetShip;
    public boolean wasKillingBlow;
    public final String combatId;

    public Damage(String combatId, String weaponName, float shieldDamage, float armorDamage, float hullDamage, float empDamage, boolean wasKillingBlow, Ship firingShip, Ship targetShip) {
        this.combatId = combatId;
        this.weaponName = weaponName == null || weaponName.isEmpty() ? "Unknown" : weaponName;
        this.shieldDamage = shieldDamage;
        this.empDamage = empDamage;
        this.armorDamage = armorDamage;
        this.hullDamage = hullDamage;
        this.wasKillingBlow = wasKillingBlow;
        this.firingShip = firingShip;
        this.targetShip = targetShip;
    }

    public boolean isHealing() {
        return this.shieldDamage + this.empDamage + this.armorDamage + this.hullDamage < 0.0f;
    }

    public String toString() {
        return String.format("%1$.2fs %2$s-->%3$s-->%4$s  %5$s shield dmg   %6$s armor dmg   %7$s hull dmg   %8$s flux dmg", Float.valueOf(0.0f), this.firingShip, this.weaponName, this.targetShip, Helpers.INT_FORMAT.format(this.shieldDamage), Helpers.INT_FORMAT.format(this.armorDamage), Helpers.INT_FORMAT.format(this.hullDamage), Helpers.INT_FORMAT.format(this.empDamage));
    }
}

