/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.combatanalytics.data;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import data.scripts.combatanalytics.data.ShipStatus;
import data.scripts.combatanalytics.data.WeaponSet;
import data.scripts.combatanalytics.util.Helpers;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class Ship
implements Comparable<Ship> {
    private static final Logger log = Global.getLogger(Ship.class);
    public static final String NO_CAPTAIN = "No Captain";
    public static final String NO_NAME = "No Name";
    public String id;
    public String name;
    public ShipAPI.HullSize hullSize;
    public String hullClass;
    public int owner;
    public float maxHp;
    public float remainingHp;
    public int deploymentPoints;
    public String captain = "No Captain";
    public String hullId;
    public ShipStatus status = ShipStatus.OK;
    public String captainSprite = "";
    public List<WeaponSet> weaponSets = new ArrayList<WeaponSet>();

    private Ship() {
    }

    public Ship(ShipAPI ship) {
        this.id = ship.isFighter() || ship.isDrone() || ship.getFleetMemberId() == null ? Helpers.getSmallUuid() : ship.getFleetMemberId();
        this.name = Helpers.coalesce(ship.getName(), this.id, NO_NAME);
        this.hullSize = ship.getHullSpec().getHullSize();
        this.hullClass = this.cleanUpDesignation(ship.getHullSpec().getHullName());
        this.owner = ship.getOriginalOwner();
        this.maxHp = ship.getMaxHitpoints();
        this.hullId = ship.getHullSpec().getHullId();
        if (this.hullSize == ShipAPI.HullSize.FIGHTER) {
            this.name = this.hullClass + " Fighter";
        }
    }

    public Ship(FleetMemberAPI fm, String combatId) {
        this.id = fm.isFighterWing() ? Helpers.getSmallUuid() : fm.getId();
        this.name = Helpers.coalesce(fm.getShipName(), this.id, NO_NAME);
        this.hullSize = fm.getHullSpec().getHullSize();
        this.hullClass = this.cleanUpDesignation(fm.getHullSpec().getHullName());
        this.owner = fm.getOwner();
        this.maxHp = fm.getHullSpec().getHitpoints();
        this.hullId = fm.getHullSpec().getHullId();
        if (this.hullSize == ShipAPI.HullSize.FIGHTER) {
            this.name = this.hullClass + " Fighter";
        }
    }

    public void setCaptain(PersonAPI captain) {
        if (captain != null) {
            this.captain = captain.getName().getFullName();
            this.captainSprite = captain.getPortraitSprite();
        }
    }

    public void setFleetMemberData(PersonAPI captain, int deploymentPoints, ShipStatus status, float remainingHp) {
        this.setCaptain(captain);
        this.deploymentPoints = deploymentPoints;
        this.status = status;
        this.remainingHp = remainingHp;
        if (status.wasKilled()) {
            this.remainingHp = 0.0f;
        }
    }

    public Ship(String id, String name, ShipAPI.HullSize hullSize, String hullClass, float maxHitpoints, float maxFlux, int owner, int deploymentPoints, String captain, String hullId, ShipStatus shipStatus, String captainSprite, float remainingHp) {
        this.id = id;
        this.name = name;
        this.hullSize = hullSize;
        this.hullClass = hullClass;
        this.owner = owner;
        this.deploymentPoints = deploymentPoints;
        this.maxHp = maxHitpoints;
        this.captain = captain;
        if (this.captain.equals("")) {
            this.captain = NO_CAPTAIN;
        }
        this.captainSprite = captainSprite;
        this.hullId = hullId;
        this.status = shipStatus;
        this.remainingHp = remainingHp;
    }

    private String cleanUpDesignation(String designation) {
        int dashIndex = designation.lastIndexOf("-class");
        if (dashIndex > -1) {
            return designation.substring(0, dashIndex);
        }
        dashIndex = designation.lastIndexOf(" class");
        if (dashIndex > -1) {
            return designation.substring(0, dashIndex);
        }
        return designation.trim();
    }

    public boolean hasCaptain() {
        return !this.captain.equals(NO_CAPTAIN);
    }

    public String toString() {
        return String.format("%1$s - %2$s - %3$s - %4$s", this.name, this.hullSize, this.hullClass, Helpers.ownerAsString(this.owner));
    }

    public String getHullSizeString() {
        switch (this.hullSize) {
            case CAPITAL_SHIP: {
                return "Capital";
            }
            case CRUISER: {
                return "Cruiser";
            }
            case DESTROYER: {
                return "Destroyer";
            }
            case FRIGATE: {
                return "Frigate";
            }
            case FIGHTER: {
                return "Fighter";
            }
        }
        return this.hullSize.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Ship ship = (Ship)o;
        return this.id.equals(ship.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    @Override
    public int compareTo(Ship o) {
        int ret = Integer.compare(this.owner, o.owner);
        if (ret == 0) {
            ret = Integer.compare(this.deploymentPoints, o.deploymentPoints);
        }
        if (ret == 0) {
            ret = this.name.compareTo(o.name);
        }
        return ret;
    }

    public double getRemainingHullPct() {
        if ((double)this.remainingHp < 0.001) {
            return 0.0;
        }
        double ret = this.remainingHp / this.maxHp;
        if (Double.isNaN(ret) || Double.isInfinite(ret)) {
            return 1.0;
        }
        return ret;
    }

    private Object readResolve() {
        this.captain = this.captain.intern();
        this.name = this.name.intern();
        this.hullId = this.hullId.intern();
        this.hullClass = this.hullClass.intern();
        return this;
    }
}

