/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.combatanalytics.data;

import com.fs.starfarer.api.Global;
import data.scripts.combatanalytics.data.Damage;
import data.scripts.combatanalytics.data.Ship;
import data.scripts.combatanalytics.util.Helpers;
import org.apache.log4j.Logger;

public class WeaponShipDamage
implements Comparable<WeaponShipDamage> {
    private static final Logger log = Global.getLogger(WeaponShipDamage.class);
    public Ship source;
    public Ship target;
    public String weapon;
    public int hits = 0;
    public double shieldDamage = 0.0;
    public double armorDamage = 0.0;
    public double hullDamage = 0.0;
    public double empDamage = 0.0;
    public double pctOfDamageDoneToTarget;
    public int killingBlow = 0;

    private WeaponShipDamage() {
    }

    public WeaponShipDamage(Ship source, Ship target, String weapon) {
        this.source = source;
        this.target = target;
        this.weapon = weapon;
    }

    public boolean isHealing() {
        return this.shieldDamage + this.empDamage + this.armorDamage + this.hullDamage < 0.0;
    }

    public void merge(Damage d) {
        ++this.hits;
        this.shieldDamage += (double)d.shieldDamage;
        this.armorDamage += (double)d.armorDamage;
        this.hullDamage += (double)d.hullDamage;
        this.empDamage += (double)d.empDamage;
        this.killingBlow += d.wasKillingBlow ? 1 : 0;
    }

    @Override
    public int compareTo(WeaponShipDamage o) {
        int compare = o.target.name.compareTo(this.target.name);
        if (compare != 0) {
            return compare;
        }
        compare = o.source.name.compareTo(this.source.name);
        if (compare != 0) {
            return compare;
        }
        return o.weapon.compareTo(this.weapon);
    }

    public String toString() {
        return String.format("%2$s-->%3$s-->%4$s  %5$s shield dmg   %6$s armor dmg   %7$s hull dmg   %8$s flux dmg", Float.valueOf(0.0f), this.source, this.weapon, this.target, Helpers.INT_FORMAT.format(this.shieldDamage), Helpers.INT_FORMAT.format(this.armorDamage), Helpers.INT_FORMAT.format(this.hullDamage), Helpers.INT_FORMAT.format(this.empDamage));
    }

    private Object readResolve() {
        this.weapon = this.weapon.intern();
        return this;
    }

    public void prepForSave() {
        this.shieldDamage = (int)this.shieldDamage;
        this.armorDamage = (int)this.armorDamage;
        this.hullDamage = (int)this.hullDamage;
        this.empDamage = (int)this.empDamage;
        this.pctOfDamageDoneToTarget = (double)Math.round(this.pctOfDamageDoneToTarget * 1000.0) / 1000.0;
    }
}

