/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.combatanalytics.function;

import data.scripts.combatanalytics.data.Ship;
import data.scripts.combatanalytics.data.WeaponCountingDamage;
import data.scripts.combatanalytics.data.WeaponShipDamage;
import data.scripts.combatanalytics.function.DamageSummary;
import java.util.HashMap;
import java.util.Map;

public class AggregateDamage
implements Comparable<AggregateDamage> {
    public static final double AssistThreshold = (double)0.2f;
    public static final double SoloThreshold = 0.7999999970197678;
    public final String groupName;
    private final DamageSummary damageSummary = new DamageSummary();
    private final Map<Ship, DamageSummary> targetsToDamage = new HashMap<Ship, DamageSummary>();

    public AggregateDamage(String groupName) {
        this.groupName = groupName;
    }

    public void merge(WeaponShipDamage d) {
        this.damageSummary.merge(d);
        DamageSummary shipDamageSummary = this.targetsToDamage.get(d.target);
        if (shipDamageSummary == null) {
            shipDamageSummary = new DamageSummary();
            this.targetsToDamage.put(d.target, shipDamageSummary);
        }
        shipDamageSummary.merge(d);
    }

    public void merge(WeaponCountingDamage d) {
        this.damageSummary.merge(d);
    }

    public void merge(AggregateDamage d) {
        this.damageSummary.merge(d.damageSummary);
        for (Map.Entry<Ship, DamageSummary> targetToDamage : d.targetsToDamage.entrySet()) {
            DamageSummary shipDamageSummary = this.targetsToDamage.get(targetToDamage.getKey());
            if (shipDamageSummary == null) {
                shipDamageSummary = new DamageSummary();
                this.targetsToDamage.put(targetToDamage.getKey(), shipDamageSummary);
            }
            shipDamageSummary.merge(targetToDamage.getValue());
        }
    }

    public double totalRealDamage() {
        return this.damageSummary.totalRealDamage();
    }

    public double totalAllDamage() {
        return this.damageSummary.totalAllDamage();
    }

    public double getShieldDamage() {
        return this.damageSummary.shieldDamage;
    }

    public double getHullDamage() {
        return this.damageSummary.hullDamage;
    }

    public double getArmorDamage() {
        return this.damageSummary.armorDamage;
    }

    public double getEmpDamage() {
        return this.damageSummary.empDamage;
    }

    public double getHitCount() {
        return this.damageSummary.hits;
    }

    public int getKillingBlows() {
        return this.damageSummary.killingBlows;
    }

    public int getMissileKills() {
        return this.damageSummary.missileKills;
    }

    public int getFighterKills() {
        return this.damageSummary.fighterKills;
    }

    public Map<Ship, DamageSummary> getSoloKills() {
        HashMap<Ship, DamageSummary> ret = new HashMap<Ship, DamageSummary>();
        for (Map.Entry<Ship, DamageSummary> entry : this.targetsToDamage.entrySet()) {
            if (!entry.getKey().status.wasKilled() || !(entry.getValue().pctOfDamageDoneToTarget > 0.7999999970197678)) continue;
            ret.put(entry.getKey(), entry.getValue());
        }
        return ret;
    }

    public Map<Ship, DamageSummary> getAssists() {
        HashMap<Ship, DamageSummary> ret = new HashMap<Ship, DamageSummary>();
        for (Map.Entry<Ship, DamageSummary> entry : this.targetsToDamage.entrySet()) {
            if (!entry.getKey().status.wasKilled() || !(entry.getValue().pctOfDamageDoneToTarget > (double)0.2f) || !(entry.getValue().pctOfDamageDoneToTarget <= 0.7999999970197678)) continue;
            ret.put(entry.getKey(), entry.getValue());
        }
        return ret;
    }

    public Map<Ship, DamageSummary> getMajorityKills() {
        HashMap<Ship, DamageSummary> ret = new HashMap<Ship, DamageSummary>();
        for (Map.Entry<Ship, DamageSummary> entry : this.targetsToDamage.entrySet()) {
            if (!entry.getKey().status.wasKilled() || !(entry.getValue().pctOfDamageDoneToTarget > 0.5)) continue;
            ret.put(entry.getKey(), entry.getValue());
        }
        return ret;
    }

    public int getShotsfired() {
        return 1;
    }

    public double getAccuracy() {
        return 0.5;
    }

    public double getAllProRataDeploymentPointsDestroyed() {
        return this.getProRataDeploymentPointsDestroyed(this.targetsToDamage);
    }

    public double getSoloProRataDeploymentPointsDestroyed() {
        return this.getProRataDeploymentPointsDestroyed(this.getSoloKills());
    }

    public double getAssistProRataDeploymentPointsDestroyed() {
        return this.getProRataDeploymentPointsDestroyed(this.getAssists());
    }

    private double getProRataDeploymentPointsDestroyed(Map<Ship, DamageSummary> shipToDamageSummary) {
        double ret = 0.0;
        for (Map.Entry<Ship, DamageSummary> shipAndDamage : shipToDamageSummary.entrySet()) {
            if (!shipAndDamage.getKey().status.wasKilled()) continue;
            ret += (double)shipAndDamage.getKey().deploymentPoints * shipAndDamage.getValue().pctOfDamageDoneToTarget;
        }
        return ret;
    }

    public String toString() {
        return this.groupName + " " + this.damageSummary;
    }

    @Override
    public int compareTo(AggregateDamage o) {
        int ret = Double.compare(o.totalRealDamage(), this.totalRealDamage());
        if (ret == 0) {
            ret = this.groupName.compareTo(o.groupName);
        }
        return ret;
    }
}

