/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.combatanalytics.function;

import com.fs.starfarer.api.combat.ShipAPI;
import data.scripts.combatanalytics.data.CombatResult;
import data.scripts.combatanalytics.data.Ship;
import data.scripts.combatanalytics.data.WeaponCountingDamage;
import data.scripts.combatanalytics.data.WeaponShipDamage;
import data.scripts.combatanalytics.function.DamageSet;
import data.scripts.combatanalytics.function.GroupedByShipDamage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class AggregateProcessor {
    public static GroupedByShipDamage[] aggregateWeaponDamageByShip(List<CombatResult> combatResults) {
        HashMap<Ship, GroupedByShipDamage> shipToStats = new HashMap<Ship, GroupedByShipDamage>();
        for (CombatResult cr : combatResults) {
            AggregateProcessor.aggregateWeaponTargetDamages(cr.weaponShipDamages, cr.weaponCountingDamages, shipToStats);
        }
        GroupedByShipDamage[] ret = shipToStats.values().toArray(new GroupedByShipDamage[0]);
        return ret;
    }

    public static void aggregateWeaponTargetDamages(WeaponShipDamage[] weaponShipDamages, WeaponCountingDamage[] weaponCountingDamages, Map<Ship, GroupedByShipDamage> shipToStats) {
        DamageSet damagesForWeapon;
        GroupedByShipDamage gd;
        for (WeaponShipDamage weaponShipDamage : weaponShipDamages) {
            if (weaponShipDamage.source.owner == weaponShipDamage.target.owner) continue;
            gd = AggregateProcessor.getGroupedByShipDamage(weaponShipDamage.source, shipToStats);
            damagesForWeapon = gd.weaponNameToDamage.get(weaponShipDamage.weapon);
            if (damagesForWeapon == null) {
                damagesForWeapon = new DamageSet(weaponShipDamage.weapon);
                gd.weaponNameToDamage.put(weaponShipDamage.weapon, damagesForWeapon);
            }
            damagesForWeapon.merge(weaponShipDamage);
            gd.addDeliveredDamage(weaponShipDamage.target, weaponShipDamage);
            GroupedByShipDamage targetGroupedDamage = AggregateProcessor.getGroupedByShipDamage(weaponShipDamage.target, shipToStats);
            targetGroupedDamage.addReceivedDamage(gd.ship, weaponShipDamage);
        }
        for (Comparable<WeaponShipDamage> comparable : weaponCountingDamages) {
            gd = AggregateProcessor.getGroupedByShipDamage(((WeaponCountingDamage)comparable).source, shipToStats);
            damagesForWeapon = gd.weaponNameToDamage.get(((WeaponCountingDamage)comparable).weapon);
            if (damagesForWeapon == null) {
                damagesForWeapon = new DamageSet(((WeaponCountingDamage)comparable).weapon);
                gd.weaponNameToDamage.put(((WeaponCountingDamage)comparable).weapon, damagesForWeapon);
            }
            damagesForWeapon.merge((WeaponCountingDamage)comparable);
        }
    }

    public static GroupedByShipDamage[] aggregateHealingByShip(List<CombatResult> combatResults) {
        HashMap<Ship, GroupedByShipDamage> shipToStats = new HashMap<Ship, GroupedByShipDamage>();
        for (CombatResult cr : combatResults) {
            for (WeaponShipDamage wtd : cr.weaponShipDamages) {
                if (wtd.source.owner != wtd.target.owner || !wtd.isHealing()) continue;
                GroupedByShipDamage gd = AggregateProcessor.getGroupedByShipDamage(wtd.source, shipToStats);
                DamageSet damagesForWeapon = gd.weaponNameToDamage.get(wtd.weapon);
                if (damagesForWeapon == null) {
                    damagesForWeapon = new DamageSet(wtd.weapon);
                    gd.weaponNameToDamage.put(wtd.weapon, damagesForWeapon);
                }
                damagesForWeapon.merge(wtd);
                gd.addDeliveredDamage(wtd.target, wtd);
                GroupedByShipDamage targetGroupedDamage = AggregateProcessor.getGroupedByShipDamage(wtd.target, shipToStats);
                targetGroupedDamage.addReceivedDamage(gd.ship, wtd);
            }
        }
        GroupedByShipDamage[] ret = shipToStats.values().toArray(new GroupedByShipDamage[0]);
        return ret;
    }

    private static GroupedByShipDamage getGroupedByShipDamage(Ship ship, Map<Ship, GroupedByShipDamage> shipToStats) {
        GroupedByShipDamage shipGroupedDamage = shipToStats.get(ship);
        if (shipGroupedDamage == null) {
            shipGroupedDamage = new GroupedByShipDamage(ship);
            shipToStats.put(ship, shipGroupedDamage);
        }
        return shipGroupedDamage;
    }

    public static int getFleetSize(List<CombatResult> combatResults, int owner) {
        int ret = 0;
        for (Ship s : AggregateProcessor.getAllShips(combatResults, owner)) {
            ++ret;
        }
        return ret;
    }

    public static int getFleetDpValue(List<CombatResult> combatResults, int owner) {
        int ret = 0;
        for (Ship s : AggregateProcessor.getAllShips(combatResults, owner)) {
            ret += s.deploymentPoints;
        }
        return ret;
    }

    public static float getCombatDuration(List<CombatResult> combatResults) {
        double ret = 0.0;
        for (CombatResult cr : combatResults) {
            ret += (double)cr.combatDurationSeconds;
        }
        return (float)ret;
    }

    public static List<Ship> getAllShips(List<CombatResult> combatResults, int owner) {
        HashSet<Ship> seen = new HashSet<Ship>();
        for (CombatResult cr : combatResults) {
            for (Ship s : cr.allShips) {
                if (s.owner != owner || s.hullSize == ShipAPI.HullSize.FIGHTER || s.hullSize == ShipAPI.HullSize.DEFAULT) continue;
                seen.add(s);
            }
        }
        ArrayList<Ship> ret = new ArrayList<Ship>(seen);
        Collections.sort(ret);
        return ret;
    }
}

