/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.combatanalytics.function;

import com.fs.starfarer.api.combat.ShipAPI;
import data.scripts.combatanalytics.data.WeaponCountingDamage;
import data.scripts.combatanalytics.data.WeaponShipDamage;
import data.scripts.combatanalytics.function.AggregateDamage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class DamageSet
implements Iterable<WeaponShipDamage> {
    private static final Set<ShipAPI.HullSize> SHIPS = new HashSet<ShipAPI.HullSize>(Arrays.asList(ShipAPI.HullSize.FRIGATE, ShipAPI.HullSize.DESTROYER, ShipAPI.HullSize.CRUISER, ShipAPI.HullSize.CAPITAL_SHIP));
    private static final Set<ShipAPI.HullSize> ALL = new HashSet<ShipAPI.HullSize>(Arrays.asList(ShipAPI.HullSize.FIGHTER, ShipAPI.HullSize.FRIGATE, ShipAPI.HullSize.DESTROYER, ShipAPI.HullSize.CRUISER, ShipAPI.HullSize.CAPITAL_SHIP));
    private static final Set<ShipAPI.HullSize> MISSILE = new HashSet<ShipAPI.HullSize>(Collections.singletonList(ShipAPI.HullSize.DEFAULT));
    private static final Set<ShipAPI.HullSize> FIGHTER = new HashSet<ShipAPI.HullSize>(Collections.singletonList(ShipAPI.HullSize.FIGHTER));
    private static final Set<ShipAPI.HullSize> FRIGATE = new HashSet<ShipAPI.HullSize>(Collections.singletonList(ShipAPI.HullSize.FRIGATE));
    private static final Set<ShipAPI.HullSize> DESTROYER = new HashSet<ShipAPI.HullSize>(Collections.singletonList(ShipAPI.HullSize.DESTROYER));
    private static final Set<ShipAPI.HullSize> CRUISER = new HashSet<ShipAPI.HullSize>(Collections.singletonList(ShipAPI.HullSize.CRUISER));
    private static final Set<ShipAPI.HullSize> CAPITAL_SHIP = new HashSet<ShipAPI.HullSize>(Collections.singletonList(ShipAPI.HullSize.CAPITAL_SHIP));
    public final String groupName;
    private final List<WeaponShipDamage> _damages = new ArrayList<WeaponShipDamage>();
    private final List<WeaponCountingDamage> _countingDamages = new ArrayList<WeaponCountingDamage>();

    public DamageSet(String weapon) {
        this.groupName = weapon;
    }

    public void merge(WeaponShipDamage wsd) {
        this._damages.add(wsd);
    }

    public void merge(WeaponCountingDamage wcd) {
        this._countingDamages.add(wcd);
    }

    public void merge(DamageSet other) {
        this._damages.addAll(other._damages);
    }

    public AggregateDamage aggregateDamages(Set<ShipAPI.HullSize> validForCounting) {
        AggregateDamage wd = new AggregateDamage(this.groupName);
        for (WeaponShipDamage wtd : this._damages) {
            if (!validForCounting.contains(wtd.target.hullSize)) continue;
            wd.merge(wtd);
        }
        for (WeaponCountingDamage wfd : this._countingDamages) {
            wd.merge(wfd);
        }
        return wd;
    }

    public AggregateDamage aggregateShips() {
        return this.aggregateDamages(SHIPS);
    }

    public AggregateDamage aggregateFighters() {
        return this.aggregateDamages(FIGHTER);
    }

    public AggregateDamage aggregateMissiles() {
        return this.aggregateDamages(MISSILE);
    }

    @Override
    public Iterator<WeaponShipDamage> iterator() {
        return this._damages.iterator();
    }

    public String toString() {
        return "Size: " + this._damages.size() + "   Total: " + this.aggregateDamages(ALL).totalAllDamage();
    }
}

