/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.combatanalytics.function;

import com.fs.starfarer.api.combat.ShipAPI;
import data.scripts.combatanalytics.data.Ship;
import data.scripts.combatanalytics.data.WeaponShipDamage;
import data.scripts.combatanalytics.function.AggregateDamage;
import data.scripts.combatanalytics.function.DamageSet;
import java.util.HashMap;
import java.util.Map;

public class GroupedByShipDamage
implements Comparable<GroupedByShipDamage> {
    public final String id;
    public final String name;
    public final Ship ship;
    public Map<String, DamageSet> weaponNameToDamage = new HashMap<String, DamageSet>();
    public DamageSet allDamages = new DamageSet("All Damages");
    public AggregateDamage receivedSummary = new AggregateDamage("ReceivedSummary");

    public GroupedByShipDamage(Ship ship) {
        this.ship = ship;
        this.id = ship.id;
        this.name = GroupedByShipDamage.printShip(ship);
    }

    public void addReceivedDamage(Ship ship, WeaponShipDamage wtd) {
        this.receivedSummary.merge(wtd);
    }

    public void addDeliveredDamage(Ship ship, WeaponShipDamage wsd) {
        this.allDamages.merge(wsd);
    }

    public String toString() {
        return this.ship.toString();
    }

    @Override
    public int compareTo(GroupedByShipDamage o) {
        int ret = Double.compare(o.allDamages.aggregateShips().totalRealDamage(), this.allDamages.aggregateShips().totalRealDamage());
        if (ret == 0) {
            ret = this.name.compareTo(o.name);
        }
        return ret;
    }

    private static String printShip(Ship s) {
        if (s.hullSize == ShipAPI.HullSize.FIGHTER) {
            return s.name;
        }
        return s.name + " - " + s.hullClass + " (" + s.getHullSizeString() + ")";
    }
}

