/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.combatanalytics.override;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.ArmorGridAPI;
import com.fs.starfarer.api.combat.BaseCombatLayeredRenderingPlugin;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEngineLayers;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.CombatLayeredRenderingPlugin;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.OnHitEffectPlugin;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.api.combat.listeners.ApplyDamageResultAPI;
import com.fs.starfarer.api.graphics.SpriteAPI;
import com.fs.starfarer.api.util.FaderUtil;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import data.scripts.DamageReportManagerV1;
import java.awt.Color;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.lwjgl.opengl.GL14;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class DCRDisintegratorEffect
extends BaseCombatLayeredRenderingPlugin
implements OnHitEffectPlugin {
    public static int NUM_TICKS = 22;
    public static float TOTAL_DAMAGE = 500.0f;
    protected List<ParticleData> particles = new ArrayList<ParticleData>();
    protected DamagingProjectileAPI proj;
    protected ShipAPI target;
    protected Vector2f offset;
    protected int ticks = 0;
    protected IntervalUtil interval;
    protected FaderUtil fader = new FaderUtil(1.0f, 0.5f, 0.5f);
    protected EnumSet<CombatEngineLayers> layers = EnumSet.of(CombatEngineLayers.BELOW_INDICATORS_LAYER);

    public DCRDisintegratorEffect() {
    }

    public void onHit(DamagingProjectileAPI projectile, CombatEntityAPI target, Vector2f point, boolean shieldHit, ApplyDamageResultAPI damageResult, CombatEngineAPI engine) {
        if (shieldHit) {
            return;
        }
        if (projectile.isFading()) {
            return;
        }
        if (!(target instanceof ShipAPI)) {
            return;
        }
        Vector2f offset = Vector2f.sub((Vector2f)point, (Vector2f)target.getLocation(), (Vector2f)new Vector2f());
        offset = Misc.rotateAroundOrigin((Vector2f)offset, (float)(-target.getFacing()));
        DCRDisintegratorEffect effect = new DCRDisintegratorEffect(projectile, (ShipAPI)target, offset);
        CombatEntityAPI e = engine.addLayeredRenderingPlugin((CombatLayeredRenderingPlugin)effect);
        e.getLocation().set((ReadableVector2f)projectile.getLocation());
    }

    public DCRDisintegratorEffect(DamagingProjectileAPI proj, ShipAPI target, Vector2f offset) {
        this.proj = proj;
        this.target = target;
        this.offset = offset;
        this.interval = new IntervalUtil(0.8f, 1.0f);
        this.interval.forceIntervalElapsed();
    }

    public float getRenderRadius() {
        return 500.0f;
    }

    public EnumSet<CombatEngineLayers> getActiveLayers() {
        return this.layers;
    }

    public void init(CombatEntityAPI entity) {
        super.init(entity);
    }

    public void advance(float amount) {
        if (Global.getCombatEngine().isPaused()) {
            return;
        }
        Vector2f loc = new Vector2f((ReadableVector2f)this.offset);
        loc = Misc.rotateAroundOrigin((Vector2f)loc, (float)this.target.getFacing());
        Vector2f.add((Vector2f)this.target.getLocation(), (Vector2f)loc, (Vector2f)loc);
        this.entity.getLocation().set((ReadableVector2f)loc);
        ArrayList<ParticleData> remove = new ArrayList<ParticleData>();
        for (ParticleData p : this.particles) {
            p.advance(amount);
            if (!(p.elapsed >= p.maxDur)) continue;
            remove.add(p);
        }
        this.particles.removeAll(remove);
        float volume = 1.0f;
        if (this.ticks >= NUM_TICKS || !this.target.isAlive() || !Global.getCombatEngine().isEntityInPlay((CombatEntityAPI)this.target)) {
            this.fader.fadeOut();
            this.fader.advance(amount);
            volume = this.fader.getBrightness();
        }
        Global.getSoundPlayer().playLoop("disintegrator_loop", (Object)this.target, 1.0f, volume, loc, this.target.getVelocity());
        this.interval.advance(amount);
        if (this.interval.intervalElapsed() && this.ticks < NUM_TICKS) {
            this.dealDamage();
            ++this.ticks;
        }
    }

    protected void dealDamage() {
        CombatEngineAPI engine = Global.getCombatEngine();
        int num = 3;
        for (int i = 0; i < num; ++i) {
            ParticleData p = new ParticleData(30.0f, 3.0f + (float)Math.random() * 2.0f, 2.0f);
            this.particles.add(p);
            p.offset = Misc.getPointWithinRadius((Vector2f)p.offset, (float)20.0f);
        }
        Vector2f point = new Vector2f((ReadableVector2f)this.entity.getLocation());
        ArmorGridAPI grid = this.target.getArmorGrid();
        int[] cell = grid.getCellAtLocation(point);
        if (cell == null) {
            return;
        }
        int gridWidth = grid.getGrid().length;
        int gridHeight = grid.getGrid()[0].length;
        float damageTypeMult = DCRDisintegratorEffect.getDamageTypeMult(this.proj.getSource(), this.target);
        float damagePerTick = TOTAL_DAMAGE / (float)NUM_TICKS;
        float damageDealt = 0.0f;
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                if (!(i != 2 && i != -2 || j != 2 && j != -2)) continue;
                int cx = cell[0] + i;
                int cy = cell[1] + j;
                if (cx < 0 || cx >= gridWidth || cy < 0 || cy >= gridHeight) continue;
                float damMult = 0.033333335f;
                damMult = i == 0 && j == 0 ? 0.06666667f : (i <= 1 && i >= -1 && j <= 1 && j >= -1 ? 0.06666667f : 0.033333335f);
                float armorInCell = grid.getArmorValue(cx, cy);
                float damage = damagePerTick * damMult * damageTypeMult;
                if ((damage = Math.min(damage, armorInCell)) <= 0.0f) continue;
                this.target.getArmorGrid().setArmorValue(cx, cy, Math.max(0.0f, armorInCell - damage));
                damageDealt += damage;
            }
        }
        if (damageDealt > 0.0f) {
            if (Misc.shouldShowDamageFloaty((ShipAPI)this.proj.getSource(), (ShipAPI)this.target)) {
                engine.addFloatingDamageText(point, damageDealt, Misc.FLOATY_ARMOR_DAMAGE_COLOR, (CombatEntityAPI)this.target, (CombatEntityAPI)this.proj.getSource());
            }
            this.target.syncWithArmorGridState();
            DamageReportManagerV1.addDamageReport(damageDealt, 0.0f, 0.0f, 0.0f, this.proj);
        }
    }

    public boolean isExpired() {
        return this.particles.isEmpty() && (this.ticks >= NUM_TICKS || !this.target.isAlive() || !Global.getCombatEngine().isEntityInPlay((CombatEntityAPI)this.target));
    }

    public void render(CombatEngineLayers layer, ViewportAPI viewport) {
        float x = this.entity.getLocation().x;
        float y = this.entity.getLocation().y;
        Color color = new Color(100, 150, 255, 35);
        float b = viewport.getAlphaMult();
        GL14.glBlendEquation((int)32779);
        for (ParticleData p : this.particles) {
            float size = p.baseSize * p.scale;
            Vector2f loc = new Vector2f(x + p.offset.x, y + p.offset.y);
            float alphaMult = 1.0f;
            p.sprite.setAngle(p.angle);
            p.sprite.setSize(size, size);
            p.sprite.setAlphaMult(b * alphaMult * p.fader.getBrightness());
            p.sprite.setColor(color);
            p.sprite.renderAtCenter(loc.x, loc.y);
        }
        GL14.glBlendEquation((int)32774);
    }

    public static float getDamageTypeMult(ShipAPI source, ShipAPI target) {
        if (source == null || target == null) {
            return 1.0f;
        }
        float damageTypeMult = target.getMutableStats().getArmorDamageTakenMult().getModifiedValue();
        switch (target.getHullSize()) {
            case CAPITAL_SHIP: {
                damageTypeMult *= source.getMutableStats().getDamageToCapital().getModifiedValue();
                break;
            }
            case CRUISER: {
                damageTypeMult *= source.getMutableStats().getDamageToCruisers().getModifiedValue();
                break;
            }
            case DESTROYER: {
                damageTypeMult *= source.getMutableStats().getDamageToDestroyers().getModifiedValue();
                break;
            }
            case FRIGATE: {
                damageTypeMult *= source.getMutableStats().getDamageToFrigates().getModifiedValue();
                break;
            }
            case FIGHTER: {
                damageTypeMult *= source.getMutableStats().getDamageToFighters().getModifiedValue();
            }
        }
        return damageTypeMult;
    }

    public static class ParticleData {
        public SpriteAPI sprite;
        public Vector2f offset = new Vector2f();
        public Vector2f vel = new Vector2f();
        public float scale = 1.0f;
        public float scaleIncreaseRate = 1.0f;
        public float turnDir = 1.0f;
        public float angle = 1.0f;
        public float maxDur;
        public FaderUtil fader;
        public float elapsed = 0.0f;
        public float baseSize;

        public ParticleData(float baseSize, float maxDur, float endSizeMult) {
            this.sprite = Global.getSettings().getSprite("misc", "nebula_particles");
            float i = Misc.random.nextInt(4);
            float j = Misc.random.nextInt(4);
            this.sprite.setTexWidth(0.25f);
            this.sprite.setTexHeight(0.25f);
            this.sprite.setTexX(i * 0.25f);
            this.sprite.setTexY(j * 0.25f);
            this.sprite.setAdditiveBlend();
            this.angle = (float)Math.random() * 360.0f;
            this.maxDur = maxDur;
            this.scaleIncreaseRate = endSizeMult / maxDur;
            if (endSizeMult < 1.0f) {
                this.scaleIncreaseRate = -1.0f * endSizeMult;
            }
            this.scale = 1.0f;
            this.baseSize = baseSize;
            this.turnDir = Math.signum((float)Math.random() - 0.5f) * 20.0f * (float)Math.random();
            float driftDir = (float)Math.random() * 360.0f;
            this.vel = Misc.getUnitVectorAtDegreeAngle((float)driftDir);
            this.vel.scale(0.25f * baseSize / maxDur * (1.0f + (float)Math.random() * 1.0f));
            this.fader = new FaderUtil(0.0f, 0.5f, 0.5f);
            this.fader.forceOut();
            this.fader.fadeIn();
        }

        public void advance(float amount) {
            this.scale += this.scaleIncreaseRate * amount;
            this.offset.x += this.vel.x * amount;
            this.offset.y += this.vel.y * amount;
            this.angle += this.turnDir * amount;
            this.elapsed += amount;
            if (this.maxDur - this.elapsed <= this.fader.getDurationOut() + 0.1f) {
                this.fader.fadeOut();
            }
            this.fader.advance(amount);
        }
    }
}

