/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.combatanalytics.util;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import data.scripts.combatanalytics.ConsoleCampaignListener;
import java.awt.Color;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.apache.log4j.Logger;

public class Helpers {
    private static final Logger log = Global.getLogger(Helpers.class);
    public static final String NO_WEAPON = "Unknown";
    public static final NumberFormat INT_FORMAT = NumberFormat.getInstance();
    public static final NumberFormat TWO_DIGIT_NO_GROUP_FORMAT = NumberFormat.getInstance();
    public static final NumberFormat INT_FORMAT_NO_GROUP_FORMAT = NumberFormat.getInstance();
    public static final SimpleDateFormat ISO_DATE_TIME = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static final float DAMAGE_MAX_PCT_DELTA_FOR_EQUALITY = 0.4f;
    public static final float DAMAGE_MAX_PCT_DELTA_FOR_EQUALITY_WITH_ARMOR = 0.55f;

    public static float parseFloat(String s) {
        char c;
        if (s.length() == 1 && !Character.isDigit(c = s.charAt(0))) {
            s = "0";
        }
        return Float.parseFloat(s);
    }

    public static String ownerAsString(int owner) {
        switch (owner) {
            case 0: {
                return "Player";
            }
            case 1: {
                return "Computer";
            }
        }
        return "Unknown Owner Value: " + owner;
    }

    public static String toTsv(Object ... objs) {
        StringBuilder sb = new StringBuilder(100);
        for (int i = 0; i < objs.length; ++i) {
            Object o = objs[i];
            if (o == null) {
                throw new NullPointerException("Cannot serialize NULL value at index " + i);
            }
            String val = o instanceof Float ? o.toString() : o.toString();
            val = Helpers.cleanTsvValue(val);
            sb.append(val);
            sb.append('\t');
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    public static String[] tokenizeTsv(String line) {
        String[] ret = line.split("\t", -1);
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = ret[i].trim();
        }
        return ret;
    }

    public static String cleanTsvValue(String cell) {
        return cell.replace('\t', ' ').replace('\n', ' ').replace('\r', ' ');
    }

    public static String encodeArrayBlock(List<String> array) {
        StringBuilder sb = new StringBuilder(5000);
        sb.append('[');
        for (int i = 0; i < array.size(); ++i) {
            sb.append(array.get(i));
            if (i + 1 >= array.size()) continue;
            sb.append(',');
        }
        sb.append(']');
        return sb.toString();
    }

    public static String[] parseArrayBlock(String arr) {
        if (arr.startsWith("[")) {
            arr = arr.substring(1);
        }
        if (arr.endsWith("]")) {
            arr = arr.substring(0, arr.length() - 1);
        }
        if ((arr = arr.trim()).length() == 0) {
            return new String[0];
        }
        if (arr.indexOf(44) == -1) {
            return new String[]{arr};
        }
        String[] ret = arr.split(",", -1);
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = ret[i].trim();
        }
        return ret;
    }

    @SafeVarargs
    public static <T> T coalesce(T ... values) {
        for (T value : values) {
            if (value == null) continue;
            return value;
        }
        return null;
    }

    private static String UUIDTimeLow(String uuid) {
        int dashIndex = uuid.indexOf(45);
        if (dashIndex > -1) {
            return uuid.substring(0, dashIndex);
        }
        return uuid;
    }

    public static String getSmallUuid() {
        return Helpers.UUIDTimeLow(UUID.randomUUID().toString());
    }

    public static void printErrorMessage(String message) {
        ConsoleCampaignListener.enqueueForLogging("Detailed Combat Results: " + message + "  See log for details.", Color.RED);
    }

    @SafeVarargs
    public static <E> List<E> concat(Collection<E> ... listsOfThings) {
        ArrayList<E> ret = new ArrayList<E>();
        for (Collection<E> things : listsOfThings) {
            if (things == null) continue;
            ret.addAll(things);
        }
        return ret;
    }

    public static float computePctDeltaForDamage(float a, float b) {
        if (a < 0.5f && b < 0.5f) {
            return 0.0f;
        }
        float delta = Math.abs(a - b);
        if (delta < 3.0f) {
            return 0.0f;
        }
        return delta / (a + b);
    }

    public static float getSourceDamageScalar(ShipAPI source, ShipAPI target, DamageType dt, boolean isBeam) {
        float ret = 1.0f;
        MutableShipStatsAPI stats = source.getMutableStats();
        switch (target.getHullSize()) {
            case DEFAULT: {
                break;
            }
            case FIGHTER: {
                ret *= stats.getDamageToFighters().getModifiedValue();
                break;
            }
            case FRIGATE: {
                ret *= stats.getDamageToFrigates().getModifiedValue();
                break;
            }
            case DESTROYER: {
                ret *= stats.getDamageToDestroyers().getModifiedValue();
                break;
            }
            case CRUISER: {
                ret *= stats.getDamageToCruisers().getModifiedValue();
                break;
            }
            case CAPITAL_SHIP: {
                ret *= stats.getDamageToCapital().getModifiedValue();
            }
        }
        if (isBeam) {
            ret *= stats.getBeamWeaponDamageMult().getModifiedValue();
        }
        switch (dt) {
            case ENERGY: {
                ret *= stats.getEnergyWeaponDamageMult().getModifiedValue();
                break;
            }
        }
        return ret;
    }

    public static String formatAsPercent(double f) {
        return INT_FORMAT.format(f * 100.0) + "%";
    }

    public static String getUnknownWeaponName(DamageType dt) {
        return "Unknown " + dt.getDisplayName();
    }

    public static String getUnknownWeaponName(DamageType dt, String weaponType) {
        return Helpers.getUnknownWeaponName(dt) + " " + weaponType;
    }

    public static String getCollisionWeaponName(DamageType dt) {
        switch (dt) {
            case HIGH_EXPLOSIVE: 
            case KINETIC: 
            case FRAGMENTATION: {
                return "Collision - Hull";
            }
            case ENERGY: {
                return "Collision - Shield";
            }
        }
        return "Unknown Collision Type";
    }

    static {
        INT_FORMAT.setMaximumFractionDigits(0);
        TWO_DIGIT_NO_GROUP_FORMAT.setMaximumFractionDigits(2);
        TWO_DIGIT_NO_GROUP_FORMAT.setGroupingUsed(false);
        INT_FORMAT_NO_GROUP_FORMAT.setMaximumFractionDigits(0);
        INT_FORMAT_NO_GROUP_FORMAT.setGroupingUsed(false);
    }
}

