/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.combatanalytics.util;

import com.fs.starfarer.api.Global;
import data.scripts.combatanalytics.util.Helpers;
import java.util.Locale;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class Localization {
    private static final Logger log = Global.getLogger(Localization.class);
    private static final String DefaultStringsFile = "DetailedCombatResultsStrings_en.json";
    private static JSONObject LocalizationJson;
    private static String LoadedFrom;
    public static String LastFiveBattles;
    public static String LastTenBattles;
    public static String AllBattles;
    public static String ChooseData;
    public static String NoData;
    public static String AggregateFactionName;
    public static String SingleCombatInfo;
    public static String SimulatorInfo;
    public static String MultiIntelInfo;
    public static String SummaryDetailsHeading;
    public static String TotalDamage;
    public static String DisplayingTop;
    public static String PlayerResultsText;
    public static String CaptainedBy;
    public static String ShipName;
    public static String PilotName;
    public static String Class;
    public static String SoloKills;
    public static String KillAssists;
    public static String ProportionalDPDestroyed;
    public static String PctOfTotalDmg;
    public static String HullPct;
    public static String ShieldDmg;
    public static String ArmorDmg;
    public static String HullDmg;
    public static String EmpDmg;
    public static String TotalRowName;
    public static String WeaponName;
    public static String Total;
    public static String Shield;
    public static String Hull;
    public static String Armor;
    public static String Emp;
    public static String Hits;
    public static String PctDmg;
    public static String Fighter;
    public static String Missile;
    public static String KillType;
    public static String DP;
    public static String Solo;
    public static String Assist;
    public static String EnemyFleetStatusTitle;
    public static String AggregateFleetName;
    public static String EnemyResultsText;
    public static String Destroyed;
    public static String Disabled;
    public static String Retreated;
    public static String Reserved;
    public static String ReceivedSummary;
    public static String LegendName;
    public static String SoloDesc;
    public static String AssistDesc;
    public static String ProRataDpDesc;
    public static String DamageDesc;
    public static String StandardPerformance;
    public static String UnderPerformance;
    public static String OverPerformance;
    public static String WeaponCount;
    public static String WeaponOpTotal;
    public static String WeaponOpAsPct;
    public static String KillingBlows;
    public static String PlayerGoalPursuit;
    public static String PlayerGoalEscape;
    public static String PlayerGoalBattle;
    public static String EnemyGoalPursuit;
    public static String EnemyGoalEscape;
    public static String EnemyGoalBattle;
    public static String CombatReportName;
    public static String CombatReportTag;
    public static String SimulatorReportName;
    public static String SimulatorReportTag;

    public static JSONObject LoadJson(String fileName) {
        try {
            LoadedFrom = fileName;
            JSONObject settings = Global.getSettings().loadJSON(fileName);
            JSONObject settingsJson = settings.getJSONObject("DetailedCombatResults");
            if (settingsJson == null || settings.length() == 0) {
                throw new Exception("JSON localization file: '" + fileName + "' was found but was missing the 'combatAnalytics' section");
            }
            log.info((Object)("Using Detailed Combat Report localization file: '" + fileName + "'"));
            return settingsJson;
        }
        catch (Throwable t) {
            log.warn((Object)("Unable to locate & parse strings file named: '" + fileName + "' using default values from: 'DetailedCombatResultsStrings_en.json'"), t);
            fileName = DefaultStringsFile;
            try {
                LoadedFrom = fileName;
                JSONObject settings = Global.getSettings().loadJSON(fileName);
                return settings.getJSONObject("DetailedCombatResults");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static String getResourceString(String setting) {
        try {
            return LocalizationJson.getString(setting);
        }
        catch (Throwable e) {
            String message = "Unable to locate the setting '" + setting + "' in JSON: '" + LoadedFrom + "'";
            log.error((Object)message);
            Helpers.printErrorMessage(message);
            return message;
        }
    }

    static {
        try {
            String file = "DetailedCombatResultsStrings_" + Locale.getDefault().getLanguage() + ".json";
            LocalizationJson = Localization.LoadJson(file);
        }
        catch (Throwable t) {
            log.error((Object)"Fatal error attempting to set localization");
            Helpers.printErrorMessage("Fatal error attempting to set localization");
        }
        LastFiveBattles = Localization.getResourceString("LastFiveBattles");
        LastTenBattles = Localization.getResourceString("LastTenBattles");
        AllBattles = Localization.getResourceString("AllBattles");
        ChooseData = Localization.getResourceString("ChooseData");
        NoData = Localization.getResourceString("NoData");
        AggregateFactionName = Localization.getResourceString("AggregateFactionName");
        SingleCombatInfo = Localization.getResourceString("SingleCombatInfo");
        SimulatorInfo = Localization.getResourceString("SimulatorInfo");
        MultiIntelInfo = Localization.getResourceString("MultiIntelInfo");
        SummaryDetailsHeading = Localization.getResourceString("SummaryDetailsHeading");
        TotalDamage = Localization.getResourceString("TotalDamage");
        DisplayingTop = Localization.getResourceString("DisplayingTop");
        PlayerResultsText = Localization.getResourceString("PlayerResultsText");
        CaptainedBy = Localization.getResourceString("CaptainedBy");
        ShipName = Localization.getResourceString("ShipName");
        PilotName = Localization.getResourceString("PilotName");
        Class = Localization.getResourceString("Class");
        SoloKills = Localization.getResourceString("SoloKills");
        KillAssists = Localization.getResourceString("KillAssists");
        ProportionalDPDestroyed = Localization.getResourceString("ProportionalDPDestroyed");
        PctOfTotalDmg = Localization.getResourceString("PctOfTotalDmg");
        HullPct = Localization.getResourceString("HullPct");
        ShieldDmg = Localization.getResourceString("ShieldDmg");
        ArmorDmg = Localization.getResourceString("ArmorDmg");
        HullDmg = Localization.getResourceString("HullDmg");
        EmpDmg = Localization.getResourceString("EmpDmg");
        TotalRowName = Localization.getResourceString("TotalRowName");
        WeaponName = Localization.getResourceString("WeaponName");
        Total = Localization.getResourceString("Total");
        Shield = Localization.getResourceString("Shield");
        Hull = Localization.getResourceString("Hull");
        Armor = Localization.getResourceString("Armor");
        Emp = Localization.getResourceString("Emp");
        Hits = Localization.getResourceString("Hits");
        PctDmg = Localization.getResourceString("PctDmg");
        Fighter = Localization.getResourceString("Fighter");
        Missile = Localization.getResourceString("Missile");
        KillType = Localization.getResourceString("KillType");
        DP = Localization.getResourceString("DP");
        Solo = Localization.getResourceString("Solo");
        Assist = Localization.getResourceString("Assist");
        EnemyFleetStatusTitle = Localization.getResourceString("EnemyFleetStatusTitle");
        AggregateFleetName = Localization.getResourceString("AggregateFleetName");
        EnemyResultsText = Localization.getResourceString("EnemyResultsText");
        Destroyed = Localization.getResourceString("Destroyed");
        Disabled = Localization.getResourceString("Disabled");
        Retreated = Localization.getResourceString("Retreated");
        Reserved = Localization.getResourceString("Reserved");
        ReceivedSummary = Localization.getResourceString("ReceivedSummary");
        LegendName = Localization.getResourceString("LegendName");
        SoloDesc = Localization.getResourceString("SoloDesc");
        AssistDesc = Localization.getResourceString("AssistDesc");
        ProRataDpDesc = Localization.getResourceString("ProRataDpDesc");
        DamageDesc = Localization.getResourceString("DamageDesc");
        StandardPerformance = Localization.getResourceString("StandardPerformance");
        UnderPerformance = Localization.getResourceString("UnderPerformance");
        OverPerformance = Localization.getResourceString("OverPerformance");
        WeaponCount = Localization.getResourceString("WeaponCount");
        WeaponOpTotal = Localization.getResourceString("WeaponOpTotal");
        WeaponOpAsPct = Localization.getResourceString("WeaponOpAsPct");
        KillingBlows = Localization.getResourceString("KillingBlows");
        PlayerGoalPursuit = Localization.getResourceString("PlayerGoalPursuit");
        PlayerGoalEscape = Localization.getResourceString("PlayerGoalEscape");
        PlayerGoalBattle = Localization.getResourceString("PlayerGoalBattle");
        EnemyGoalPursuit = Localization.getResourceString("EnemyGoalPursuit");
        EnemyGoalEscape = Localization.getResourceString("EnemyGoalEscape");
        EnemyGoalBattle = Localization.getResourceString("EnemyGoalBattle");
        CombatReportName = Localization.getResourceString("CombatReportName");
        CombatReportTag = Localization.getResourceString("CombatReportTag");
        SimulatorReportName = Localization.getResourceString("SimulatorReportName");
        SimulatorReportTag = Localization.getResourceString("SimulatorReportTag");
    }
}

