/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.combatanalytics.util;

import com.fs.starfarer.api.Global;
import lunalib.lunaSettings.LunaSettings;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class Settings {
    private static final Logger log = Global.getLogger(Settings.class);
    private static final boolean LunaEnabled = Global.getSettings().getModManager().isModEnabled("lunalib");
    public static final String DetailedCombatResultsLoggingLevel = Settings.getStringSetting("dcr_LoggingLevel", Level.INFO.toString());

    public static boolean shouldUninstall() {
        return Settings.getBoolean("dcr_UninstallMode", false);
    }

    public static int getCombatAnalyzeKeyCode() {
        return Settings.getKeyCode("dcr_AnalyzeKey", 38);
    }

    public static boolean getFighterWeaponBreakout() {
        return Settings.getBoolean("dcr_FighterWeaponBreakout", false);
    }

    public static int getMaxCombatResultCount() {
        return Settings.getInteger("dcr_MaxCombatResultCount", 50);
    }

    public static int getCombatResultLifetimeInDays() {
        return Settings.getInteger("dcr_CombatResultLifetimeInDays", 750);
    }

    public static int getAggregateResultLifetimeInDays() {
        return Settings.getInteger("dcr_AggregateResultLifetimeInDays", 5);
    }

    public static int getSimulationResultLifetimeInDays() {
        return Settings.getInteger("dcr_SimulationResultLifetimeInDays", 1);
    }

    public static int getShipCountLimit() {
        return Settings.getInteger("dcr_ShipCountLimit", 15);
    }

    private static String getStringSetting(String setting, String defaultValue) {
        if (LunaEnabled) {
            String ret = LunaSettings.getString((String)"DetailedCombatResults", (String)setting);
            if (ret == null) {
                return defaultValue;
            }
            return ret;
        }
        return defaultValue;
    }

    public static int getKeyCode(String setting, int defaultValue) {
        int ret = Settings.getInteger(setting, defaultValue);
        if (ret == 0) {
            return defaultValue;
        }
        return ret;
    }

    public static int getInteger(String setting, int defaultValue) {
        if (LunaEnabled) {
            Integer ret = LunaSettings.getInt((String)"DetailedCombatResults", (String)setting);
            if (ret == null) {
                return defaultValue;
            }
            return ret;
        }
        return defaultValue;
    }

    private static boolean getBoolean(String setting, boolean defaultValue) {
        if (LunaEnabled) {
            Boolean ret = LunaSettings.getBoolean((String)"DetailedCombatResults", (String)setting);
            if (ret == null) {
                return defaultValue;
            }
            return ret;
        }
        return defaultValue;
    }

    public static boolean UseReportedDamagesOnly() {
        try {
            return Global.getSettings().getBoolean("DetailedCombatResults_UseReportedDamagesOnlyV1");
        }
        catch (Throwable t) {
            return false;
        }
    }
}

