/*
 * Decompiled with CFR 0.152.
 */
package data.hullmods.edshipyard;

import com.fs.starfarer.api.combat.BaseHullMod;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.combat.listeners.WeaponOPCostModifier;
import com.fs.starfarer.api.loading.WeaponSpecAPI;
import java.util.EnumSet;

public class PDOnlyWeapons
extends BaseHullMod {
    public static final float PD_RANGE_BONUS = 100.0f;
    public static final float TURN_BONUS = 35.0f;

    public void applyEffectsBeforeShipCreation(ShipAPI.HullSize hullSize, MutableShipStatsAPI stats, String id) {
        stats.getBeamPDWeaponRangeBonus().modifyFlat(id, 100.0f);
        stats.getBallisticWeaponRangeBonus().modifyFlat(id, 100.0f);
        stats.getMissileWeaponRangeBonus().modifyFlat(id, 100.0f);
        stats.getWeaponTurnRateBonus().modifyMult(id, 1.35f);
        stats.removeListenerOfClass(OnlyPDHullmodCostListener.class);
        stats.addListener((Object)new OnlyPDHullmodCostListener());
    }

    public String getDescriptionParam(int index, ShipAPI.HullSize hullSize) {
        if (index == 0) {
            return "100";
        }
        if (index == 1) {
            return "35%";
        }
        return null;
    }

    public boolean isApplicableToShip(ShipAPI ship) {
        return false;
    }

    public boolean affectsOPCosts() {
        return true;
    }

    public static class OnlyPDHullmodCostListener
    implements WeaponOPCostModifier {
        public int getWeaponOPCost(MutableShipStatsAPI stats, WeaponSpecAPI weapon, int currCost) {
            String role = weapon.getPrimaryRoleStr();
            if (role != null && role.length() > 0 && (role.contains("Point Defense") || role.contains("Anti Fighter") || role.contains("Anti Small Craft"))) {
                return currCost;
            }
            EnumSet hints = weapon.getAIHints();
            if (hints != null && hints.size() > 0 && (hints.contains(WeaponAPI.AIHints.PD) || hints.contains(WeaponAPI.AIHints.ANTI_FTR))) {
                return currCost;
            }
            return 99999;
        }
    }
}

