/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.edshipyard.campaign;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BaseCampaignEventListener;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CustomCampaignEntityAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.FleetAssignment;
import com.fs.starfarer.api.campaign.JumpPointAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.impl.campaign.DerelictShipEntityPlugin;
import com.fs.starfarer.api.impl.campaign.events.nearby.NearbyEventsEvent;
import com.fs.starfarer.api.impl.campaign.fleets.FleetFactoryV3;
import com.fs.starfarer.api.impl.campaign.fleets.FleetParamsV3;
import com.fs.starfarer.api.impl.campaign.intel.misc.DistressCallIntel;
import com.fs.starfarer.api.impl.campaign.procgen.themes.BaseAssignmentAI;
import com.fs.starfarer.api.impl.campaign.procgen.themes.BaseThemeGenerator;
import com.fs.starfarer.api.impl.campaign.procgen.themes.SalvageSpecialAssigner;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import data.scripts.edshipyard.util.Utils;
import org.apache.log4j.Logger;
import org.lazywizard.lazylib.MathUtils;
import org.lwjgl.util.vector.Vector2f;

public class EdDistressEncounter
extends BaseCampaignEventListener
implements EveryFrameScript {
    public static Logger log = Global.getLogger(EdDistressEncounter.class);
    private static final int REFIRE_DELAY_DAYS = 400;
    private static final int CHECK_FREQUENCY_DAYS = 30;
    private boolean TEST_MODE = false;
    private IntervalUtil fleetSpawnTracker;
    private IntervalUtil transportFleetSpawnTracker;
    private IntervalUtil distressCallInterval;
    private long lastExecutedOn = 0L;

    public EdDistressEncounter() {
        super(true);
        this.initTrackers();
    }

    private void initTrackers() {
        this.distressCallInterval = this.ensureCorrectValues(this.distressCallInterval, 30.0f, 45.0f);
    }

    private IntervalUtil ensureCorrectValues(IntervalUtil current, float min, float max) {
        if (current == null) {
            return new IntervalUtil(min, max);
        }
        if (MathUtils.equals((float)current.getMinInterval(), (float)min) && MathUtils.equals((float)current.getMaxInterval(), (float)max)) {
            return current;
        }
        float elapsed = current.getElapsed();
        current = new IntervalUtil(min, max);
        current.setElapsed(elapsed);
        return current;
    }

    public Object readResolve() {
        this.initTrackers();
        return this;
    }

    public boolean isDone() {
        return false;
    }

    public boolean runWhilePaused() {
        return false;
    }

    public void advance(float amount) {
        try {
            float days = Global.getSector().getClock().convertToDays(amount);
            this.distressCallInterval.advance(days);
            if (Global.getSector().getClock().getElapsedDaysSince(this.lastExecutedOn) < 400.0f) {
                return;
            }
            if (!this.isDistressAlreadyHappening() && (this.distressCallInterval.intervalElapsed() || this.TEST_MODE)) {
                this.maybeSpawnDistressCall();
            }
        }
        catch (Exception e) {
            log.error((Object)"error in EdDistressEncounter.advance", (Throwable)e);
        }
    }

    protected boolean isDistressAlreadyHappening() {
        return Global.getSector().getIntelManager().getFirstIntel(DistressCallIntel.class) != null;
    }

    protected void maybeSpawnDistressCall() {
        CampaignFleetAPI edFleet;
        FactionAPI faction;
        StarSystemAPI system2;
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        if (!playerFleet.isInHyperspace()) {
            return;
        }
        if (playerFleet.isInHyperspaceTransition()) {
            return;
        }
        WeightedRandomPicker systems = new WeightedRandomPicker();
        for (StarSystemAPI system2 : Misc.getNearbyStarSystems((SectorEntityToken)playerFleet, (float)Global.getSettings().getFloat("distressCallEventRangeLY"))) {
            float sincePlayerVisit;
            if (system2.hasPulsar() || system2.hasTag("system_cut_off_from_hyper") || system2.hasTag("theme_hidden") || system2.hasTag("theme_core") || (sincePlayerVisit = system2.getDaysSinceLastPlayerVisit()) < NearbyEventsEvent.DISTRESS_MIN_SINCE_PLAYER_IN_SYSTEM) continue;
            boolean validTheme = false;
            for (String tag : system2.getTags()) {
                if (!NearbyEventsEvent.distressCallAllowedThemes.contains(tag)) continue;
                validTheme = true;
                break;
            }
            if (!validTheme || !Misc.getMarketsInLocation((LocationAPI)system2).isEmpty()) continue;
            systems.add((Object)system2);
        }
        float p = (float)systems.getItems().size() * NearbyEventsEvent.DISTRESS_PROB_PER_SYSTEM;
        if (p > NearbyEventsEvent.DISTRESS_MAX_PROB) {
            p = NearbyEventsEvent.DISTRESS_MAX_PROB;
        }
        if ((float)Math.random() >= p && !this.TEST_MODE) {
            return;
        }
        system2 = (StarSystemAPI)systems.pick();
        if (system2 == null) {
            return;
        }
        JumpPointAPI jumpPoint = Misc.getDistressJumpPoint((StarSystemAPI)system2);
        if (jumpPoint == null) {
            return;
        }
        this.spawnDerelict(system2, (SectorEntityToken)jumpPoint);
        if (Math.random() > 0.5) {
            faction = Global.getSector().getFaction("ed_shipyard_faction");
            FleetParamsV3 fleetParams = new FleetParamsV3(Utils.getRandomFleetSource("independent"), null, faction.getId(), Float.valueOf(1.0f), "trade", 70.0f, 50.0f, 0.0f, 25.0f, 0.0f, 0.0f, 1.0f);
            fleetParams.withOfficers = true;
            edFleet = FleetFactoryV3.createFleet((FleetParamsV3)fleetParams);
            Utils.addShipToFleet(edFleet, "edshipyard_dalmatian_phase");
            Utils.addShipToFleet(edFleet, "edshipyard_newfoundland_warfreighter");
            Utils.addShipToFleet(edFleet, "edshipyard_bernard_variant");
            edFleet.getCargo().addCommodity("fuel", 1000.0f);
            edFleet.getCargo().addCommodity("supplies", 500.0f);
            edFleet.getCargo().addCommodity("volatiles", 100.0f);
            edFleet.getCargo().addCommodity("alpha_core", 1.0f);
            edFleet.setName("ED Long Range Mercantile");
        } else {
            faction = Global.getSector().getFaction("ed_shipyard_faction");
            FleetParamsV3 fleetParamsV3 = new FleetParamsV3(Utils.getRandomFleetSource("independent"), null, faction.getId(), Float.valueOf(3.0f), "patrolMedium", 210.0f, 15.0f, 0.0f, 0.0f, 0.0f, 20.0f, 3.0f);
            fleetParamsV3.withOfficers = true;
            edFleet = FleetFactoryV3.createFleet((FleetParamsV3)fleetParamsV3);
            Utils.addShipToFleet(edFleet, "edshipyard_dalmatian_phase");
            Utils.addShipToFleet(edFleet, "edshipyard_bernard_variant");
            edFleet.getCargo().addCommodity("hand_weapons", 100.0f);
            edFleet.getCargo().addCommodity("drugs", 100.0f);
            edFleet.getCargo().addCommodity("alpha_core", 1.0f);
            edFleet.setName("ED Long Range Patrol");
        }
        edFleet.clearAssignments();
        edFleet.setFaction("independent");
        edFleet.setTransponderOn(true);
        edFleet.removeAbility("emergency_burn");
        Misc.setFlagWithReason((MemoryAPI)edFleet.getMemoryWithoutUpdate(), (String)"$missionImportant", (String)"$edshipyard_distress", (boolean)true, (float)1000.0f);
        edFleet.getMemoryWithoutUpdate().set("$cfai_allowPlayerBattleJoinTOff", (Object)true);
        edFleet.getMemoryWithoutUpdate().set("$cfai_makeAggressive", (Object)true);
        edFleet.getMemoryWithoutUpdate().set("$cfai_makeAggressiveLastsOneBattle", (Object)true);
        edFleet.getMemoryWithoutUpdate().set("$edshipyard_distress", (Object)true);
        system2.addEntity((SectorEntityToken)edFleet);
        Vector2f loc = Misc.getPointAtRadius((Vector2f)jumpPoint.getLocation(), (float)(400.0f + (float)Math.random() * 200.0f));
        edFleet.setLocation(loc.x, loc.y);
        edFleet.addScript((EveryFrameScript)new EdDistressCallAI(edFleet, system2, (SectorEntityToken)jumpPoint));
        Global.getSector().getMemoryWithoutUpdate().set("$edshipyard_distress_ed_fleet", (Object)edFleet, 60.0f);
        Global.getSector().getMemoryWithoutUpdate().set("$edshipyard_distress_system", (Object)system2, 60.0f);
        Global.getSector().getMemoryWithoutUpdate().set("$edshipyard_distress_jumppoint", (Object)jumpPoint, 60.0f);
        DistressCallIntel intel = new DistressCallIntel(system2);
        Global.getSector().getIntelManager().addIntel((IntelInfoPlugin)intel);
        this.lastExecutedOn = Global.getSector().getClock().getTimestamp();
    }

    private CustomCampaignEntityAPI spawnDerelict(StarSystemAPI system, SectorEntityToken jumpPoint) {
        WeightedRandomPicker factions = SalvageSpecialAssigner.getNearbyFactions(null, (Vector2f)system.getLocation(), (float)100.0f, (float)0.0f, (float)0.0f);
        DerelictShipEntityPlugin.DerelictShipData params = DerelictShipEntityPlugin.createRandom((String)((String)factions.pick()), (DerelictShipEntityPlugin.DerelictType)DerelictShipEntityPlugin.DerelictType.LARGE, null, (float)0.5f);
        if (params == null) {
            return null;
        }
        params.canHaveExtraCargo = true;
        params.durationDays = 180.0f;
        CustomCampaignEntityAPI derelict = (CustomCampaignEntityAPI)BaseThemeGenerator.addSalvageEntity((LocationAPI)system, (String)"wreck", (String)"neutral", (Object)params);
        derelict.addTag("expires");
        float radius = 300.0f + 200.0f * (float)Math.random();
        float maxRadius = Math.max(250.0f, jumpPoint.getCircularOrbitRadius() * 0.33f);
        if (radius > maxRadius) {
            radius = maxRadius;
        }
        float orbitDays = radius / (5.0f + Misc.random.nextFloat() * 20.0f);
        float angle = (float)Math.random() * 360.0f;
        derelict.setCircularOrbit(jumpPoint, angle, radius, orbitDays);
        return derelict;
    }

    public class EdDistressCallAI
    extends BaseAssignmentAI {
        protected StarSystemAPI system;
        protected SectorEntityToken jumpPoint;
        protected float elapsed = 0.0f;
        protected float despawnAfterDays = 40.0f + (float)Math.random() * 20.0f;
        protected boolean hasSeenPlayer = false;

        public EdDistressCallAI(CampaignFleetAPI fleet, StarSystemAPI system, SectorEntityToken jumpPoint) {
            this.fleet = fleet;
            this.system = system;
            this.jumpPoint = jumpPoint;
            this.giveInitialAssignments();
        }

        protected void giveInitialAssignments() {
            this.fleet.addAssignment(FleetAssignment.ORBIT_AGGRESSIVE, this.jumpPoint, 30.0f);
        }

        protected void pickNext() {
            this.fleet.addAssignment(FleetAssignment.ORBIT_AGGRESSIVE, this.jumpPoint, 30.0f);
        }

        public void advance(float amount) {
            SectorEntityToken.VisibilityLevel level;
            super.advance(amount);
            if (!this.fleet.getMemoryWithoutUpdate().contains("$edshipyard_distress")) {
                Misc.giveStandardReturnToSourceAssignments((CampaignFleetAPI)this.fleet);
                this.fleet.removeScript((EveryFrameScript)this);
                return;
            }
            float days = Global.getSector().getClock().convertToDays(amount);
            this.elapsed += days;
            if (this.fleet.isInCurrentLocation() && !this.hasSeenPlayer && (level = this.fleet.getVisibilityLevelOfPlayerFleet()) != SectorEntityToken.VisibilityLevel.NONE && level != SectorEntityToken.VisibilityLevel.SENSOR_CONTACT) {
                this.hasSeenPlayer = true;
                this.fleet.clearAssignments();
                this.fleet.addAssignment(FleetAssignment.INTERCEPT, (SectorEntityToken)Global.getSector().getPlayerFleet(), 30.0f, "approaching your fleet");
            }
            if (this.elapsed >= this.despawnAfterDays && !this.fleet.isInCurrentLocation()) {
                this.fleet.removeScript((EveryFrameScript)this);
                this.fleet.despawn();
            }
        }
    }
}

