/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.edshipyard.campaign;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.Script;
import com.fs.starfarer.api.campaign.BaseCampaignEventListener;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.FleetAssignment;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.SubmarketAPI;
import com.fs.starfarer.api.impl.campaign.fleets.FleetFactoryV3;
import com.fs.starfarer.api.impl.campaign.fleets.FleetParamsV3;
import com.fs.starfarer.api.util.IntervalUtil;
import data.scripts.edshipyard.util.Settings;
import data.scripts.edshipyard.util.Utils;
import java.util.ArrayList;
import java.util.Random;
import org.apache.log4j.Logger;
import org.lazywizard.lazylib.MathUtils;
import org.lwjgl.util.vector.Vector2f;

public class EdFleetManager
extends BaseCampaignEventListener
implements EveryFrameScript {
    public static Logger log = Global.getLogger(EdFleetManager.class);
    private static final int NEW_COMBAT_FLEET_INTERVAL_IN_DAYS = 90;
    private static final int NEW_TRANSPORT_FLEET_INTERVAL_IN_DAYS = 75;
    private IntervalUtil fleetSpawnTracker;
    private IntervalUtil transportFleetSpawnTracker;

    public EdFleetManager() {
        super(true);
        this.initTrackers();
    }

    private void initTrackers() {
        this.fleetSpawnTracker = this.ensureCorrectValues(this.fleetSpawnTracker, 76.5f, 99.0f);
        this.transportFleetSpawnTracker = this.ensureCorrectValues(this.transportFleetSpawnTracker, 63.75f, 82.5f);
    }

    private IntervalUtil ensureCorrectValues(IntervalUtil current, float min, float max) {
        if (current == null) {
            return new IntervalUtil(min, max);
        }
        if (MathUtils.equals((float)current.getMinInterval(), (float)min) && MathUtils.equals((float)current.getMaxInterval(), (float)max)) {
            return current;
        }
        float elapsed = current.getElapsed();
        current = new IntervalUtil(min, max);
        current.setElapsed(elapsed);
        return current;
    }

    public Object readResolve() {
        this.initTrackers();
        return this;
    }

    public boolean isDone() {
        return false;
    }

    public boolean runWhilePaused() {
        return false;
    }

    public void advance(float amount) {
        try {
            float days = Global.getSector().getClock().convertToDays(amount);
            this.fleetSpawnTracker.advance(days);
            this.transportFleetSpawnTracker.advance(days);
            if (this.fleetSpawnTracker.intervalElapsed()) {
                this.spawnDefensiveFleets();
            }
            if (this.transportFleetSpawnTracker.intervalElapsed()) {
                this.spawnTransportFleets();
            }
        }
        catch (Exception e) {
            log.error((Object)"error creating ED fleets", (Throwable)e);
        }
    }

    private void spawnDefensiveFleets() {
        if (!Settings.allowEdSubmarketDefenseFleets()) {
            return;
        }
        for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
            if (!this.hasActiveEdSubmarket(market)) continue;
            int hostileFleetPointsInSystem = this.getHostileFleetPointsInSystem(market.getPrimaryEntity().getStarSystem());
            this.spawnCombatFleet(20, "ED Force Recon", market, "edshipyard_bischon_assault", "edshipyard_shiba_beamer", "edshipyard_chin_smuggler", "edshipyard_basenji_explorer", "edshipyard_bernese_tug");
            if (hostileFleetPointsInSystem > 60) {
                this.spawnCombatFleet(80, "ED Anti-Piracy Patrol", market, "edshipyard_dalmatian_phase", "edshipyard_bernese_tug");
            }
            if (hostileFleetPointsInSystem > 450) {
                this.spawnCombatFleet(250, "ED System Defense Fleet", market, "edshipyard_newfoundland_warfreighter", "edshipyard_dalmatian_phase", "edshipyard_bernard_variant");
            }
            if (hostileFleetPointsInSystem <= 750) continue;
            this.spawnCombatFleet(350, "ED Defense Armada", market, "edshipyard_newfoundland_warfreighter", "edshipyard_dalmatian_phase", "edshipyard_dalmatian_phase", "edshipyard_bernard_variant", "edshipyard_bernard_variant");
        }
    }

    private boolean hasActiveEdSubmarket(MarketAPI market) {
        if (!Utils.isIndependentOwned(market) && !Utils.isPlayerOwned(market)) {
            return false;
        }
        if (Utils.isPlayerOwned(market) && !Utils.playerHasAtLeastStandingWith(RepLevel.FAVORABLE, "independent")) {
            return false;
        }
        for (SubmarketAPI sub : market.getSubmarketsCopy()) {
            if (!sub.getSpecId().equalsIgnoreCase("ed_shipyard")) continue;
            return true;
        }
        return false;
    }

    private void spawnTransportFleets() {
        if (!Settings.allowEdSubmarketTransportFleets()) {
            return;
        }
        ArrayList<MarketAPI> independentMarkets = new ArrayList<MarketAPI>();
        ArrayList<MarketAPI> edMarkets = new ArrayList<MarketAPI>();
        for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
            if (Utils.isIndependentOwned(market) || Utils.isPlayerOwned(market)) {
                independentMarkets.add(market);
            }
            if (!this.hasActiveEdSubmarket(market)) continue;
            edMarkets.add(market);
        }
        independentMarkets.removeAll(edMarkets);
        for (MarketAPI edMarket : edMarkets) {
            Random rand = new Random();
            int numberOfTradeFleetsToSend = Settings.getNumberOfTradeFleetsToSendPerEdSubmarket();
            for (int i = 0; i < numberOfTradeFleetsToSend; ++i) {
                MarketAPI sourceMarket = (MarketAPI)independentMarkets.get(rand.nextInt(independentMarkets.size()));
                if (sourceMarket.getPrimaryEntity().getId().equals(edMarket.getPrimaryEntity().getId())) continue;
                this.spawnTradeFleet(sourceMarket, edMarket);
            }
        }
    }

    public void spawnCombatFleet(int totalFP, String fleetName, MarketAPI market, String ... additionalShipVariants) {
        try {
            SectorEntityToken location = market.getPrimaryEntity();
            FactionAPI faction = Global.getSector().getFaction("ed_shipyard_faction");
            FleetParamsV3 fleetParamsV3 = new FleetParamsV3(null, faction.getId(), Float.valueOf(3.0f), fleetName, (float)totalFP, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 3.0f);
            fleetParamsV3.source = market;
            fleetParamsV3.withOfficers = false;
            CampaignFleetAPI fleet = FleetFactoryV3.createFleet((FleetParamsV3)fleetParamsV3);
            for (String shipVariant : additionalShipVariants) {
                Utils.addShipToFleet(fleet, shipVariant);
            }
            FleetFactoryV3.addCommanderAndOfficersV2((CampaignFleetAPI)fleet, (FleetParamsV3)fleetParamsV3, (Random)new Random());
            fleet.setName(fleetName);
            fleet.setFaction("independent");
            fleet.addAssignment(FleetAssignment.ORBIT_AGGRESSIVE, location, 1.0f + 3.0f * (float)Math.random(), "preparing for patrol");
            fleet.addAssignment(FleetAssignment.PATROL_SYSTEM, null, 63.0f, "patrolling");
            fleet.addAssignment(FleetAssignment.GO_TO_LOCATION, location, 3.0f, "returning from patrol");
            fleet.addAssignment(FleetAssignment.ORBIT_PASSIVE, location, 3.0f + (float)Math.random() * 2.0f, "standing down");
            fleet.addAssignment(FleetAssignment.GO_TO_LOCATION_AND_DESPAWN, location, 5.0f);
            Vector2f offset = MathUtils.getRandomPointOnCircumference(null, (float)(location.getRadius() + fleet.getRadius() + 150.0f));
            location.getContainingLocation().spawnFleet(location, offset.x, offset.y, fleet);
            fleet.setTransponderOn(true);
            log.info((Object)("Spawned a " + totalFP + "FP " + faction.getFleetTypeName(fleetName) + " combat fleet in system: " + location.getFullName() + "   " + fleet.getFleetData().getCombatReadyMembersListCopy().size() + " ships aligned with faction " + faction.getId()));
        }
        catch (Exception ex) {
            log.error((Object)"Unable to spawn generic patrol fleet for faction 'ed_shipyard'!", (Throwable)ex);
        }
    }

    private int getHostileFleetPointsInSystem(StarSystemAPI system) {
        FactionAPI ed = Global.getSector().getFaction("ed_shipyard_faction");
        FactionAPI independent = Global.getSector().getFaction("independent");
        int fleetPoints = 0;
        for (CampaignFleetAPI x : system.getFleets()) {
            if (x.getFaction() == ed || x.getFaction() == independent || !((double)independent.getRelationship(x.getFaction().getId()) < -0.25) || x.isStationMode() || x.getFleetPoints() <= 40) continue;
            fleetPoints += x.getFleetPoints();
        }
        return fleetPoints;
    }

    private void spawnTradeFleet(MarketAPI sourceMarket, MarketAPI destMarket) {
        int size = sourceMarket.getSize();
        float combat = size * 4;
        float freighter = (float)size * 4.0f;
        float transport = (float)size * 2.0f;
        FactionAPI faction = Global.getSector().getFaction("ed_shipyard_faction");
        FleetParamsV3 fleetParams = new FleetParamsV3(sourceMarket, null, faction.getId(), Float.valueOf(1.0f), "trade", combat, freighter, 0.0f, transport, 0.0f, 0.0f, 1.0f);
        fleetParams.source = sourceMarket;
        fleetParams.withOfficers = false;
        final CampaignFleetAPI fleet = FleetFactoryV3.createFleet((FleetParamsV3)fleetParams);
        Utils.addShipToFleet(fleet, "edshipyard_dalmatian_phase");
        Utils.addShipToFleet(fleet, "edshipyard_bernard_variant");
        Utils.addShipToFleet(fleet, "edshipyard_newfoundland_warfreighter");
        FleetFactoryV3.addCommanderAndOfficersV2((CampaignFleetAPI)fleet, (FleetParamsV3)fleetParams, (Random)new Random());
        SectorEntityToken entity = sourceMarket.getPrimaryEntity();
        sourceMarket.getPrimaryEntity().getContainingLocation().addEntity((SectorEntityToken)fleet);
        fleet.setLocation(entity.getLocation().x, entity.getLocation().y);
        fleet.setFaction("independent");
        fleet.setName("ED Industrial Supply Fleet");
        fleet.setTransponderOn(true);
        fleet.addAssignment(FleetAssignment.ORBIT_PASSIVE, sourceMarket.getPrimaryEntity(), (float)(2.0 + 6.0 * Math.random()), "loading trade goods from " + sourceMarket.getName(), new Script(){

            public void run() {
                Random r = new Random();
                fleet.getCargo().addItems(CargoAPI.CargoItemType.RESOURCES, (Object)"gamma_core", 3.0f);
                fleet.getCargo().addItems(CargoAPI.CargoItemType.RESOURCES, (Object)"beta_core", 2.0f);
                if (r.nextFloat() < 0.5f) {
                    fleet.getCargo().addItems(CargoAPI.CargoItemType.RESOURCES, (Object)"alpha_core", 1.0f);
                }
                fleet.getCargo().addItems(CargoAPI.CargoItemType.RESOURCES, (Object)"heavy_machinery", 1000.0f * r.nextFloat() + 50.0f);
                fleet.getCargo().addItems(CargoAPI.CargoItemType.RESOURCES, (Object)"rare_metals", 1000.0f * r.nextFloat() + 50.0f);
                fleet.getCargo().addItems(CargoAPI.CargoItemType.RESOURCES, (Object)"metals", 2000.0f * r.nextFloat() + 120.0f);
                fleet.getCargo().addItems(CargoAPI.CargoItemType.RESOURCES, (Object)"volatiles", 500.0f * r.nextFloat() + 20.0f);
                fleet.getCargo().addItems(CargoAPI.CargoItemType.RESOURCES, (Object)"organics", 3000.0f * r.nextFloat() + 120.0f);
            }
        });
        fleet.addAssignment(FleetAssignment.DELIVER_RESOURCES, destMarket.getPrimaryEntity(), 1000.0f, "delivering manufacturing goods from " + sourceMarket.getName() + " to " + destMarket.getName());
        fleet.addAssignment(FleetAssignment.ORBIT_PASSIVE, destMarket.getPrimaryEntity(), (float)(2.0 + 4.0 * Math.random()), "offloading manufacturing goods at " + destMarket.getName());
        fleet.addAssignment(FleetAssignment.GO_TO_LOCATION_AND_DESPAWN, sourceMarket.getPrimaryEntity(), 1000.0f, "returning to " + sourceMarket.getName() + " after delivering manufacturing goods to " + destMarket.getName());
        log.info((Object)("EDFleetManager: Sending trade fleet from " + sourceMarket.getName() + " to " + destMarket.getName()));
    }
}

