/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.edshipyard.campaign.submarkets;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.CoreUIAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.FactionDoctrineAPI;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.campaign.SubmarketPlugin;
import com.fs.starfarer.api.campaign.econ.SubmarketAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.submarkets.BaseSubmarketPlugin;
import data.scripts.edshipyard.util.Utils;

public class ed_shipyard_submarketPlugin
extends BaseSubmarketPlugin {
    private final RepLevel MIN_STANDING = RepLevel.FAVORABLE;

    public void init(SubmarketAPI submarket) {
        super.init(submarket);
    }

    public float getTariff() {
        switch (this.market.getFaction().getRelationshipLevel(Global.getSector().getFaction("player"))) {
            case COOPERATIVE: {
                return 0.15f;
            }
            case FRIENDLY: {
                return 0.3f;
            }
            case WELCOMING: {
                return 0.45f;
            }
        }
        return 0.6f;
    }

    public String getTooltipAppendix(CoreUIAPI ui) {
        if (this.isEnabled(ui)) {
            return super.getTooltipAppendix(ui);
        }
        RepLevel level = this.market.getFaction().getRelationshipLevel(Global.getSector().getFaction("player"));
        if (!this.isPlayerOwned() && !this.isIndependentOwned()) {
            return "Defunct due to hostile occupation (not Player or Independent owned)";
        }
        if (!Global.getSector().getPlayerFleet().isTransponderOn()) {
            return "Requires: Transponder on";
        }
        if (!this.isPlayerInGoodStandingWith("independent")) {
            return "Requires: " + this.market.getFaction().getDisplayName() + " - " + this.MIN_STANDING.getDisplayName().toLowerCase();
        }
        return "Unknown";
    }

    public boolean isEnabled(CoreUIAPI ui) {
        if (this.isPlayerOwned()) {
            return this.isPlayerInGoodStandingWith("independent");
        }
        if (this.isIndependentOwned() && Global.getSector().getPlayerFleet().isTransponderOn()) {
            return this.isPlayerInGoodStandingWith("independent");
        }
        return false;
    }

    public void updateCargoPrePlayerInteraction() {
        this.sinceLastCargoUpdate = 0.0f;
        if (this.okToUpdateShipsAndWeapons()) {
            this.sinceSWUpdate = 0.0f;
            this.getCargo().getMothballedShips().clear();
            this.getCargo().clear();
            float quality = 1.25f;
            FactionDoctrineAPI doctrineOverride = this.submarket.getFaction().getDoctrine().clone();
            doctrineOverride.setShipSize(3);
            this.addShips(this.submarket.getFaction().getId(), 160.0f, 40.0f, 40.0f, 10.0f, 10.0f, 40.0f, Float.valueOf(quality), 0.0f, FactionAPI.ShipPickMode.PRIORITY_THEN_ALL, doctrineOverride);
            this.addShip("edshipyard_bernese_tug", false, 0.0f);
            this.addShip("edshipyard_basenji_explorer", false, 0.0f);
            this.addWeapons(10, 14, 5, this.submarket.getFaction().getId());
            this.addFighters(1, 3, 5, this.submarket.getFaction().getId());
        }
        this.getCargo().sort();
    }

    public boolean isIllegalOnSubmarket(CargoStackAPI stack, SubmarketPlugin.TransferAction action) {
        return action == SubmarketPlugin.TransferAction.PLAYER_SELL;
    }

    public boolean isIllegalOnSubmarket(String commodityId, SubmarketPlugin.TransferAction action) {
        return action == SubmarketPlugin.TransferAction.PLAYER_SELL;
    }

    public boolean isIllegalOnSubmarket(FleetMemberAPI member, SubmarketPlugin.TransferAction action) {
        return action == SubmarketPlugin.TransferAction.PLAYER_SELL;
    }

    public String getIllegalTransferText(FleetMemberAPI member, SubmarketPlugin.TransferAction action) {
        return "Sales only!";
    }

    public String getIllegalTransferText(CargoStackAPI stack, SubmarketPlugin.TransferAction action) {
        return "Sales only!";
    }

    public boolean isParticipatesInEconomy() {
        return false;
    }

    private boolean isPlayerOwned() {
        return Utils.isPlayerOwned(this.market);
    }

    private boolean isIndependentOwned() {
        return Utils.isIndependentOwned(this.market);
    }

    private boolean isPlayerInGoodStandingWith(String factionName) {
        return Utils.playerHasAtLeastStandingWith(this.MIN_STANDING, factionName);
    }
}

