/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.edshipyard.rulecmd;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.Script;
import com.fs.starfarer.api.campaign.AICoreOfficerPlugin;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FleetAssignment;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.ai.ModularFleetAIAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.fleets.FleetFactoryV3;
import com.fs.starfarer.api.impl.campaign.fleets.FleetParamsV3;
import com.fs.starfarer.api.impl.campaign.fleets.PirateFleetManager;
import com.fs.starfarer.api.impl.campaign.fleets.RouteManager;
import com.fs.starfarer.api.impl.campaign.rulecmd.BaseCommandPlugin;
import com.fs.starfarer.api.loading.VariantSource;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import data.scripts.edshipyard.util.Utils;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.log4j.Logger;
import org.lwjgl.util.vector.Vector2f;

public class eds_SpawnDistressAmbushFleetCommand
extends BaseCommandPlugin {
    private static final Logger Log = Global.getLogger(eds_SpawnDistressAmbushFleetCommand.class);

    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        try {
            CampaignFleetAPI edFleet = (CampaignFleetAPI)Global.getSector().getMemoryWithoutUpdate().get("$edshipyard_distress_ed_fleet");
            StarSystemAPI system = (StarSystemAPI)Global.getSector().getMemoryWithoutUpdate().get("$edshipyard_distress_system");
            SectorEntityToken jumpPoint = (SectorEntityToken)Global.getSector().getMemoryWithoutUpdate().get("$edshipyard_distress_jumppoint");
            RouteManager.RouteData route = new RouteManager.RouteData("edshipyard_distress", Utils.getRandomFleetSource("pirates"), Long.valueOf(Misc.genRandomSeed()), null);
            CampaignFleetAPI enemyFleet = Math.random() > 0.8 ? eds_SpawnDistressAmbushFleetCommand.spawnRemnantFleet() : PirateFleetManager.createPirateFleet((int)120, (RouteManager.RouteData)route, (Vector2f)edFleet.getLocation());
            enemyFleet.setName("Ambush Fleet");
            enemyFleet.getMemoryWithoutUpdate().set("$lowRepImpact", (Object)true);
            enemyFleet.getMemoryWithoutUpdate().set("$cfai_makeAggressive", (Object)true);
            enemyFleet.getMemoryWithoutUpdate().set("$cfai_makeAggressiveLastsOneBattle", (Object)true);
            system.addEntity((SectorEntityToken)enemyFleet);
            Vector2f loc = Misc.getPointAtRadius((Vector2f)jumpPoint.getLocation(), (float)(1800.0f + (float)Math.random() * 500.0f));
            enemyFleet.setLocation(loc.x, loc.y);
            enemyFleet.setTransponderOn(true);
            enemyFleet.removeAbility("emergency_burn");
            Misc.makeHostile((CampaignFleetAPI)enemyFleet);
            edFleet.clearAssignments();
            edFleet.addAssignment(FleetAssignment.INTERCEPT, (SectorEntityToken)enemyFleet, 5.0f, "Intercepting " + enemyFleet.getName(), (Script)new PostAmbushScript(edFleet));
            ((ModularFleetAIAPI)edFleet.getAI()).getTacticalModule().setPriorityTarget((SectorEntityToken)enemyFleet, 5.0f, true);
            ((ModularFleetAIAPI)edFleet.getAI()).getTacticalModule().setTarget((SectorEntityToken)enemyFleet);
            Misc.giveStandardReturnToSourceAssignments((CampaignFleetAPI)edFleet, (boolean)false);
            edFleet.getMemoryWithoutUpdate().set("$ignorePlayerCommRequests", (Object)true);
            enemyFleet.clearAssignments();
            enemyFleet.addAssignment(FleetAssignment.ATTACK_LOCATION, (SectorEntityToken)edFleet, 10.0f, "Attacking " + edFleet.getName());
            ((ModularFleetAIAPI)enemyFleet.getAI()).getTacticalModule().setPriorityTarget((SectorEntityToken)edFleet, 10.0f, true);
            ((ModularFleetAIAPI)enemyFleet.getAI()).getTacticalModule().setTarget((SectorEntityToken)edFleet);
            Misc.giveStandardReturnToSourceAssignments((CampaignFleetAPI)enemyFleet, (boolean)false);
        }
        catch (Exception e) {
            Log.error((Object)"Error spawning ED ambush fleet", (Throwable)e);
        }
        for (String key : Global.getSector().getMemoryWithoutUpdate().getKeys()) {
            if (!key.startsWith("edshipyard_distress")) continue;
            Global.getSector().getMemoryWithoutUpdate().removeAllRequired(key);
        }
        return false;
    }

    private static CampaignFleetAPI spawnRemnantFleet() {
        FleetParamsV3 fleetParams = new FleetParamsV3(Utils.getRandomFleetSource("remnant"), null, "remnant", Float.valueOf(1.0f), "patrolMedium", 110.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        fleetParams.withOfficers = true;
        CampaignFleetAPI fleet = FleetFactoryV3.createFleet((FleetParamsV3)fleetParams);
        CampaignFleetAPI omegaFleet = Global.getFactory().createEmptyFleet("omega", "", true);
        WeightedRandomPicker picker = new WeightedRandomPicker(new Random());
        picker.add((Object)"tesseract_Attack");
        picker.add((Object)"tesseract_Attack2");
        picker.add((Object)"tesseract_Strike");
        picker.add((Object)"tesseract_Disruptor");
        omegaFleet.getFleetData().addFleetMember((String)picker.pick());
        FleetMemberAPI member = omegaFleet.getFlagship();
        AICoreOfficerPlugin plugin = Misc.getAICoreOfficerPlugin((String)"omega_core");
        PersonAPI person = plugin.createPerson("omega_core", "omega", new Random());
        member.setCaptain(person);
        int i = fleet.getFleetData().getMembersListCopy().size() - 1;
        FleetMemberAPI last = (FleetMemberAPI)fleet.getFleetData().getMembersListCopy().get(i);
        fleet.getFleetData().removeFleetMember(last);
        fleet.setCommander(person);
        fleet.getFleetData().addFleetMember(member);
        fleet.getFleetData().sort();
        List members = fleet.getFleetData().getMembersListCopy();
        for (FleetMemberAPI curr : members) {
            curr.getRepairTracker().setCR(curr.getRepairTracker().getMaxCR());
        }
        member.setVariant(member.getVariant().clone(), false, false);
        member.getVariant().setSource(VariantSource.REFIT);
        member.getVariant().addTag("ship_limited_tooltip");
        member.getVariant().addTag("consistent_weapon_drops");
        fleet.getMemoryWithoutUpdate().set("$ignorePlayerCommRequests", (Object)true);
        fleet.getMemoryWithoutUpdate().set("$core_fightToTheLast", (Object)true);
        return fleet;
    }

    private class PostAmbushScript
    implements Script {
        private final CampaignFleetAPI _edFleet;

        public PostAmbushScript(CampaignFleetAPI edFleet) {
            this._edFleet = edFleet;
        }

        public void run() {
            Misc.clearTarget((CampaignFleetAPI)this._edFleet, (boolean)true);
        }
    }
}

