/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.edshipyard.shipsystems;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CollisionClass;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.FighterWingAPI;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.graphics.SpriteAPI;
import com.fs.starfarer.api.impl.combat.BaseShipSystemScript;
import com.fs.starfarer.api.plugins.ShipSystemStatsScript;
import java.awt.Color;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Random;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.VectorUtils;
import org.lazywizard.lazylib.combat.CombatUtils;
import org.lwjgl.util.vector.Vector2f;
import org.magiclib.util.MagicRender;

public class MisdirectionStats
extends BaseShipSystemScript {
    private ShipAPI ship;
    private Random rng;
    private CombatEngineAPI engine;
    private float curTime = 0.0f;
    private float shipradius;
    private Queue<MissileAPI> effectQueue;
    private static final Vector2f ZERO = new Vector2f();
    private static final Color JITTER_UNDER_COLOR = new Color(150, 125, 50, 200);
    private static final Color JITTER_OVER_COLOR = new Color(150, 125, 50, 100);

    public void init(MutableShipStatsAPI stats) {
        this.ship = (ShipAPI)stats.getEntity();
        this.engine = Global.getCombatEngine();
        this.rng = new Random();
        this.curTime = 0.0f;
        this.effectQueue = new LinkedList<MissileAPI>();
    }

    public void apply(MutableShipStatsAPI stats, String id, ShipSystemStatsScript.State state, float effectLevel) {
        MissileAPI missile;
        if (this.ship == null) {
            this.init(stats);
        }
        if (this.engine == null) {
            return;
        }
        if (this.engine.isPaused()) {
            return;
        }
        if (!this.effectQueue.isEmpty() && (this.effectQueue.size() > 10 || this.rng.nextBoolean()) && (missile = this.effectQueue.poll()) != null) {
            MagicRender.battlespace((SpriteAPI)Global.getSettings().getSprite("fx", "ed_target"), (Vector2f)missile.getLocation(), (Vector2f)missile.getVelocity(), (Vector2f)new Vector2f(24.0f, 24.0f), (Vector2f)new Vector2f(24.0f, 24.0f), (float)(this.ship.getFacing() - 90.0f), (float)((float)(Math.random() - 0.5) * 10.0f), (Color)new Color(255, 200, 255), (boolean)true, (float)0.0f, (float)0.75f, (float)0.25f);
            Global.getSoundPlayer().playSound("detected_by_player", 0.8f, 0.8f, missile.getLocation(), ZERO);
        }
        if (state == ShipSystemStatsScript.State.IN) {
            this.shipradius = this.ship.getCollisionRadius();
            this.ship.setJitterUnder((Object)this, JITTER_UNDER_COLOR, 0.5f + effectLevel * 0.5f, 1, 1.0f, 5.0f + effectLevel * 100.0f);
            this.ship.setJitter((Object)this, JITTER_OVER_COLOR, 0.5f + effectLevel * 0.5f, 1, 1.0f, 5.0f + effectLevel * 50.0f);
            this.curTime += Global.getCombatEngine().getElapsedInLastFrame();
            while (this.curTime >= 0.5f) {
                this.curTime -= 0.5f;
                this.pulse(effectLevel);
            }
        } else if (state == ShipSystemStatsScript.State.ACTIVE) {
            this.ship.setJitterUnder((Object)this, JITTER_UNDER_COLOR, 1.0f, 1, 3.0f, 5.0f + effectLevel * 100.0f);
            this.ship.setJitter((Object)this, JITTER_OVER_COLOR, 1.0f, 1, 3.0f, 5.0f + effectLevel * 50.0f);
            this.curTime += Global.getCombatEngine().getElapsedInLastFrame();
            while (this.curTime >= 0.5f) {
                this.curTime -= 0.5f;
                this.pulse(effectLevel);
            }
        } else if (state == ShipSystemStatsScript.State.OUT) {
            this.ship.setJitter((Object)this, JITTER_OVER_COLOR, 0.5f + effectLevel * 0.5f, 1, 1.0f, 5.0f + effectLevel * 50.0f);
        }
    }

    public void pulse(float effectLevel) {
        float radius = this.shipradius + this.shipradius * effectLevel * 3.0f;
        Global.getSoundPlayer().playSound("system_quantumdisruptor", 0.7f, 0.4f, this.ship.getLocation(), ZERO);
        int numParticles = 90;
        float angleicnrease = 4.0f;
        float curangle = 0.0f;
        for (int i = 0; i < numParticles; ++i) {
            Vector2f particlePoint = MathUtils.getPointOnCircumference((Vector2f)this.ship.getLocation(), (float)(this.shipradius / 2.0f), (float)curangle);
            Vector2f particleVel = new Vector2f(radius, 0.0f);
            VectorUtils.rotate((Vector2f)particleVel, (float)curangle, (Vector2f)particleVel);
            Global.getCombatEngine().addHitParticle(particlePoint, particleVel, 15.0f, 0.6f + effectLevel * 0.3f, 1.0f, JITTER_OVER_COLOR);
            curangle += angleicnrease;
        }
        List allMissiles = CombatUtils.getMissilesWithinRange((Vector2f)this.ship.getLocation(), (float)radius);
        Collections.shuffle(allMissiles);
        for (MissileAPI missile : allMissiles) {
            if (missile.getOwner() == this.ship.getOwner() || missile.getCollisionClass() == CollisionClass.NONE) continue;
            missile.setOwner(this.ship.getOwner());
            missile.setSource(this.ship);
            this.effectQueue.add(missile);
        }
        List fighters = this.ship.getAllWings();
        if (fighters != null && !fighters.isEmpty()) {
            for (FighterWingAPI wing : fighters) {
                int num = wing.getWingMembers().size();
                if (num <= 0) continue;
                ShipAPI fighter = (ShipAPI)wing.getWingMembers().get(this.rng.nextInt(num));
                this.ship.setJitter((Object)fighter, JITTER_OVER_COLOR, 1.0f, 5, 3.0f, 5.0f + effectLevel * 50.0f);
                numParticles = 40;
                angleicnrease = 360.0f / (float)numParticles;
                curangle = 0.0f;
                for (int i = 0; i < numParticles; ++i) {
                    Vector2f particlePoint = MathUtils.getPointOnCircumference((Vector2f)fighter.getLocation(), (float)50.0f, (float)curangle);
                    Vector2f particleVel = new Vector2f(250.0f, 0.0f);
                    VectorUtils.rotate((Vector2f)particleVel, (float)curangle, (Vector2f)particleVel);
                    Global.getCombatEngine().addHitParticle(particlePoint, particleVel, 12.0f, 0.5f + effectLevel * 0.3f, 1.0f, JITTER_OVER_COLOR);
                    curangle += angleicnrease;
                }
                List fMissiles = CombatUtils.getMissilesWithinRange((Vector2f)fighter.getLocation(), (float)200.0f);
                Collections.shuffle(fMissiles);
                for (MissileAPI missile : fMissiles) {
                    if (missile.getOwner() == this.ship.getOwner() || missile.getCollisionClass() == CollisionClass.NONE) continue;
                    missile.setOwner(this.ship.getOwner());
                    missile.setSource(this.ship);
                    this.effectQueue.add(missile);
                }
            }
        }
    }
}

