/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.edshipyard.shipsystems;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.SoundAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.impl.combat.BaseShipSystemScript;
import com.fs.starfarer.api.plugins.ShipSystemStatsScript;
import com.fs.starfarer.api.util.IntervalUtil;
import java.awt.Color;
import org.dark.shaders.distortion.DistortionAPI;
import org.dark.shaders.distortion.DistortionShader;
import org.dark.shaders.distortion.RippleDistortion;
import org.dark.shaders.distortion.WaveDistortion;
import org.dark.shaders.post.PostProcessShader;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.VectorUtils;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class RelativityDriveStats
extends BaseShipSystemScript {
    public final float TIME_MULT_IN_START = 0.75f;
    public final float TIME_MULT_IN_END = 0.25f;
    public final float TIME_MULT_ACTIVE_START = 25.0f;
    public final float TIME_MULT_ACTIVE_END = 1.0f;
    private static final Vector2f ZERO = new Vector2f();
    private final IntervalUtil interval = new IntervalUtil(0.1f, 0.1f);
    private boolean started = false;
    private boolean fired = false;
    private WaveDistortion wave = null;
    private SoundAPI activateSound = null;
    private static final String postProcessKey = "relativitydrive_pp";

    public void apply(MutableShipStatsAPI stats, String id, ShipSystemStatsScript.State state, float effectLevel) {
        if (!(stats.getEntity() instanceof ShipAPI)) {
            return;
        }
        ShipAPI ship = (ShipAPI)stats.getEntity();
        Color JITTER_COLOR = new Color(255, 75, 215, 100);
        Color JITTER_UNDER_COLOR = new Color(255, 75, 225, 200);
        Color AFTERIMAGE_COLOR = new Color(255, 75, 135);
        float afterImageSpread = 0.5f;
        float afterImageJitter = 0.5f;
        float afterImageDuration = 0.15f;
        float afterImageIntensity = 0.2f;
        float jitterIntensity = 1.0f;
        float jitterUnderIntensity = 0.5f;
        float amount = Global.getCombatEngine().getElapsedInLastFrame();
        if (Global.getCombatEngine().isPaused()) {
            amount = 0.0f;
        }
        float shipRadius = RelativityDriveStats.effectiveRadius(ship);
        Vector2f offset = new Vector2f(-6.0f, 0.0f);
        VectorUtils.rotate((Vector2f)offset, (float)ship.getFacing(), (Vector2f)offset);
        Vector2f centerLocation = Vector2f.add((Vector2f)ship.getLocation(), (Vector2f)offset, (Vector2f)new Vector2f());
        switch (state) {
            case IN: {
                float startSize = shipRadius * 0.5f;
                float endSize = shipRadius * 0.75f;
                if (!this.started) {
                    Global.getCombatEngine().spawnExplosion(centerLocation, ZERO, JITTER_UNDER_COLOR, shipRadius * 2.0f, 0.1f);
                    float lifetime = 3.0f;
                    this.wave = new WaveDistortion(centerLocation, ZERO);
                    this.wave.setSize(endSize);
                    this.wave.setIntensity(endSize * 0.2f);
                    this.wave.flip(true);
                    this.wave.fadeInSize(lifetime * endSize / (endSize - startSize));
                    this.wave.fadeInIntensity(lifetime);
                    this.wave.setSize(startSize);
                    this.wave.setLifetime(0.0f);
                    this.wave.setAutoFadeIntensityTime(0.1f);
                    this.wave.setAutoFadeSizeTime(0.1f);
                    DistortionShader.addDistortion((DistortionAPI)this.wave);
                    this.started = true;
                }
                float shipTimeMult = RelativityDriveStats.lerp(0.75f, 0.25f, effectLevel);
                float damperEffectLevel = effectLevel;
                jitterIntensity *= 0.75f;
                jitterUnderIntensity *= 0.75f;
                if (this.wave != null) {
                    this.wave.setLocation(centerLocation);
                }
                stats.getTimeMult().modifyMult(id, shipTimeMult);
                float realEffectLevel = RelativityDriveStats.lerp(0.5f, 1.0f, effectLevel);
                Color jitterColor = new Color(JITTER_COLOR.getRed(), JITTER_COLOR.getGreen(), JITTER_COLOR.getBlue(), RelativityDriveStats.clamp255(Math.round(jitterIntensity * realEffectLevel * (float)JITTER_COLOR.getAlpha())));
                Color jitterUnderColor = new Color(JITTER_UNDER_COLOR.getRed(), JITTER_UNDER_COLOR.getGreen(), JITTER_UNDER_COLOR.getBlue(), RelativityDriveStats.clamp255(Math.round(jitterUnderIntensity * damperEffectLevel * (float)JITTER_UNDER_COLOR.getAlpha())));
                ship.setJitter((Object)this, jitterColor, 1.0f, 1, 0.0f, jitterIntensity * 10.0f * realEffectLevel);
                ship.setJitterUnder((Object)this, jitterUnderColor, 1.0f, 10, 0.0f, 7.0f + jitterUnderIntensity * (10.0f * damperEffectLevel));
                this.interval.advance(amount / shipTimeMult);
                if (!this.interval.intervalElapsed()) break;
                float randRange = (float)Math.sqrt(shipRadius);
                Vector2f randLoc = MathUtils.getRandomPointInCircle((Vector2f)ZERO, (float)(randRange * afterImageSpread));
                Vector2f vel = new Vector2f((ReadableVector2f)ship.getVelocity());
                vel.scale(-1.0f);
                Color afterImageColor = new Color(AFTERIMAGE_COLOR.getRed(), AFTERIMAGE_COLOR.getGreen(), AFTERIMAGE_COLOR.getBlue(), RelativityDriveStats.clamp255(Math.round(effectLevel * afterImageIntensity * (float)AFTERIMAGE_COLOR.getAlpha())));
                ship.addAfterimage(afterImageColor, randLoc.x, randLoc.y, vel.x, vel.y, randRange * afterImageJitter, 0.05f * afterImageDuration, 0.2f * afterImageDuration * shipTimeMult, 0.05f * afterImageDuration * shipTimeMult, true, false, false);
                for (int i = 0; i < 2; ++i) {
                    float particleSpawnAngle = MathUtils.getRandomNumberInRange((float)0.0f, (float)360.0f);
                    float particleSpawnDist = RelativityDriveStats.lerp(startSize * 3.0f, endSize * 3.0f, effectLevel);
                    float particleDuration = RelativityDriveStats.lerp(0.5f, 0.3f, effectLevel);
                    Vector2f particlePoint = MathUtils.getPointOnCircumference((Vector2f)centerLocation, (float)particleSpawnDist, (float)particleSpawnAngle);
                    Vector2f particleVel = new Vector2f(-particleSpawnDist * 2.0f / 3.0f / particleDuration, 0.0f);
                    VectorUtils.rotate((Vector2f)particleVel, (float)particleSpawnAngle, (Vector2f)particleVel);
                    Global.getCombatEngine().addHitParticle(particlePoint, particleVel, 5.0f, 1.0f, particleDuration, AFTERIMAGE_COLOR);
                }
                break;
            }
            case OUT: {
                if (!this.fired) {
                    this.activateSound = Global.getSoundPlayer().playSound("ed_mag2", 0.5f, 0.85f, centerLocation, ZERO);
                    Global.getCombatEngine().spawnExplosion(centerLocation, ZERO, JITTER_COLOR, shipRadius * 4.0f, 0.2f);
                    float startSize = shipRadius * 1.5f;
                    float endSize = shipRadius * 2.0f + 400.0f;
                    RippleDistortion ripple = new RippleDistortion(centerLocation, ZERO);
                    ripple.setSize(endSize);
                    ripple.setIntensity(endSize * 0.05f);
                    ripple.setFrameRate(199.99998f);
                    ripple.fadeInSize(0.3f * endSize / (endSize - startSize));
                    ripple.fadeOutIntensity(0.3f);
                    ripple.setSize(startSize);
                    DistortionShader.addDistortion((DistortionAPI)ripple);
                    int numParticles = Math.round(shipRadius);
                    for (int i = 0; i < numParticles; ++i) {
                        float particleSpawnAngle = MathUtils.getRandomNumberInRange((float)0.0f, (float)360.0f);
                        float particleDuration = MathUtils.getRandomNumberInRange((float)0.5f, (float)1.0f);
                        Vector2f particlePoint = MathUtils.getPointOnCircumference((Vector2f)centerLocation, (float)shipRadius, (float)particleSpawnAngle);
                        Vector2f particleVel = new Vector2f(shipRadius * 4.0f, 0.0f);
                        VectorUtils.rotate((Vector2f)particleVel, (float)particleSpawnAngle, (Vector2f)particleVel);
                        Global.getCombatEngine().addHitParticle(particlePoint, particleVel, 10.0f, 1.0f, particleDuration, AFTERIMAGE_COLOR);
                    }
                    this.fired = true;
                }
                float effectSqrt = (float)Math.sqrt(effectLevel);
                float shipTimeMult = RelativityDriveStats.lerp(1.0f, 25.0f, effectSqrt);
                stats.getTimeMult().modifyMult(id, shipTimeMult);
                stats.getVentRateMult().modifyMult(id, Math.min(1.0f, 2.0f / shipTimeMult));
                stats.getCRLossPerSecondPercent().modifyMult(id, 3.0f);
                stats.getPeakCRDuration().modifyFlat(id, -10.0f);
                String globalId = id + "_" + ship.getId();
                if (Global.getCombatEngine().getPlayerShip() == ship) {
                    PostProcessShader.setNoise((boolean)false, (float)RelativityDriveStats.lerp(0.0f, 0.5f, effectSqrt));
                    PostProcessShader.setSaturation((boolean)false, (float)RelativityDriveStats.lerp(1.0f, 0.0f, Math.max(0.0f, Math.min(1.0f, (effectSqrt - 0.15f) * 8.0f))));
                    PostProcessShader.setLightness((boolean)false, (float)RelativityDriveStats.lerp(1.0f, 1.5f, effectSqrt));
                    Global.getCombatEngine().getTimeMult().modifyMult(globalId, 1.0f / shipTimeMult);
                    Global.getCombatEngine().getCustomData().put(postProcessKey, new Object());
                    if (this.activateSound != null) {
                        this.activateSound.setPitch(RelativityDriveStats.lerp(2.5f, 0.5f, effectSqrt));
                        this.activateSound.setVolume(RelativityDriveStats.lerp(0.0f, 1.0f, effectSqrt));
                        this.activateSound.setLocation(centerLocation.x, centerLocation.y);
                    }
                    Global.getSoundPlayer().playLoop("ed_tick", (Object)this, 25.0f / shipTimeMult, RelativityDriveStats.lerp(0.5f, effectSqrt, Math.min(1.0f, 4.0f * (1.0f - effectLevel))), centerLocation, ZERO);
                } else {
                    Global.getCombatEngine().getTimeMult().unmodify(globalId);
                    if (Global.getCombatEngine().getCustomData().containsKey(postProcessKey)) {
                        Global.getCombatEngine().getCustomData().remove(postProcessKey);
                        PostProcessShader.resetDefaults();
                    }
                    if (this.activateSound != null) {
                        this.activateSound.setVolume(RelativityDriveStats.lerp(0.0f, 1.0f, effectSqrt));
                        this.activateSound.setLocation(centerLocation.x, centerLocation.y);
                    }
                }
                Color jitterColor = new Color(JITTER_COLOR.getRed(), JITTER_COLOR.getGreen(), JITTER_COLOR.getBlue(), RelativityDriveStats.clamp255(Math.round(jitterIntensity * effectSqrt * (float)JITTER_COLOR.getAlpha())));
                Color jitterUnderColor = new Color(JITTER_UNDER_COLOR.getRed(), JITTER_UNDER_COLOR.getGreen(), JITTER_UNDER_COLOR.getBlue(), RelativityDriveStats.clamp255(Math.round(jitterUnderIntensity * effectSqrt * (float)JITTER_UNDER_COLOR.getAlpha())));
                ship.setJitter((Object)this, jitterColor, 1.0f, 1, 5.0f, jitterIntensity * (8.0f * effectSqrt));
                ship.setJitterUnder((Object)this, jitterUnderColor, 1.0f, 10, 5.0f, jitterUnderIntensity * (12.0f * effectSqrt));
                this.interval.advance(amount);
                if (!this.interval.intervalElapsed()) break;
                float randRange = (float)Math.sqrt(shipRadius);
                Vector2f randLoc = MathUtils.getRandomPointInCircle((Vector2f)ZERO, (float)(randRange * afterImageSpread));
                Vector2f vel = new Vector2f((ReadableVector2f)ship.getVelocity());
                vel.scale(-1.0f);
                Color afterImageColor = new Color(AFTERIMAGE_COLOR.getRed(), AFTERIMAGE_COLOR.getGreen(), AFTERIMAGE_COLOR.getBlue(), RelativityDriveStats.clamp255(Math.round(effectSqrt * afterImageIntensity * (float)AFTERIMAGE_COLOR.getAlpha())));
                ship.addAfterimage(afterImageColor, randLoc.x, randLoc.y, vel.x, vel.y, randRange * afterImageJitter, 0.05f * afterImageDuration, 0.2f * afterImageDuration * shipTimeMult, 0.05f * afterImageDuration * shipTimeMult, true, false, false);
                break;
            }
        }
    }

    public static int clamp255(int x) {
        return Math.max(0, Math.min(255, x));
    }

    public static float lerp(float x, float y, float alpha) {
        return (1.0f - alpha) * x + alpha * y;
    }

    public static float effectiveRadius(ShipAPI ship) {
        if (ship.getSpriteAPI() == null || ship.isPiece()) {
            return ship.getCollisionRadius();
        }
        float fudgeFactor = 1.5f;
        return (ship.getSpriteAPI().getWidth() / 2.0f + ship.getSpriteAPI().getHeight() / 2.0f) * 0.5f * fudgeFactor;
    }

    public void unapply(MutableShipStatsAPI stats, String id) {
        if (!(stats.getEntity() instanceof ShipAPI)) {
            return;
        }
        ShipAPI ship = (ShipAPI)stats.getEntity();
        stats.getTimeMult().unmodify(id);
        stats.getVentRateMult().unmodify(id);
        stats.getCRLossPerSecondPercent().unmodify(id);
        String globalId = id + "_" + ship.getId();
        Global.getCombatEngine().getTimeMult().unmodify(globalId);
        if (Global.getCombatEngine().getCustomData().containsKey(postProcessKey)) {
            Global.getCombatEngine().getCustomData().remove(postProcessKey);
            PostProcessShader.resetDefaults();
        }
        this.started = false;
        this.fired = false;
        if (this.wave != null) {
            DistortionShader.removeDistortion((DistortionAPI)this.wave);
            this.wave = null;
        }
        if (this.activateSound != null) {
            this.activateSound.stop();
            this.activateSound = null;
        }
    }

    public ShipSystemStatsScript.StatusData getStatusData(int index, ShipSystemStatsScript.State state, float effectLevel) {
        switch (state) {
            case IN: {
                if (index != 0) break;
                return new ShipSystemStatsScript.StatusData("time flow altered", true);
            }
            case OUT: {
                if (index != 0) break;
                return new ShipSystemStatsScript.StatusData("time flow altered", false);
            }
        }
        return null;
    }
}

