/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.edshipyard.shipsystems;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipSystemAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.impl.combat.BaseShipSystemScript;
import com.fs.starfarer.api.plugins.ShipSystemStatsScript;
import com.fs.starfarer.api.util.IntervalUtil;
import java.awt.Color;
import java.util.Random;
import java.util.Stack;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.VectorUtils;
import org.lazywizard.lazylib.combat.CombatUtils;
import org.lwjgl.util.vector.Vector2f;

public class ReloadCRStats
extends BaseShipSystemScript {
    public final Color JITTER_COLOR = new Color(125, 50, 150, 150);
    private Random rng;
    private ShipAPI ship;
    private CombatEngineAPI engine;
    private WeaponAPI gun;
    private WeaponAPI loader;
    private WeaponAPI cylinder;
    private boolean spun;
    private boolean lucky;
    private boolean firing;
    private boolean loaded;
    private boolean spinning;
    private boolean reloading;
    private int ammo;
    private int frameS;
    private int frameR;
    private float currentTimer = 0.0f;
    private final float timePerFrame = 0.016666668f;
    private final float luckychance = 0.05f;
    private final IntervalUtil interval = new IntervalUtil(1.0f, 1.0f);
    private final int[] spinningFrames = new int[]{0, 1, 1, 1, 1, 2, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 7, 0};
    private final int[] reloadingFrames = new int[]{0, 1, 1, 2, 2, 3, 4, 5, 6, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 4, 3, 3, 2, 2, 2, 1, 1, 1, 0};
    private Stack<String> orders;

    public ShipSystemStatsScript.StatusData getStatusData(int index, ShipSystemStatsScript.State state, float effectLevel) {
        if (index == 0 && this.lucky) {
            return new ShipSystemStatsScript.StatusData("Next shot deals 50% extra damage", false);
        }
        return null;
    }

    public String getInfoText(ShipSystemAPI system, ShipAPI ship) {
        if (this.firing) {
            return "WEAPON FIRING";
        }
        if (this.reloading) {
            return "LOADING BULLET";
        }
        if (this.spinning) {
            return "SPINNING CYLINDER";
        }
        if (this.gun == null) {
            return "GUN NOT FOUND";
        }
        if (this.gun.getAmmo() >= 6) {
            return "FULLY LOADED";
        }
        if (this.gun.getAmmo() == 5) {
            return "RELOAD 1 BULLET";
        }
        return "RELOAD " + (6 - this.gun.getAmmo()) + " BULLETS";
    }

    public boolean isUsable(ShipSystemAPI system, ShipAPI ship) {
        if (this.gun == null || this.orders == null || !this.orders.isEmpty() || this.firing) {
            return false;
        }
        return this.gun.getAmmo() < 6;
    }

    public void init(MutableShipStatsAPI stats, String suffix) {
        this.ship = (ShipAPI)stats.getEntity();
        this.engine = Global.getCombatEngine();
        this.rng = new Random();
        for (WeaponAPI w : this.ship.getAllWeapons()) {
            if (w.getSlot().isBuiltIn() && w.getDisplayName().equals("Carolina Reaper") && w.getSlot().getId().endsWith(suffix)) {
                this.gun = w;
                continue;
            }
            if (w.isDecorative() && w.getDisplayName().equals("Carolina Cylinder") && w.getSlot().getId().endsWith(suffix)) {
                this.cylinder = w;
                continue;
            }
            if (!w.isDecorative() || !w.getDisplayName().equals("Carolina Loader") || !w.getSlot().getId().endsWith(suffix)) continue;
            this.loader = w;
        }
        this.orders = new Stack();
        this.frameS = 0;
        this.frameR = 0;
        this.spun = false;
        this.lucky = false;
        this.firing = false;
        this.loaded = false;
        this.spinning = false;
        this.reloading = false;
    }

    public void rollLuck(int ammo, MutableShipStatsAPI stats, String id) {
        if (this.rng.nextFloat() < (float)(6 - ammo) * 0.05f) {
            Global.getCombatEngine().addFloatingText(this.ship.getLocation(), "Feeling Lucky", 30.0f, Color.YELLOW, (CombatEntityAPI)this.ship, 1.0f, 1.0f);
            stats.getBallisticWeaponDamageMult().modifyMult(id, 1.5f, "Lucky Shot");
            this.lucky = true;
        }
    }

    public void apply(MutableShipStatsAPI stats, String id, ShipSystemStatsScript.State state, float effectLevel) {
        if (this.ship == null || this.gun == null) {
            this.init(stats, "");
            return;
        }
        if (this.gun.getAmmo() > 6) {
            this.gun.setAmmo(6);
        }
        if (this.engine.isPaused()) {
            return;
        }
        if (!this.orders.isEmpty() && !this.orders.peek().equals("wait")) {
            String order;
            switch (order = this.orders.pop()) {
                case "spin": {
                    this.spinning = true;
                    this.spun = false;
                    this.orders.add("wait");
                    break;
                }
                case "load": {
                    this.reloading = true;
                    this.loaded = false;
                    this.orders.add("wait");
                    break;
                }
                case "end": {
                    this.gun.setRemainingCooldownTo(1.0f);
                    this.gun.setAmmo(6);
                    this.rollLuck(this.ammo, stats, id);
                    this.ammo = 0;
                }
            }
        }
        float time = Global.getCombatEngine().getElapsedInLastFrame();
        if (this.reloading) {
            if (this.loaded) {
                this.currentTimer += time;
                this.frameR = (int)(this.currentTimer / 0.016666668f);
                if (this.frameR >= this.reloadingFrames.length - 1) {
                    this.frameR = 0;
                    this.currentTimer = 0.0f;
                    this.reloading = false;
                    if (!this.orders.isEmpty()) {
                        this.orders.pop();
                    }
                    this.orders.add("spin");
                }
                this.loader.getAnimation().setFrame(this.reloadingFrames[this.frameR]);
            } else {
                this.interval.advance(time);
                if (this.interval.intervalElapsed()) {
                    this.loaded = true;
                    Global.getSoundPlayer().playSound("carolina_load", 1.0f, 1.0f, this.ship.getLocation(), this.ship.getVelocity());
                }
            }
        } else if (this.spinning) {
            if (this.spun) {
                this.currentTimer += time;
                this.frameS = (int)(this.currentTimer / 0.016666668f);
                if (this.frameS >= this.spinningFrames.length - 1) {
                    this.frameS = 0;
                    this.currentTimer = 0.0f;
                    this.spinning = false;
                    if (!this.orders.isEmpty()) {
                        this.orders.pop();
                    }
                }
                this.cylinder.getAnimation().setFrame(this.spinningFrames[this.frameS]);
            } else {
                this.interval.advance(time);
                if (this.interval.intervalElapsed()) {
                    this.spun = true;
                    Global.getSoundPlayer().playSound("carolina_cylinder", 1.0f, 1.0f, this.ship.getLocation(), this.ship.getVelocity());
                }
            }
        }
        if (this.orders.isEmpty()) {
            if (effectLevel > 0.0f) {
                this.ammo = this.gun.getAmmo();
                this.orders.clear();
                this.gun.setAmmo(0);
                switch (this.ammo) {
                    case 5: {
                        this.orders.add("end");
                        this.orders.add("load");
                        this.orders.add("spin");
                        this.orders.add("spin");
                        break;
                    }
                    case 4: {
                        this.orders.add("end");
                        this.orders.add("load");
                        this.orders.add("load");
                        this.orders.add("spin");
                        break;
                    }
                    case 3: {
                        this.orders.add("end");
                        this.orders.add("load");
                        this.orders.add("load");
                        this.orders.add("load");
                        break;
                    }
                    case 2: {
                        this.orders.add("end");
                        this.orders.add("load");
                        this.orders.add("spin");
                        this.orders.add("spin");
                        this.orders.add("load");
                        this.orders.add("load");
                        this.orders.add("load");
                        break;
                    }
                    case 1: {
                        this.orders.add("end");
                        this.orders.add("load");
                        this.orders.add("load");
                        this.orders.add("spin");
                        this.orders.add("load");
                        this.orders.add("load");
                        this.orders.add("load");
                        break;
                    }
                    case 0: {
                        this.orders.add("end");
                        this.orders.add("load");
                        this.orders.add("load");
                        this.orders.add("load");
                        this.orders.add("load");
                        this.orders.add("load");
                        this.orders.add("load");
                    }
                }
            } else if (!this.firing) {
                if (this.gun.getChargeLevel() >= 1.0f) {
                    this.firing = true;
                    this.orders.add("spin");
                    float aim = this.gun.getArcFacing() + this.ship.getFacing();
                    Vector2f recoil = MathUtils.getPoint((Vector2f)this.gun.getLocation(), (float)100.0f, (float)(aim - 180.0f));
                    float feedback = 450.0f;
                    if (this.lucky) {
                        this.lucky = false;
                        feedback = 750.0f;
                        Global.getCombatEngine().addFloatingText(MathUtils.getPoint((Vector2f)this.gun.getLocation(), (float)100.0f, (float)this.ship.getFacing()), "Lucky Shot", 30.0f, Color.RED, (CombatEntityAPI)this.ship, 1.0f, 1.0f);
                        Global.getSoundPlayer().playSound("carolina_fire", 0.7f, 1.6f, this.ship.getLocation(), this.ship.getVelocity());
                        stats.getBallisticWeaponDamageMult().unmodify(id);
                    }
                    CombatUtils.applyForce((CombatEntityAPI)this.ship, (Vector2f)VectorUtils.getDirectionalVector((Vector2f)this.gun.getLocation(), (Vector2f)recoil), (float)feedback);
                }
            } else if (this.gun.getChargeLevel() == 0.0f) {
                this.firing = false;
            }
        }
    }
}

