/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.edshipyard.shipsystems;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CollisionClass;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipSystemAPI;
import com.fs.starfarer.api.combat.ShipwideAIFlags;
import com.fs.starfarer.api.impl.combat.BaseShipSystemScript;
import com.fs.starfarer.api.loading.DamagingExplosionSpec;
import com.fs.starfarer.api.plugins.ShipSystemStatsScript;
import com.fs.starfarer.api.util.IntervalUtil;
import java.awt.Color;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.combat.CombatUtils;
import org.lazywizard.lazylib.combat.entities.SimpleEntity;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class SelfDestructStats
extends BaseShipSystemScript {
    private ShipAPI ship;
    private CombatEngineAPI engine;
    private final IntervalUtil tracker = new IntervalUtil(0.1f, 0.1f);
    private final IntervalUtil zapInterval = new IntervalUtil(0.2f, 0.2f);
    private boolean canExplode = true;
    private Vector2f teleportLocation = null;

    public void init(MutableShipStatsAPI stats) {
        this.ship = (ShipAPI)stats.getEntity();
        this.engine = Global.getCombatEngine();
    }

    public boolean isUsable(ShipSystemAPI system, ShipAPI ship) {
        return true;
    }

    public void apply(MutableShipStatsAPI stats, String id, ShipSystemStatsScript.State state, float effectLevel) {
        if (this.ship == null) {
            this.init(stats);
        }
        if (this.engine == null || this.engine.isPaused()) {
            return;
        }
        float amount = Global.getCombatEngine().getElapsedInLastFrame();
        if (state == ShipSystemStatsScript.State.IN || state == ShipSystemStatsScript.State.ACTIVE) {
            if (this.teleportLocation == null) {
                this.teleportLocation = new Vector2f((ReadableVector2f)this.ship.getLocation());
            }
            this.ship.getVelocity().scale(0.0f);
            this.ship.getLocation().set((ReadableVector2f)this.teleportLocation);
        } else {
            this.teleportLocation = null;
        }
        if (state == ShipSystemStatsScript.State.IN) {
            float penalty = 0.0f;
            stats.getTurnAcceleration().modifyMult(id, penalty);
            stats.getDeceleration().modifyMult(id, penalty);
            stats.getAcceleration().modifyMult(id, penalty);
            stats.getMaxTurnRate().modifyMult(id, penalty);
            stats.getMaxSpeed().modifyMult(id, penalty);
            this.zapInterval.advance(amount);
            if (this.zapInterval.intervalElapsed() && Math.random() + (double)effectLevel > 1.0) {
                this.renderZap();
            }
            this.tracker.advance(amount);
            if (this.tracker.intervalElapsed()) {
                if (effectLevel < 0.4f) {
                    Global.getSoundPlayer().playSound("mawloop", 1.2f + 0.6f * effectLevel, 0.1f + 0.5f * effectLevel, this.ship.getLocation(), this.ship.getVelocity());
                } else {
                    for (ShipAPI s : CombatUtils.getShipsWithinRange((Vector2f)this.ship.getLocation(), (float)300.0f)) {
                        ShipwideAIFlags ai;
                        if (!s.isAlive() || (ai = s.getAIFlags()) == null) continue;
                        ai.setFlag(ShipwideAIFlags.AIFlags.KEEP_SHIELDS_ON, 7.0f - 7.0f * effectLevel);
                        ai.setFlag(ShipwideAIFlags.AIFlags.HAS_INCOMING_DAMAGE, 7.0f - 7.0f * effectLevel);
                        if (s.getOwner() == this.ship.getOwner()) continue;
                        s.setShipTarget(this.ship);
                    }
                }
            }
            Color jitterColor = new Color(255, (int)(55.0f + 200.0f * effectLevel), 50, (int)(40.0f + 160.0f * effectLevel));
            this.ship.setJitter((Object)this, jitterColor, 0.5f + effectLevel * 0.5f, 5, 1.0f, 10.0f * effectLevel);
        } else if (state == ShipSystemStatsScript.State.ACTIVE && this.canExplode) {
            DamagingExplosionSpec explosion = new DamagingExplosionSpec(1.0f, 400.0f, 200.0f, 2500.0f, 500.0f, CollisionClass.PROJECTILE_FF, CollisionClass.PROJECTILE_FF, 10.0f, 50.0f, 1.0f, 100, new Color(255, 175, 50, 175), new Color(255, 175, 50, 255));
            explosion.setDamageType(DamageType.HIGH_EXPLOSIVE);
            if (this.ship.isDrone()) {
                this.engine.spawnDamagingExplosion(explosion, this.ship.getDroneSource(), this.ship.getLocation());
            } else {
                this.engine.spawnDamagingExplosion(explosion, this.ship, this.ship.getLocation());
            }
            this.canExplode = false;
        } else if (state == ShipSystemStatsScript.State.OUT) {
            if (!this.ship.getFluxTracker().isOverloaded()) {
                this.ship.getFluxTracker().beginOverloadWithTotalBaseDuration(5.0f);
                Global.getSoundPlayer().playSound("mawend", 1.8f, 0.8f, this.ship.getLocation(), this.ship.getVelocity());
            }
            float penalty = 1.0f - effectLevel;
            stats.getTurnAcceleration().modifyMult(id, penalty);
            stats.getDeceleration().modifyMult(id, penalty);
            stats.getAcceleration().modifyMult(id, penalty);
            stats.getMaxTurnRate().modifyMult(id, penalty);
            stats.getMaxSpeed().modifyMult(id, penalty);
        }
    }

    public void renderZap() {
        CombatEngineAPI engine = Global.getCombatEngine();
        Vector2f empTarget = MathUtils.getPointOnCircumference((Vector2f)this.ship.getLocation(), (float)MathUtils.getRandomNumberInRange((int)30, (int)85), (float)((float)Math.random() * 360.0f));
        float damage = 0.0f;
        float empDamage = 100.0f;
        engine.spawnEmpArc(this.ship, this.ship.getLocation(), (CombatEntityAPI)this.ship, (CombatEntityAPI)new SimpleEntity(empTarget), DamageType.ENERGY, damage, empDamage, 50.0f, null, 7.0f, Color.WHITE, Color.WHITE);
    }

    public void unapply(MutableShipStatsAPI stats, String id) {
        stats.getTurnAcceleration().unmodify();
        stats.getDeceleration().unmodify();
        stats.getAcceleration().unmodify();
        stats.getMaxTurnRate().unmodify();
        stats.getMaxSpeed().unmodify();
        this.canExplode = true;
    }
}

