/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.edshipyard.shipsystems.ai;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.FluxTrackerAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipSystemAIScript;
import com.fs.starfarer.api.combat.ShipSystemAPI;
import com.fs.starfarer.api.combat.ShipwideAIFlags;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import data.scripts.edshipyard.shipsystems.GravityGunShipSystemUtil;
import data.scripts.edshipyard.util.DebugRender;
import data.scripts.edshipyard.util.Quadrilateral;
import java.awt.Color;
import java.util.ArrayList;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.VectorUtils;
import org.lazywizard.lazylib.combat.CombatUtils;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class GravityGunShipSystemAI
implements ShipSystemAIScript {
    private static long elapsedTime = 0L;
    private static long frameCount = 0L;
    private final String LocalDataKey = "GravityGunShipSystemAI-" + UUID.randomUUID();
    private final IntervalUtil checkInterval = new IntervalUtil(0.1f, 0.2f);
    private float timeSinceLastShipInAoe = 0.0f;
    private float activeTime = 0.0f;

    public static void logPerformanceMetrics() {
        if (elapsedTime > 0L) {
            Logger log = Global.getLogger(GravityGunShipSystemAI.class);
            log.info((Object)("total time in GravityGunSystemAI: " + elapsedTime + "ms  FrameCount: " + frameCount + " Mean Time Per Frame: " + (double)elapsedTime / (double)frameCount + "ms"));
        }
    }

    private LocalData getLocalData() {
        LocalData localData = (LocalData)Global.getCombatEngine().getCustomData().get(this.LocalDataKey);
        if (localData == null) {
            localData = new LocalData();
            Global.getCombatEngine().getCustomData().put(this.LocalDataKey, localData);
        }
        return localData;
    }

    public void init(ShipAPI ship, ShipSystemAPI system, ShipwideAIFlags flags, CombatEngineAPI engine) {
        LocalData localData = this.getLocalData();
        localData.thisShip = ship;
    }

    public void advance(float amount, Vector2f missileDangerDir, Vector2f collisionDangerDir, ShipAPI target) {
        LocalData localData = this.getLocalData();
        ShipAPI thisShip = localData.thisShip;
        Object targetShip = localData.targetShip;
        if (localData.thisShip == null) {
            return;
        }
        this.timeSinceLastShipInAoe += amount;
        this.checkInterval.advance(amount);
        if (thisShip.getSystem().isOn()) {
            this.activeTime += amount;
        }
        if (!this.checkInterval.intervalElapsed()) {
            return;
        }
        ++frameCount;
        long start = System.currentTimeMillis();
        boolean turnOffSystem = false;
        if (GravityGunShipSystemAI.canUseSystemThisFrame(thisShip)) {
            Quadrilateral pullArea = GravityGunShipSystemUtil.getPullArea(thisShip);
            for (Object ship : CombatUtils.getShipsWithinRange((Vector2f)thisShip.getLocation(), (float)1900.0f)) {
                if (!this.isValidTarget((ShipAPI)ship, ShipAPI.HullSize.FRIGATE, thisShip) || !GravityGunShipSystemUtil.isValidForBeamToAffect((CombatEntityAPI)ship) || !pullArea.containsPoint(ship.getLocation())) continue;
                if (!thisShip.getSystem().isOn()) {
                    thisShip.useSystem();
                }
                this.timeSinceLastShipInAoe = 0.0f;
                break;
            }
        } else if (thisShip.getSystem().isOn()) {
            turnOffSystem = true;
        }
        ArrayList<ShipAPI> shipsInMaw = new ArrayList<ShipAPI>();
        if (thisShip.getSystem().isOn() && (double)thisShip.getSystem().getEffectLevel() >= 0.998) {
            Quadrilateral pushArea = GravityGunShipSystemUtil.getPushArea(thisShip);
            for (ShipAPI ship : CombatUtils.getShipsWithinRange((Vector2f)thisShip.getLocation(), (float)620.0f)) {
                if (!this.isValidTarget(ship, ShipAPI.HullSize.DESTROYER, thisShip) || !pushArea.containsPoint(ship.getLocation())) continue;
                shipsInMaw.add(ship);
            }
        }
        if (thisShip.getSystem().isOn() && (turnOffSystem || (double)this.timeSinceLastShipInAoe > 1.5 || this.activeTime > 10.0f)) {
            boolean safeToTurnOff = true;
            for (CombatEntityAPI entity : CombatUtils.getEntitiesWithinRange((Vector2f)thisShip.getLocation(), (float)1900.0f)) {
                if (entity == thisShip || entity.getMass() < 1000.0f) continue;
                safeToTurnOff &= !GravityGunShipSystemAI.isComingTowardsMe(thisShip, entity);
            }
            if (safeToTurnOff) {
                thisShip.useSystem();
                this.activeTime = 0.0f;
            }
        }
        if (shipsInMaw.size() > 0 && (targetShip == null || shipsInMaw.contains(targetShip) || MathUtils.getDistance((Vector2f)thisShip.getLocation(), (Vector2f)targetShip.getLocation()) > 1700.0f)) {
            targetShip = null;
            for (Object ship : CombatUtils.getShipsWithinRange((Vector2f)thisShip.getLocation(), (float)1900.0f)) {
                if (!this.isValidTarget((ShipAPI)ship, ShipAPI.HullSize.CRUISER, thisShip) || ship == targetShip || shipsInMaw.contains(ship) || targetShip != null && !(MathUtils.getDistanceSquared((Vector2f)thisShip.getLocation(), (Vector2f)targetShip.getLocation()) > MathUtils.getDistanceSquared((Vector2f)thisShip.getLocation(), (Vector2f)ship.getLocation()))) continue;
                targetShip = ship;
            }
        } else {
            targetShip = null;
        }
        if (targetShip != null && !targetShip.isHulk()) {
            float angle = VectorUtils.getAngle((Vector2f)thisShip.getLocation(), (Vector2f)targetShip.getLocation()) - thisShip.getFacing();
            DebugRender.renderIfDebug(targetShip.getLocation(), Color.MAGENTA);
            if (angle < -5.0f) {
                thisShip.setAngularVelocity(-6.0f);
            } else if (angle > 5.0f) {
                thisShip.setAngularVelocity(6.0f);
            } else {
                thisShip.setAngularVelocity(0.0f);
            }
        }
        elapsedTime += System.currentTimeMillis() - start;
        localData.thisShip = thisShip;
        localData.targetShip = targetShip;
    }

    private boolean isValidTarget(ShipAPI otherShip, ShipAPI.HullSize minHullSizeToTarget, ShipAPI thisShip) {
        if (otherShip == null || otherShip.isHulk() || otherShip.isAlly() || otherShip.getOwner() == thisShip.getOwner()) {
            return false;
        }
        return otherShip.getHullSize().ordinal() >= minHullSizeToTarget.ordinal();
    }

    public static boolean isComingTowardsMe(ShipAPI me, CombatEntityAPI them) {
        Vector2f velocity = new Vector2f((ReadableVector2f)them.getVelocity());
        if (velocity.x == 0.0f && velocity.y == 0.0f || me.getVelocity().x - them.getVelocity().x < 2.0f && me.getVelocity().y - them.getVelocity().y < 2.0f) {
            return false;
        }
        velocity.x *= 1000.0f;
        velocity.y *= 1000.0f;
        float distance = Misc.distanceFromLineToPoint((Vector2f)them.getLocation(), (Vector2f)velocity, (Vector2f)me.getLocation());
        return distance < 100.0f;
    }

    public static boolean canUseSystemThisFrame(ShipAPI ship) {
        FluxTrackerAPI flux = ship.getFluxTracker();
        ShipSystemAPI system = ship.getSystem();
        if (flux.isOverloadedOrVenting() || flux.getMaxFlux() - flux.getCurrFlux() < system.getFluxPerSecond()) {
            return false;
        }
        if (system.isOn()) {
            return true;
        }
        return system.getCooldownRemaining() == 0.0f;
    }

    private class LocalData {
        ShipAPI thisShip;
        ShipAPI targetShip;

        private LocalData() {
        }
    }
}

