/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.edshipyard.shipsystems.ai;

import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipCommand;
import com.fs.starfarer.api.combat.ShipSystemAIScript;
import com.fs.starfarer.api.combat.ShipSystemAPI;
import com.fs.starfarer.api.combat.ShipwideAIFlags;
import com.fs.starfarer.api.util.IntervalUtil;
import org.lwjgl.util.vector.Vector2f;

public class ModuleShieldAI
implements ShipSystemAIScript {
    private CombatEngineAPI engine;
    private ShipAPI ship;
    private ShipSystemAPI system;
    private ShipAPI parent;
    private final IntervalUtil tracker = new IntervalUtil(0.2f, 0.3f);

    public void advance(float amount, Vector2f missileDangerDir, Vector2f collisionDangerDir, ShipAPI target) {
        if (this.engine == null) {
            return;
        }
        if (this.engine.isPaused()) {
            return;
        }
        this.tracker.advance(amount);
        if (this.tracker.intervalElapsed()) {
            if (this.ship.getFluxTracker().isOverloadedOrVenting()) {
                return;
            }
            if (this.parent == null) {
                this.parent = this.ship.getParentStation();
            } else {
                if (this.parent.isPhased() || this.parent.getShield() != null && this.parent.getShield().isOn()) {
                    if (this.parent.getFluxLevel() <= 0.5f && this.ship.getFluxLevel() >= 0.3f) {
                        this.ship.giveCommand(ShipCommand.VENT_FLUX, null, 0);
                    }
                    if (this.system.isActive()) {
                        this.ship.getSystem().deactivate();
                    }
                    return;
                }
                if (!this.system.isActive() && this.ship.getShield().isOn()) {
                    this.ship.useSystem();
                }
            }
        }
    }

    public void init(ShipAPI ship, ShipSystemAPI system, ShipwideAIFlags flags, CombatEngineAPI engine) {
        this.ship = ship;
        this.system = system;
        this.engine = engine;
    }
}

