/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.edshipyard.shipsystems.ai;

import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.ShipAIConfig;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipSystemAIScript;
import com.fs.starfarer.api.combat.ShipSystemAPI;
import com.fs.starfarer.api.combat.ShipwideAIFlags;
import com.fs.starfarer.api.util.IntervalUtil;
import org.lwjgl.util.vector.Vector2f;

public class RelativityDriveAI
implements ShipSystemAIScript {
    private static final float TARGET_DESIRE = 1.0f;
    private CombatEngineAPI engine;
    private ShipwideAIFlags flags;
    private ShipAPI ship;
    private ShipSystemAPI system;
    private final IntervalUtil tracker = new IntervalUtil(0.2f, 0.3f);
    private boolean resetAI = false;
    private final ShipAIConfig savedConfig = new ShipAIConfig();

    public void advance(float amount, Vector2f missileDangerDir, Vector2f collisionDangerDir, ShipAPI target) {
        if (this.engine == null) {
            return;
        }
        if (this.engine.isPaused()) {
            return;
        }
        this.tracker.advance(amount);
        if (this.tracker.intervalElapsed()) {
            float targetDesire;
            if (this.ship.getFluxTracker().isOverloadedOrVenting() || this.system.isActive() || this.system.isCoolingDown() || this.ship.isPhased()) {
                return;
            }
            boolean phaseCooldown = false;
            boolean phaseCooldownShort = false;
            if (this.ship.getPhaseCloak() != null) {
                if (this.ship.getPhaseCloak().isCoolingDown()) {
                    phaseCooldown = true;
                    if (this.ship.getPhaseCloak().getCooldownRemaining() < this.ship.getPhaseCloak().getCooldown() / 2.0f) {
                        phaseCooldownShort = true;
                    }
                } else if (this.ship.getPhaseCloak().isChargedown()) {
                    phaseCooldown = true;
                }
            }
            float fluxRemaining = this.ship.getFluxTracker().getMaxFlux() - this.ship.getFluxTracker().getCurrFlux();
            if (this.ship.getSystem().getFluxPerUse() > fluxRemaining) {
                return;
            }
            float missileThreatLevel = 0.0f;
            boolean missileThreat = missileThreatLevel >= this.ship.getHitpoints() * 0.5f;
            boolean highMissileThreat = missileThreatLevel >= this.ship.getHitpoints();
            boolean ultraHighMissileThreat = missileThreatLevel >= this.ship.getHitpoints() * 2.0f;
            float desire = 0.0f;
            if (!this.flags.hasFlag(ShipwideAIFlags.AIFlags.BACKING_OFF)) {
                desire = (1.0f - this.ship.getFluxLevel()) * 0.75f;
            }
            if (this.flags.hasFlag(ShipwideAIFlags.AIFlags.PHASE_ATTACK_RUN_FROM_BEHIND_DIST_CRITICAL)) {
                desire += 1.0f - this.ship.getFluxLevel();
            }
            if (this.flags.hasFlag(ShipwideAIFlags.AIFlags.PHASE_ATTACK_RUN_IN_GOOD_SPOT)) {
                desire += (1.0f - this.ship.getFluxLevel()) * 5.0f;
            }
            if (this.flags.hasFlag(ShipwideAIFlags.AIFlags.MAINTAINING_STRIKE_RANGE)) {
                desire += 0.5f;
            }
            desire *= fluxRemaining / Math.max(1.0f, fluxRemaining + this.system.getFluxPerUse());
            if (this.flags.hasFlag(ShipwideAIFlags.AIFlags.IN_CRITICAL_DPS_DANGER) || ultraHighMissileThreat) {
                desire = phaseCooldown && !phaseCooldownShort ? (highMissileThreat ? (desire += 1.25f) : (ultraHighMissileThreat ? (desire += 1.0f) : (missileThreat ? (desire += 0.75f) : (desire += 0.5f)))) : (ultraHighMissileThreat ? (desire += 1.25f) : (highMissileThreat ? (desire += 1.0f) : (missileThreat ? (desire += 0.5f) : (desire -= 1.0f))));
            }
            if (this.flags.hasFlag(ShipwideAIFlags.AIFlags.NEEDS_HELP) && phaseCooldown && !phaseCooldownShort) {
                desire += 0.5f;
            }
            if (this.flags.hasFlag(ShipwideAIFlags.AIFlags.HAS_INCOMING_DAMAGE) || ultraHighMissileThreat) {
                if (phaseCooldown && !phaseCooldownShort) {
                    if (missileThreat) {
                        desire += 0.25f;
                    }
                } else if (highMissileThreat) {
                    desire += 0.25f;
                }
            }
            if (this.flags.hasFlag(ShipwideAIFlags.AIFlags.DO_NOT_PURSUE) && !missileThreat) {
                desire -= 0.25f;
            }
            if (this.flags.hasFlag(ShipwideAIFlags.AIFlags.DO_NOT_USE_FLUX) && !highMissileThreat) {
                desire -= 0.25f;
            }
            if (this.flags.hasFlag(ShipwideAIFlags.AIFlags.RUN_QUICKLY) && !highMissileThreat) {
                desire -= 0.25f;
            }
            if (this.flags.hasFlag(ShipwideAIFlags.AIFlags.TURN_QUICKLY) && !missileThreat) {
                desire -= 0.25f;
            }
            if (desire >= (targetDesire = 1.0f)) {
                this.ship.useSystem();
            }
        }
        if (this.system.isActive()) {
            this.flags.setFlag(ShipwideAIFlags.AIFlags.DO_NOT_BACK_OFF, 0.25f);
            this.flags.unsetFlag(ShipwideAIFlags.AIFlags.BACK_OFF);
            this.flags.unsetFlag(ShipwideAIFlags.AIFlags.DO_NOT_PURSUE);
            this.flags.unsetFlag(ShipwideAIFlags.AIFlags.DO_NOT_USE_FLUX);
            this.flags.unsetFlag(ShipwideAIFlags.AIFlags.DO_NOT_AUTOFIRE_NON_ESSENTIAL_GROUPS);
            if (!this.resetAI) {
                this.resetAI = true;
                this.saveAIConfig(this.ship);
                this.ship.getShipAI().getConfig().alwaysStrafeOffensively = true;
                this.ship.getShipAI().getConfig().turnToFaceWithUndamagedArmor = false;
                this.ship.getShipAI().getConfig().personalityOverride = "reckless";
                this.ship.getShipAI().forceCircumstanceEvaluation();
            }
        } else if (this.resetAI) {
            this.resetAI = false;
            this.flags.unsetFlag(ShipwideAIFlags.AIFlags.DO_NOT_BACK_OFF);
            this.restoreAIConfig(this.ship);
            this.ship.getShipAI().forceCircumstanceEvaluation();
        }
    }

    public void init(ShipAPI ship, ShipSystemAPI system, ShipwideAIFlags flags, CombatEngineAPI engine) {
        this.ship = ship;
        this.flags = flags;
        this.system = system;
        this.engine = engine;
    }

    private void saveAIConfig(ShipAPI ship) {
        if (ship.getShipAI().getConfig() != null) {
            this.savedConfig.alwaysStrafeOffensively = ship.getShipAI().getConfig().alwaysStrafeOffensively;
            this.savedConfig.turnToFaceWithUndamagedArmor = ship.getShipAI().getConfig().turnToFaceWithUndamagedArmor;
            this.savedConfig.personalityOverride = ship.getShipAI().getConfig().personalityOverride;
        }
    }

    private void restoreAIConfig(ShipAPI ship) {
        if (ship.getShipAI().getConfig() != null) {
            ship.getShipAI().getConfig().alwaysStrafeOffensively = this.savedConfig.alwaysStrafeOffensively;
            ship.getShipAI().getConfig().turnToFaceWithUndamagedArmor = this.savedConfig.turnToFaceWithUndamagedArmor;
            ship.getShipAI().getConfig().personalityOverride = this.savedConfig.personalityOverride;
        }
    }
}

