/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.edshipyard.weapons;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BeamAPI;
import com.fs.starfarer.api.combat.CollisionClass;
import com.fs.starfarer.api.combat.CombatAsteroidAPI;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.impl.combat.TachyonLanceEffect;
import com.fs.starfarer.api.loading.DamagingExplosionSpec;
import com.fs.starfarer.api.util.IntervalUtil;
import java.awt.Color;

public class MAW_BeamEffect
extends TachyonLanceEffect {
    private final IntervalUtil destroyHulkInterval = new IntervalUtil(0.18f, 0.23f);
    private boolean wasZero = true;

    public void advance(float amount, CombatEngineAPI engine, BeamAPI beam) {
        super.advance(amount, engine, beam);
        CombatEntityAPI target = beam.getDamageTarget();
        if (target == null || target.getOwner() != 100) {
            return;
        }
        float dur = beam.getDamage().getDpsDuration();
        if (!this.wasZero) {
            dur = 0.0f;
        }
        this.wasZero = beam.getDamage().getDpsDuration() <= 0.0f;
        this.destroyHulkInterval.advance(dur);
        if (this.destroyHulkInterval.intervalElapsed() && (double)beam.getWeapon().getChargeLevel() > 0.25) {
            engine.spawnDamagingExplosion(new DamagingExplosionSpec(0.25f, 10.0f, 5.0f, 50.0f, 50.0f, CollisionClass.PROJECTILE_FF, CollisionClass.PROJECTILE_FIGHTER, 3.0f, 3.0f, 0.5f, 5, new Color(255, 225, 255), new Color(100, 0, 150, 125)), beam.getSource(), beam.getRayEndPrevFrame(), false);
            engine.applyDamage(target, beam.getTo(), 15000.0f, DamageType.ENERGY, 0.0f, false, true, (Object)beam.getSource(), false);
            if (target instanceof ShipAPI && ((ShipAPI)target).isPiece() || target instanceof CombatAsteroidAPI) {
                Global.getCombatEngine().removeEntity(target);
            }
        }
    }
}

