/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.edshipyard.weapons;

import com.fs.starfarer.api.combat.BeamAPI;
import com.fs.starfarer.api.combat.BeamEffectPlugin;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import org.lwjgl.util.vector.Vector2f;

public class ShipBreakerBeamEffect
implements BeamEffectPlugin {
    private final IntervalUtil fireInterval = new IntervalUtil(0.3f, 2.0f);
    private boolean wasZero = true;

    public void advance(float amount, CombatEngineAPI engine, BeamAPI beam) {
        CombatEntityAPI target = beam.getDamageTarget();
        if (target instanceof ShipAPI && beam.getBrightness() >= 1.0f) {
            float dur = beam.getDamage().getDpsDuration();
            if (!this.wasZero) {
                dur = 0.0f;
            }
            this.wasZero = beam.getDamage().getDpsDuration() <= 0.0f;
            this.fireInterval.advance(dur);
            if (this.fireInterval.intervalElapsed()) {
                boolean hitShield;
                boolean bl = hitShield = target.getShield() != null && target.getShield().isWithinArc(beam.getTo());
                if (!hitShield) {
                    Vector2f dir = Vector2f.sub((Vector2f)beam.getTo(), (Vector2f)beam.getFrom(), (Vector2f)new Vector2f());
                    if (dir.lengthSquared() > 0.0f) {
                        dir.normalise();
                    }
                    dir.scale(50.0f);
                    Vector2f point = Vector2f.sub((Vector2f)beam.getTo(), (Vector2f)dir, (Vector2f)new Vector2f());
                    float emp = beam.getWeapon().getDamage().getFluxComponent() * 0.5f;
                    float dam = beam.getWeapon().getDamage().getDamage() * 0.25f;
                    engine.spawnEmpArcPierceShields(beam.getSource(), point, beam.getDamageTarget(), beam.getDamageTarget(), DamageType.ENERGY, dam, emp, 100000.0f, "tachyon_lance_emp_impact", beam.getWidth(), beam.getFringeColor(), beam.getCoreColor());
                }
            }
        }
    }
}

