/*
 * Decompiled with CFR 0.152.
 */
package data.hullmods.edshipyard;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BaseHullMod;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import data.scripts.edshipyard.util.StolenUtils;
import java.awt.Color;
import java.util.List;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.combat.CombatUtils;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class Illusion
extends BaseHullMod {
    public final Color JITTER_COLOR = new Color(125, 50, 150, 150);
    private static final String ILLUSIONKEY = "IllusionDamageReduction";

    public void applyEffectsBeforeShipCreation(ShipAPI.HullSize hullSize, MutableShipStatsAPI stats, String id) {
        stats.getSensorProfile().modifyMult(id, 0.0f);
    }

    public void advanceInCombat(ShipAPI ship, float amount) {
        if (ship == null) {
            return;
        }
        float radius = ship.getCollisionRadius();
        List ships = CombatUtils.getShipsWithinRange((Vector2f)ship.getLocation(), (float)(radius + 100.0f));
        for (ShipAPI s : ships) {
            MutableShipStatsAPI stats;
            if (s == null || !s.isDrone() || s.getOwner() != ship.getOwner() || !s.getHullSpec().getBaseHullId().equals("edshipyard_chihuahua_doppel") && !s.getHullSpec().getBaseHullId().equals("edshipyard_shiba_doppel") || (stats = s.getMutableStats()).getHullDamageTakenMult().getMultMods().containsKey(ILLUSIONKEY)) continue;
            float angle = ship.getFacing();
            Vector2f point = MathUtils.getPointOnCircumference((Vector2f)ship.getLocation(), (float)MathUtils.getRandomNumberInRange((float)(radius * 3.0f + 300.0f), (float)(radius * 5.0f + 400.0f)), (float)MathUtils.getRandomNumberInRange((float)(angle + 270.0f), (float)(angle + 90.0f)));
            ship.setJitter((Object)ship, this.JITTER_COLOR, 1.0f, 2, ship.getCollisionRadius() * 1.5f);
            s.getLocation().set((ReadableVector2f)point);
            ship.setJitter((Object)s, this.JITTER_COLOR, 1.0f, 15, ship.getCollisionRadius() * 2.5f);
            s.setFacing(angle);
            stats.getHullDamageTakenMult().modifyMult(ILLUSIONKEY, 0.01f);
            StolenUtils.createSmoothFlare(Global.getCombatEngine(), ship, point, 50.0f, (radius + 100.0f) * 2.0f, 0.0f, new Color(250, 150, 255, 128), Color.white);
        }
        super.advanceInCombat(ship, amount);
    }
}

