/*
 * Decompiled with CFR 0.152.
 */
package data.hullmods.edshipyard;

import com.fs.starfarer.api.combat.BaseHullMod;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;

public class SafetyRemoval
extends BaseHullMod {
    private static final Map<ShipAPI.HullSize, Float> speed = new HashMap<ShipAPI.HullSize, Float>();
    private static final float RANGE_THRESHOLD = 450.0f;
    private static final float RANGE_MULT = 0.25f;
    private static final float MANEUVER_MULT = 1.2f;
    private final Color color = new Color(225, 150, 225, 255);

    public void applyEffectsBeforeShipCreation(ShipAPI.HullSize hullSize, MutableShipStatsAPI stats, String id) {
        if (stats == null) {
            return;
        }
        stats.getMaxSpeed().modifyFlat(id, speed.get(hullSize).floatValue());
        stats.getZeroFluxMinimumFluxLevel().modifyFlat(id, 2.0f);
        stats.getWeaponRangeThreshold().modifyFlat(id, 450.0f);
        stats.getWeaponRangeMultPastThreshold().modifyMult(id, 0.25f);
        stats.getMaxTurnRate().modifyMult(id, 1.2f);
        stats.getTurnAcceleration().modifyMult(id, 1.2f);
        stats.getAcceleration().modifyMult(id, 1.2f);
        stats.getDeceleration().modifyMult(id, 1.2f);
    }

    public String getDescriptionParam(int index, ShipAPI.HullSize hullSize) {
        if (index == 0) {
            return "" + speed.get(ShipAPI.HullSize.FRIGATE).intValue();
        }
        if (index == 1) {
            return "" + speed.get(ShipAPI.HullSize.DESTROYER).intValue();
        }
        if (index == 2) {
            return "" + speed.get(ShipAPI.HullSize.CRUISER).intValue();
        }
        if (index == 3) {
            return "" + speed.get(ShipAPI.HullSize.CAPITAL_SHIP).intValue();
        }
        if (index == 4) {
            return Misc.getRoundedValue((float)450.0f);
        }
        if (index == 5) {
            return Misc.getRoundedValue((float)75.0f);
        }
        if (index == 6) {
            return Misc.getRoundedValue((float)20.000004f);
        }
        return null;
    }

    public void applyEffectsAfterShipCreation(ShipAPI ship, String id) {
        super.applyEffectsAfterShipCreation(ship, id);
        if (ship.getVariant().getHullMods().contains("safetyoverrides")) {
            ship.getVariant().removeMod("safetyoverrides");
        }
    }

    public String getUnapplicableReason(ShipAPI ship) {
        if (ship.getVariant().hasHullMod("civgrade") && !ship.getVariant().hasHullMod("militarized_subsystems")) {
            return "Can not be installed on civilian ships";
        }
        return null;
    }

    public void advanceInCombat(ShipAPI ship, float amount) {
        ship.getEngineController().fadeToOtherColor((Object)this, this.color, null, 1.0f, 0.4f);
        ship.getEngineController().extendFlame((Object)this, 0.25f, 0.25f, 0.25f);
    }

    public boolean isApplicableToShip(ShipAPI ship) {
        return false;
    }

    static {
        speed.put(ShipAPI.HullSize.FRIGATE, Float.valueOf(30.0f));
        speed.put(ShipAPI.HullSize.DESTROYER, Float.valueOf(30.0f));
        speed.put(ShipAPI.HullSize.CRUISER, Float.valueOf(30.0f));
        speed.put(ShipAPI.HullSize.CAPITAL_SHIP, Float.valueOf(30.0f));
    }
}

