/*
 * Decompiled with CFR 0.152.
 */
package data.hullmods.edshipyard;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BaseHullMod;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipCommand;
import com.fs.starfarer.api.combat.ShipEngineControllerAPI;
import com.fs.starfarer.api.combat.ShipVariantAPI;
import com.fs.starfarer.api.combat.ShipwideAIFlags;
import com.fs.starfarer.util.IntervalTracker;
import data.scripts.edshipyard.util.Utils;
import java.util.ArrayList;
import java.util.List;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.VectorUtils;
import org.lazywizard.lazylib.combat.CombatUtils;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class TrainLocomotive
extends BaseHullMod {
    public static final float ZEROFLUXSPEED_MOD = 0.3f;
    public static final float PROFILE_MOD = 150.0f;
    public static final int NUMBER_OF_SEGMENTS = 5;
    public static final float RANGE = 90.0f;
    public static final float REALIGNMENT_CONSTANT = 3.0f;
    private static final String[] SEGMENT_NAMES = new String[]{"SEGMENT1", "SEGMENT2", "SEGMENT3", "SEGMENT4", "SEGMENT5"};
    private final IntervalTracker _parentInterval = new IntervalTracker(0.15f, 0.25f);
    private final IntervalTracker _repulseInterval = new IntervalTracker(0.1f, 0.1f);

    public String getDescriptionParam(int index, ShipAPI.HullSize hullSize) {
        return null;
    }

    public void applyEffectsBeforeShipCreation(ShipAPI.HullSize hullSize, MutableShipStatsAPI stats, String id) {
        stats.getZeroFluxSpeedBoost().modifyMult(id, 0.3f);
        stats.getSensorProfile().modifyFlat(id, 150.0f);
        ShipVariantAPI ship = stats.getVariant();
        if (ship != null) {
            float fuel = 0.0f;
            float crew = 0.0f;
            float cargo = 0.0f;
            float fuelCost = 0.0f;
            float crewLimit = 0.0f;
            float supplyCost = 0.0f;
            for (int i = 1; i <= 5; ++i) {
                cargo += 1250.0f;
                fuel += 500.0f;
                crew += 50.0f;
                crewLimit += 250.0f;
                fuelCost += 2.0f;
                supplyCost += 4.0f;
            }
            stats.getFuelMod().modifyFlat("trainModuleBonus", fuel);
            stats.getCargoMod().modifyFlat("trainModuleBonus", cargo);
            stats.getMinCrewMod().modifyFlat("trainModuleBonus", crew);
            stats.getFuelUseMod().modifyFlat("trainModuleBonus", fuelCost);
            stats.getMaxCrewMod().modifyFlat("trainModuleBonus", crewLimit);
            stats.getSuppliesPerMonth().modifyFlat("trainModuleBonus", supplyCost);
        }
    }

    public void applyEffectsAfterShipCreation(ShipAPI ship, String id) {
    }

    public boolean isApplicableToShip(ShipAPI ship) {
        return true;
    }

    public void advanceInCombat(ShipAPI ship, float amount) {
        super.advanceInCombat(ship, amount);
        List children = ship.getChildModulesCopy();
        this.advanceParent(ship, children, amount);
        for (ShipAPI s : children) {
            TrainLocomotive.advanceChild(s, ship);
        }
        TrainWagon[] wagonSegments = this.getTrainWagon(children);
        for (TrainWagon tw : wagonSegments = this.removeDeadSegments(wagonSegments)) {
            try {
                if (!tw.isFirst()) {
                    tw.ship.getLocation().set((ReadableVector2f)tw.previousSegment.ship.getHullSpec().getWeaponSlotAPI("SEGMENT").computePosition((CombatEntityAPI)tw.previousSegment.ship));
                }
                float difference = ship.getAngularVelocity() * amount;
                float angle = tw.ship.getStationSlot().getAngle() - difference;
                float angleOffset = this.normalizeAngle(tw.ship.getFacing() - tw.previousSegment.ship.getFacing());
                if (angleOffset > 180.0f) {
                    angleOffset -= 360.0f;
                }
                float localMod = this.normalizeAngle(tw.previousSegment.ship.getFacing() - tw.ship.getParentStation().getFacing());
                if ((double)angleOffset < -45.0) {
                    angle = this.normalizeAngle(-45.0f + localMod);
                }
                if ((double)angleOffset > 45.0) {
                    angle = this.normalizeAngle(45.0f + localMod);
                }
                tw.ship.getStationSlot().setAngle(angle -= angleOffset / 90.0f * 0.5f * 3.0f);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (ship.getFluxTracker().isVenting() && !tw.ship.getFluxTracker().isVenting() && tw.ship.getFluxTracker().getCurrFlux() > 1000.0f && tw.ship.isAlive()) {
                    tw.ship.giveCommand(ShipCommand.VENT_FLUX, null, 0);
                    return;
                }
                if (ship.getShipTarget() != null && ship.getShipTarget() != ship.getShipTarget()) {
                    tw.ship.setShipTarget(ship.getShipTarget());
                }
                if (!tw.ship.hasLaunchBays()) continue;
                if (tw.ship.isPullBackFighters() != tw.ship.isPullBackFighters()) {
                    tw.ship.setPullBackFighters(tw.ship.isPullBackFighters());
                }
                if (tw.ship.getAIFlags() == null) continue;
                if ((Global.getCombatEngine().getPlayerShip() == ship || ship.getAIFlags() == null) && ship.getShipTarget() != null) {
                    tw.ship.getAIFlags().setFlag(ShipwideAIFlags.AIFlags.CARRIER_FIGHTER_TARGET, 1.0f, (Object)ship.getShipTarget());
                    continue;
                }
                if (ship.getAIFlags() == null || !ship.getAIFlags().hasFlag(ShipwideAIFlags.AIFlags.CARRIER_FIGHTER_TARGET) || ship.getAIFlags().getCustom(ShipwideAIFlags.AIFlags.CARRIER_FIGHTER_TARGET) == null) continue;
                tw.ship.getAIFlags().setFlag(ShipwideAIFlags.AIFlags.CARRIER_FIGHTER_TARGET, 1.0f, ship.getAIFlags().getCustom(ShipwideAIFlags.AIFlags.CARRIER_FIGHTER_TARGET));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.repulseNearbyShips(ship, wagonSegments, amount);
    }

    private void repulseNearbyShips(ShipAPI parent, TrainWagon[] wagonSegments, float amount) {
        this._repulseInterval.advance(amount);
        if (!this._repulseInterval.intervalElapsed()) {
            return;
        }
        try {
            for (TrainWagon tw : wagonSegments) {
                for (ShipAPI near : CombatUtils.getShipsWithinRange((Vector2f)tw.ship.getLocation(), (float)170.0f)) {
                    if (near.isShuttlePod() || near.isFighter() || near.isDrone() || !near.isAlive() || near.getOwner() != tw.ship.getOwner() || near.getHullSpec().getBaseHullId().startsWith("edshipyard_newfoundland") && Utils.getRoot(near) == parent || MathUtils.getDistance((Vector2f)near.getLocation(), (Vector2f)tw.ship.getLocation()) > 370.0f || !(near.getVelocity().length() < 100.0f)) continue;
                    int force = 300;
                    if (MathUtils.isWithinRange((Vector2f)tw.ship.getLocation(), (Vector2f)near.getLocation(), (float)25.0f) || near.isPhased()) {
                        force *= 2;
                    }
                    CombatUtils.applyForce((CombatEntityAPI)Utils.getRoot(near), (Vector2f)VectorUtils.getDirectionalVector((Vector2f)tw.ship.getLocation(), (Vector2f)near.getLocation()), (float)force);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private float normalizeAngle(float f) {
        if (f < 0.0f) {
            return f + 360.0f;
        }
        if (f > 360.0f) {
            return f - 360.0f;
        }
        return f;
    }

    private static void advanceChild(ShipAPI child, ShipAPI parent) {
        ShipEngineControllerAPI ec = parent.getEngineController();
        if (ec != null) {
            ShipEngineControllerAPI cec;
            if (parent.isAlive()) {
                if (ec.isAccelerating()) {
                    child.giveCommand(ShipCommand.ACCELERATE, null, 0);
                }
                if (ec.isAcceleratingBackwards()) {
                    child.giveCommand(ShipCommand.ACCELERATE_BACKWARDS, null, 0);
                }
                if (ec.isDecelerating()) {
                    child.giveCommand(ShipCommand.DECELERATE, null, 0);
                }
                if (ec.isStrafingLeft()) {
                    child.giveCommand(ShipCommand.STRAFE_LEFT, null, 0);
                }
                if (ec.isStrafingRight()) {
                    child.giveCommand(ShipCommand.STRAFE_RIGHT, null, 0);
                }
                if (ec.isTurningLeft()) {
                    child.giveCommand(ShipCommand.TURN_LEFT, null, 0);
                }
                if (ec.isTurningRight()) {
                    child.giveCommand(ShipCommand.TURN_RIGHT, null, 0);
                }
            }
            if ((cec = child.getEngineController()) != null && (ec.isFlamingOut() || ec.isFlamedOut()) && !cec.isFlamingOut() && !cec.isFlamedOut()) {
                child.getEngineController().forceFlameout(true);
            }
        }
    }

    private void advanceParent(ShipAPI parent, List<ShipAPI> children, float amount) {
        this._parentInterval.advance(amount);
        if (!this._parentInterval.intervalElapsed()) {
            return;
        }
        ShipEngineControllerAPI ec = parent.getEngineController();
        if (ec != null) {
            float originalMass = 17000.0f;
            int originalEngines = 16;
            float thrustPerEngine = originalMass / (float)originalEngines;
            float workingEngines = ec.getShipEngines().size();
            for (ShipAPI child : children) {
                ShipEngineControllerAPI cec;
                if (child.getParentStation() != parent || child.getStationSlot() == null || !child.isAlive() || (cec = child.getEngineController()) == null) continue;
                float contribution = 0.0f;
                for (ShipEngineControllerAPI.ShipEngineAPI ce : cec.getShipEngines()) {
                    if (!ce.isActive() || ce.isDisabled() || ce.isPermanentlyDisabled() || ce.isSystemActivated()) continue;
                    contribution += ce.getContribution();
                }
                workingEngines += (float)cec.getShipEngines().size() * contribution;
            }
            float thrust = workingEngines * thrustPerEngine;
            float enginePerformance = thrust / Math.max(1.0f, TrainLocomotive.getTrainMass(parent, children));
            parent.getMutableStats().getZeroFluxSpeedBoost().modifyMult("ED_trainlocomotive", enginePerformance);
            parent.getMutableStats().getTurnAcceleration().modifyMult("ED_trainlocomotive", enginePerformance);
            parent.getMutableStats().getAcceleration().modifyMult("ED_trainlocomotive", enginePerformance);
            parent.getMutableStats().getMaxTurnRate().modifyMult("ED_trainlocomotive", enginePerformance);
            parent.getMutableStats().getMaxSpeed().modifyMult("ED_trainlocomotive", enginePerformance);
        }
    }

    private static float getTrainMass(ShipAPI ship, List<ShipAPI> modules) {
        float mass = ship.getMass();
        if (modules != null) {
            for (ShipAPI m : modules) {
                if (m == null || !m.isAlive()) continue;
                mass += m.getMass();
            }
        }
        return mass;
    }

    public TrainWagon[] getTrainWagon(List<ShipAPI> childModules) {
        TrainWagon[] segments = new TrainWagon[5];
        for (int f = 0; f < segments.length; ++f) {
            segments[f] = new TrainWagon();
            if (f > 0) {
                segments[f].previousSegment = segments[f - 1];
                segments[f - 1].nextSegment = segments[f];
            }
            for (ShipAPI s : childModules) {
                s.ensureClonedStationSlotSpec();
                if (s.getStationSlot() == null || !s.getStationSlot().getId().equals(SEGMENT_NAMES[f])) continue;
                segments[f].ship = s;
                if (f != 0) continue;
                segments[f].previousSegment = new TrainWagon();
                segments[f].previousSegment.ship = s.getParentStation();
                segments[f].previousSegment.nextSegment = segments[f];
            }
        }
        return segments;
    }

    public TrainWagon[] removeDeadSegments(TrainWagon[] wagonSegments) {
        ArrayList<TrainWagon> ret = new ArrayList<TrainWagon>();
        for (int f = 0; f < 5; ++f) {
            TrainWagon tw = wagonSegments[f];
            if (tw != null && tw.ship != null && tw.ship.isAlive()) {
                ret.add(tw);
                continue;
            }
            for (int g = f; g < 5; ++g) {
                if (wagonSegments[g] == null || wagonSegments[g].ship == null || !wagonSegments[g].ship.isAlive()) continue;
                wagonSegments[g].ship.setHitpoints(1.0f);
                try {
                    Global.getCombatEngine().applyDamage((CombatEntityAPI)wagonSegments[g].ship, wagonSegments[g].ship.getLocation(), 1000.0f, DamageType.HIGH_EXPLOSIVE, 0.0f, true, false, null);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return ret.toArray(new TrainWagon[0]);
    }

    public static class TrainWagon {
        public ShipAPI ship = null;
        public TrainWagon nextSegment = null;
        public TrainWagon previousSegment = null;

        boolean isFirst() {
            return this.previousSegment != null && this.previousSegment.ship.getHullSpec().getBaseHullId().equals("edshipyard_newfoundland");
        }
    }
}

